/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Filter;

public class PermissionFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PermissionFilter.class);
    protected final Set<String> required;
    protected final Set<String> excluded;

    public PermissionFilter(List<String> required, List<String> excluded) {
        this.required = required == null ? Collections.emptySet() : new HashSet<String>(required);
        this.excluded = excluded == null ? Collections.emptySet() : new HashSet<String>(excluded);
    }

    public PermissionFilter(String permission, boolean isRequired) {
        if (isRequired) {
            this.required = Collections.singleton(permission);
            this.excluded = Collections.emptySet();
        } else {
            this.required = Collections.emptySet();
            this.excluded = Collections.singleton(permission);
        }
    }

    @Override
    public boolean accept(DocumentModel docModel) {
        CoreSession session = docModel.getCoreSession();
        return session != null && this.hasPermission(session, docModel, this.excluded, false) && this.hasPermission(session, docModel, this.required, true);
    }

    protected boolean hasPermission(CoreSession session, DocumentModel doc, Set<String> permissions, boolean required) {
        for (String permission : permissions) {
            try {
                if ((!required || session.hasPermission(doc.getRef(), permission)) && (required || !session.hasPermission(doc.getRef(), permission))) continue;
                return false;
            }
            catch (ClientException e) {
                String message = String.format("Unable to check '%s' permission for document '%s': %s", permission, doc.getPathAsString(), e.getMessage());
                log.warn((Object)message);
                log.debug((Object)message, (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

