/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.io.InputStream;
import java.io.Serializable;
import java.security.Principal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.ecm.core.CoreService;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ConcurrentUpdateDocumentException;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DetachedAdapter;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelFactory;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentResolver;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.SerializableInputStream;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.DocumentModelChildrenIterator;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.api.impl.VersionModelImpl;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.UserEntry;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.api.security.impl.UserEntryImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.DocumentProxy;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.core.model.PathComparator;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.query.FilterableQuery;
import org.nuxeo.ecm.core.query.Query;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.QueryResult;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;

public abstract class AbstractSession
implements CoreSession,
Serializable {
    public static final NuxeoPrincipal ANONYMOUS = new UserPrincipal("anonymous", new ArrayList(), true, false);
    private static final Log log = LogFactory.getLog(CoreSession.class);
    private static final long serialVersionUID = 6585443198474361876L;
    private static final Comparator<? super Document> pathComparator = new PathComparator();
    public static final String DEFAULT_MAX_RESULTS = "1000";
    public static final String MAX_RESULTS_PROPERTY = "org.nuxeo.ecm.core.max.results";
    public static final String LIMIT_RESULTS_PROPERTY = "org.nuxeo.ecm.core.limit.results";
    public static final String BINARY_TEXT_SYS_PROP = "binaryText";
    private Boolean limitedResults;
    private Long maxResults;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected Counter createDocumentCount;
    protected Counter deleteDocumentCount;
    protected Counter updateDocumentCount;
    private transient SecurityService securityService;
    private transient VersioningService versioningService;
    protected final DocumentResolver documentResolver = new DocumentResolver();
    protected static final PathRef EMPTY_PATH = new PathRef("");

    protected void createMetrics() {
        this.createDocumentCount = this.registry.counter(MetricRegistry.name((String)"nuxeo.repositories", (String[])new String[]{this.getRepositoryName(), "documents", "create"}));
        this.deleteDocumentCount = this.registry.counter(MetricRegistry.name((String)"nuxeo.repositories", (String[])new String[]{this.getRepositoryName(), "documents", "delete"}));
        this.updateDocumentCount = this.registry.counter(MetricRegistry.name((String)"nuxeo.repositories", (String[])new String[]{this.getRepositoryName(), "documents", "update"}));
    }

    protected SecurityService getSecurityService() {
        if (this.securityService == null) {
            this.securityService = NXCore.getSecurityService();
        }
        return this.securityService;
    }

    protected VersioningService getVersioningService() {
        if (this.versioningService == null) {
            try {
                this.versioningService = (VersioningService)Framework.getService(VersioningService.class);
            }
            catch (Exception e) {
                throw new RuntimeException("VersioningService not found", e);
            }
        }
        return this.versioningService;
    }

    public abstract Session getSession() throws ClientException;

    public DocumentType getDocumentType(String type) {
        return ((SchemaManager)Framework.getLocalService(SchemaManager.class)).getDocumentType(type);
    }

    protected final void checkPermission(Document doc, String permission) throws DocumentSecurityException, DocumentException {
        if (this.isAdministrator()) {
            return;
        }
        if (!this.hasPermission(doc, permission)) {
            log.error((Object)("Permission '" + permission + "' is not granted to '" + this.getPrincipal().getName() + "' on document " + doc.getPath() + " (" + doc.getUUID() + " - " + doc.getType().getName() + ")"));
            throw new DocumentSecurityException("Privilege '" + permission + "' is not granted to '" + this.getPrincipal().getName() + "'");
        }
    }

    protected Map<String, Serializable> getContextMapEventInfo(DocumentModel doc) {
        ScopedMap ctxData;
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        if (doc != null && (ctxData = doc.getContextData()) != null) {
            options.putAll(ctxData.getDefaultScopeValues());
            options.putAll(ctxData.getScopeValues(ScopeType.REQUEST));
        }
        return options;
    }

    public DocumentEventContext newEventContext(DocumentModel source) {
        DocumentEventContext ctx = new DocumentEventContext((CoreSession)this, this.getPrincipal(), source);
        ctx.setProperty("repositoryName", (Serializable)((Object)this.getRepositoryName()));
        ctx.setProperty("sessionId", (Serializable)((Object)this.getSessionId()));
        return ctx;
    }

    protected void notifyEvent(String eventId, DocumentModel source, Map<String, Serializable> options, String category, String comment, boolean withLifeCycle, boolean inline) throws ClientException {
        Boolean blockJms;
        DocumentEventContext ctx = new DocumentEventContext((CoreSession)this, this.getPrincipal(), source);
        if (options != null) {
            ctx.setProperties(options);
        }
        ctx.setProperty("repositoryName", (Serializable)((Object)this.getRepositoryName()));
        ctx.setProperty("sessionId", (Serializable)((Object)this.getSessionId()));
        if (source != null && withLifeCycle) {
            String currentLifeCycleState = null;
            try {
                currentLifeCycleState = source.getCurrentLifeCycleState();
            }
            catch (ClientException err) {
                // empty catch block
            }
            ctx.setProperty("documentLifeCycle", (Serializable)((Object)currentLifeCycleState));
        }
        if (comment != null) {
            ctx.setProperty("comment", (Serializable)((Object)comment));
        }
        ctx.setProperty("category", (Serializable)((Object)(category == null ? "eventDocumentCategory" : category)));
        Event event = ctx.newEvent(eventId);
        if ("sessionSaved".equals(eventId)) {
            event.setIsCommitEvent(true);
        }
        if (inline) {
            event.setInline(true);
        }
        if (source != null && (blockJms = (Boolean)source.getContextData("BLOCK_JMS_PRODUCING")) != null && blockJms.booleanValue()) {
            event.setLocal(true);
            event.setInline(true);
        }
        ((EventService)Framework.getLocalService(EventService.class)).fireEvent(event);
    }

    protected void notifyVersionChange(DocumentModel oldDocument, DocumentModel newDocument, Map<String, Serializable> options) throws ClientException {
        HashMap<String, Serializable> info = new HashMap<String, Serializable>();
        if (options != null) {
            info.putAll(options);
        }
        info.put("newDoc", (Serializable)newDocument);
        info.put("oldDoc", (Serializable)oldDocument);
        this.notifyEvent("versioningChangeCoreEvent", newDocument, info, "clientCodeNotificationCategory", null, false, false);
    }

    public boolean hasPermission(Principal principal, DocumentRef docRef, String permission) throws ClientException {
        try {
            Session session = this.getSession();
            Document doc = DocumentResolver.resolveReference(session, docRef);
            return this.hasPermission(principal, doc, permission);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to resolve document ref: " + docRef.toString(), (Throwable)e);
        }
    }

    protected final boolean hasPermission(Principal principal, Document doc, String permission) throws DocumentException {
        return this.getSecurityService().checkPermission(doc, principal, permission);
    }

    public boolean hasPermission(DocumentRef docRef, String permission) throws ClientException {
        try {
            Session session = this.getSession();
            Document doc = DocumentResolver.resolveReference(session, docRef);
            return this.hasPermission(doc, permission);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to resolve document ref: " + docRef.toString(), (Throwable)e);
        }
    }

    protected final boolean hasPermission(Document doc, String permission) throws DocumentException {
        return this.getSecurityService().checkPermission(doc, this.getPrincipal(), permission);
    }

    protected final Document resolveReference(DocumentRef docRef) throws DocumentException, ClientException {
        return DocumentResolver.resolveReference(this.getSession(), docRef);
    }

    protected DocumentModel readModel(Document doc) throws ClientException {
        try {
            return DocumentModelFactory.createDocumentModel(doc, null);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to create document model", (Throwable)e);
        }
    }

    protected DocumentModel readModel(Document doc, DocumentModel docModel) throws ClientException {
        DocumentModel newModel = this.readModel(doc);
        newModel.copyContextData(docModel);
        return newModel;
    }

    @Deprecated
    protected DocumentModel readModel(Document doc, String[] schemas) throws ClientException {
        try {
            return DocumentModelFactory.createDocumentModel(doc, schemas);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to create document model", (Throwable)e);
        }
    }

    protected DocumentModel writeModel(Document doc, DocumentModel docModel) throws DocumentException, ClientException {
        return DocumentModelFactory.writeDocumentModel(docModel, doc);
    }

    public DocumentModel copy(DocumentRef src, DocumentRef dst, String name, boolean resetLifeCycle) throws ClientException {
        try {
            Document dstDoc = this.resolveReference(dst);
            this.checkPermission(dstDoc, "AddChildren");
            Document srcDoc = this.resolveReference(src);
            if (name == null) {
                name = srcDoc.getName();
            }
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            options.put("sourceRef", (Serializable)src);
            options.put("destinationRef", (Serializable)dst);
            options.put("destinationPath", (Serializable)((Object)dstDoc.getPath()));
            options.put("destinationName", (Serializable)((Object)name));
            options.put("destinationExists", Boolean.valueOf(dstDoc.hasChild(name)));
            options.put("resetLifeCycle", Boolean.valueOf(resetLifeCycle));
            DocumentModel srcDocModel = this.readModel(srcDoc);
            this.notifyEvent("aboutToCopy", srcDocModel, options, null, null, true, true);
            name = (String)options.get("destinationName");
            Document doc = this.getSession().copy(srcDoc, dstDoc, name);
            DocumentModel docModel = this.readModel(doc);
            String comment = srcDoc.getRepositoryName() + ':' + src.toString();
            this.notifyEvent("documentCreatedByCopy", docModel, options, null, comment, true, false);
            docModel = this.writeModel(doc, docModel);
            comment = doc.getRepositoryName() + ':' + docModel.getRef().toString();
            this.notifyEvent("documentDuplicated", srcDocModel, options, null, comment, true, false);
            return docModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to copy document: " + e.getMessage(), (Throwable)e);
        }
    }

    public DocumentModel copy(DocumentRef src, DocumentRef dst, String name) throws ClientException {
        return this.copy(src, dst, name, false);
    }

    public List<DocumentModel> copy(List<DocumentRef> src, DocumentRef dst, boolean resetLifeCycle) throws ClientException {
        ArrayList<DocumentModel> newDocuments = new ArrayList<DocumentModel>();
        for (DocumentRef ref : src) {
            newDocuments.add(this.copy(ref, dst, null, resetLifeCycle));
        }
        return newDocuments;
    }

    public List<DocumentModel> copy(List<DocumentRef> src, DocumentRef dst) throws ClientException {
        return this.copy(src, dst, false);
    }

    public DocumentModel copyProxyAsDocument(DocumentRef src, DocumentRef dst, String name, boolean resetLifeCycle) throws ClientException {
        try {
            Document srcDoc = this.resolveReference(src);
            if (!srcDoc.isProxy()) {
                return this.copy(src, dst, name);
            }
            Document dstDoc = this.resolveReference(dst);
            this.checkPermission(dstDoc, "Write");
            DocumentModel srcDocModel = this.readModel(srcDoc);
            String docName = name != null ? name : srcDocModel.getName();
            DocumentModel docModel = this.createDocumentModel(dstDoc.getPath(), docName, srcDocModel.getType());
            docModel.copyContent(srcDocModel);
            this.notifyEvent("aboutToCopy", srcDocModel, null, null, null, true, true);
            docModel = this.createDocument(docModel);
            Document doc = this.resolveReference(docModel.getRef());
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            options.put("resetLifeCycle", Boolean.valueOf(resetLifeCycle));
            String comment = srcDoc.getRepositoryName() + ':' + src.toString();
            this.notifyEvent("documentCreatedByCopy", docModel, options, null, comment, true, false);
            comment = doc.getRepositoryName() + ':' + docModel.getRef().toString();
            this.notifyEvent("documentDuplicated", srcDocModel, options, null, comment, true, false);
            return docModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to copy document: " + e.getMessage(), (Throwable)e);
        }
    }

    public DocumentModel copyProxyAsDocument(DocumentRef src, DocumentRef dst, String name) throws ClientException {
        return this.copyProxyAsDocument(src, dst, name, false);
    }

    public List<DocumentModel> copyProxyAsDocument(List<DocumentRef> src, DocumentRef dst, boolean resetLifeCycle) throws ClientException {
        ArrayList<DocumentModel> newDocuments = new ArrayList<DocumentModel>();
        for (DocumentRef ref : src) {
            newDocuments.add(this.copyProxyAsDocument(ref, dst, null, resetLifeCycle));
        }
        return newDocuments;
    }

    public List<DocumentModel> copyProxyAsDocument(List<DocumentRef> src, DocumentRef dst) throws ClientException {
        return this.copyProxyAsDocument(src, dst, false);
    }

    public DocumentModel move(DocumentRef src, DocumentRef dst, String name) throws ClientException {
        try {
            Document dstDoc;
            Document srcDoc = this.resolveReference(src);
            if (dst == null) {
                dstDoc = srcDoc.getParent();
                this.checkPermission(dstDoc, "WriteProperties");
            } else {
                dstDoc = this.resolveReference(dst);
                this.checkPermission(dstDoc, "AddChildren");
                this.checkPermission(srcDoc.getParent(), "RemoveChildren");
                this.checkPermission(srcDoc, "Remove");
            }
            DocumentModel srcDocModel = this.readModel(srcDoc);
            if (name == null) {
                name = srcDocModel.getName();
            }
            Map<String, Serializable> options = this.getContextMapEventInfo(srcDocModel);
            options.put("sourceRef", (Serializable)src);
            options.put("destinationRef", (Serializable)dst);
            options.put("destinationPath", (Serializable)((Object)dstDoc.getPath()));
            options.put("destinationName", (Serializable)((Object)name));
            options.put("destinationExists", Boolean.valueOf(dstDoc.hasChild(name)));
            this.notifyEvent("aboutToMove", srcDocModel, options, null, null, true, true);
            name = (String)((Object)options.get("destinationName"));
            String comment = srcDoc.getRepositoryName() + ':' + srcDoc.getParent().getUUID();
            Document doc = this.getSession().move(srcDoc, dstDoc, name);
            DocumentModel docModel = this.readModel(doc);
            options.put("parentPath", (Serializable)srcDocModel.getParentRef());
            this.notifyEvent("documentMoved", docModel, options, null, comment, true, false);
            return docModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to move document: " + e.getMessage(), (Throwable)e);
        }
    }

    public void move(List<DocumentRef> src, DocumentRef dst) throws ClientException {
        for (DocumentRef ref : src) {
            this.move(ref, dst, null);
        }
    }

    public ACP getACP(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadSecurity");
            return this.getSession().getMergedACP(doc);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get acp", (Throwable)e);
        }
    }

    public void setACP(DocumentRef docRef, ACP newAcp, boolean overwrite) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "WriteSecurity");
            DocumentModel docModel = this.readModel(doc);
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            options.put("oldACP", (Serializable)docModel.getACP().clone());
            options.put("newACP", (Serializable)newAcp.clone());
            this.notifyEvent("beforeDocumentSecurityModification", docModel, options, null, null, true, true);
            this.getSession().setACP(doc, newAcp, overwrite);
            docModel = this.readModel(doc);
            this.notifyEvent("documentSecurityUpdated", docModel, options, null, null, true, false);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to set acp", (Throwable)e);
        }
    }

    public void cancel() {
    }

    private DocumentModel createDocumentModelFromTypeName(String typeName, Map<String, Serializable> options) throws ClientException {
        try {
            DocumentType docType = this.getSession().getTypeManager().getDocumentType(typeName);
            if (docType == null) {
                throw new ClientException(typeName + " is not a registered core type");
            }
            DocumentModelImpl docModel = DocumentModelFactory.createDocumentModel(this.getSessionId(), docType);
            if (options == null) {
                options = new HashMap<String, Serializable>();
            }
            options.put("BLOCK_JMS_PRODUCING", Boolean.valueOf(true));
            this.notifyEvent("emptyDocumentModelCreated", (DocumentModel)docModel, options, null, null, false, true);
            return docModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to create document model", (Throwable)e);
        }
    }

    public DocumentModel createDocumentModel(String typeName) throws ClientException {
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        return this.createDocumentModelFromTypeName(typeName, options);
    }

    public DocumentModel createDocumentModel(String parentPath, String id, String typeName) throws ClientException {
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        options.put("parentPath", (Serializable)((Object)parentPath));
        options.put("documentModelId", (Serializable)((Object)id));
        DocumentModel model = this.createDocumentModelFromTypeName(typeName, options);
        model.setPathInfo(parentPath, id);
        return model;
    }

    public DocumentModel createDocumentModel(String typeName, Map<String, Object> options) throws ClientException {
        HashMap<String, Serializable> serializableOptions = new HashMap<String, Serializable>();
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            serializableOptions.put(entry.getKey(), (Serializable)entry.getValue());
        }
        return this.createDocumentModelFromTypeName(typeName, serializableOptions);
    }

    public DocumentModel createDocument(DocumentModel docModel) throws ClientException {
        String typeName = docModel.getType();
        DocumentRef parentRef = docModel.getParentRef();
        if (typeName == null) {
            throw new ClientException(String.format("cannot create document '%s' with undefined type name", docModel.getTitle()));
        }
        if (parentRef == null && !this.isAdministrator()) {
            throw new ClientException("Only Administrators can create placeless documents");
        }
        String childName = docModel.getName();
        try {
            Map<String, Serializable> options = this.getContextMapEventInfo(docModel);
            Document folder = this.fillCreateOptions(parentRef, childName, options);
            String initialLifecycleState = null;
            Serializable lifecycleStateInfo = docModel.getContextData("initialLifecycleState");
            if (lifecycleStateInfo instanceof String) {
                initialLifecycleState = (String)((Object)lifecycleStateInfo);
            }
            this.notifyEvent("aboutToCreate", docModel, options, null, null, false, true);
            childName = (String)((Object)options.get("destinationName"));
            Document doc = folder.addChild(childName, typeName);
            for (String facetName : docModel.getFacets()) {
                if (doc.getAllFacets().contains(facetName) || "Immutable".equals(facetName)) continue;
                doc.addFacet(facetName);
            }
            LifeCycleService service = NXCore.getLifeCycleService();
            if (service != null) {
                try {
                    service.initialize(doc, initialLifecycleState);
                }
                catch (Exception e) {
                    throw new ClientException("Failed to initialize document lifecycle", (Throwable)e);
                }
            } else {
                log.debug((Object)"No lifecycle service registered");
            }
            docModel = this.writeModel(doc, docModel);
            if (!Boolean.TRUE.equals(docModel.getContextData(ScopeType.REQUEST, "SKIP_VERSIONING"))) {
                this.getVersioningService().doPostCreate(doc, options);
                docModel = this.readModel(doc, docModel);
            }
            this.notifyEvent("documentCreated", docModel, options, null, null, true, false);
            docModel = this.writeModel(doc, docModel);
            this.createDocumentCount.inc();
            return docModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to create document: " + childName, (Throwable)e);
        }
    }

    protected Document fillCreateOptions(DocumentRef parentRef, String childName, Map<String, Serializable> options) throws DocumentException, ClientException, DocumentSecurityException {
        Document folder;
        if (parentRef == null || EMPTY_PATH.equals((Object)parentRef)) {
            folder = this.getSession().getNullDocument();
            options.put("destinationRef", null);
            options.put("destinationPath", null);
            options.put("destinationName", (Serializable)((Object)childName));
            options.put("destinationExists", Boolean.valueOf(false));
        } else {
            folder = this.resolveReference(parentRef);
            this.checkPermission(folder, "AddChildren");
            options.put("destinationRef", (Serializable)parentRef);
            options.put("destinationPath", (Serializable)((Object)folder.getPath()));
            options.put("destinationName", (Serializable)((Object)childName));
            options.put("destinationExists", Boolean.valueOf(folder.hasChild(childName)));
        }
        return folder;
    }

    public void importDocuments(List<DocumentModel> docModels) throws ClientException {
        try {
            for (DocumentModel docModel : docModels) {
                this.importDocument(docModel);
            }
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to import documents", (Throwable)e);
        }
    }

    protected void importDocument(DocumentModel docModel) throws DocumentException, ClientException {
        if (!this.isAdministrator()) {
            throw new DocumentSecurityException("Only Administrator can import");
        }
        String name = docModel.getName();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid empty name");
        }
        String typeName = docModel.getType();
        if (typeName == null || typeName.length() == 0) {
            throw new IllegalArgumentException("Invalid empty type");
        }
        String id = docModel.getId();
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("Invalid empty id");
        }
        DocumentRef parentRef = docModel.getParentRef();
        Map<String, Serializable> props = this.getContextMapEventInfo(docModel);
        if (parentRef != null && EMPTY_PATH.equals((Object)parentRef)) {
            parentRef = null;
        }
        Document parent = this.fillCreateOptions(parentRef, name, props);
        this.notifyEvent("aboutToImport", docModel, props, null, null, false, true);
        name = (String)((Object)props.get("destinationName"));
        Document doc = this.getSession().importDocument(id, parentRef == null ? null : parent, name, typeName, props);
        docModel = typeName.equals("ecm:proxy") ? this.readModel(doc) : this.writeModel(doc, docModel);
        this.notifyEvent("documentImported", docModel, null, null, null, true, false);
    }

    public DocumentModel[] createDocument(DocumentModel[] docModels) throws ClientException {
        DocumentModel[] models = new DocumentModel[docModels.length];
        int i = 0;
        for (DocumentModel docModel : docModels) {
            models[i++] = this.createDocument(docModel);
        }
        return models;
    }

    public boolean exists(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            return this.hasPermission(doc, "Browse");
        }
        catch (NoSuchDocumentException e) {
            return false;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to check existence of " + docRef, (Throwable)e);
        }
    }

    public DocumentModel getChild(DocumentRef parent, String name) throws ClientException {
        try {
            Document doc = this.resolveReference(parent);
            this.checkPermission(doc, "ReadChildren");
            Document child = doc.getChild(name);
            this.checkPermission(child, "Read");
            return this.readModel(child);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get child " + name, (Throwable)e);
        }
    }

    public DocumentModelList getChildren(DocumentRef parent) throws ClientException {
        return this.getChildren(parent, null, "Read", null, null);
    }

    public DocumentModelList getChildren(DocumentRef parent, String type) throws ClientException {
        return this.getChildren(parent, type, "Read", null, null);
    }

    public DocumentModelList getChildren(DocumentRef parent, String type, String perm) throws ClientException {
        return this.getChildren(parent, type, perm, null, null);
    }

    public DocumentModelList getChildren(DocumentRef parent, String type, Filter filter, Sorter sorter) throws ClientException {
        return this.getChildren(parent, type, null, filter, sorter);
    }

    public DocumentModelList getChildren(DocumentRef parent, String type, String perm, Filter filter, Sorter sorter) throws ClientException {
        try {
            if (perm == null) {
                perm = "Read";
            }
            Document doc = this.resolveReference(parent);
            this.checkPermission(doc, "ReadChildren");
            Iterator<Document> children = doc.getChildren();
            DocumentModelListImpl docs = new DocumentModelListImpl();
            while (children.hasNext()) {
                Document child = children.next();
                if (!this.hasPermission(child, perm) || child.getType() == null || type != null && !type.equals(child.getType().getName())) continue;
                DocumentModel childModel = this.readModel(child);
                if (filter != null && !filter.accept(childModel)) continue;
                docs.add((Object)childModel);
            }
            if (sorter != null) {
                Collections.sort(docs, sorter);
            }
            return docs;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get children for " + parent.toString(), (Throwable)e);
        }
    }

    public List<DocumentRef> getChildrenRefs(DocumentRef parentRef, String perm) throws ClientException {
        if (perm != null) {
            throw new ClientException("perm != null not implemented");
        }
        try {
            Document parent = this.resolveReference(parentRef);
            this.checkPermission(parent, "ReadChildren");
            List<String> ids = parent.getChildrenIds();
            ArrayList<DocumentRef> refs = new ArrayList<DocumentRef>(ids.size());
            for (String id : ids) {
                refs.add((DocumentRef)new IdRef(id));
            }
            return refs;
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public DocumentModelIterator getChildrenIterator(DocumentRef parent) throws ClientException {
        return this.getChildrenIterator(parent, null, null, null);
    }

    public DocumentModelIterator getChildrenIterator(DocumentRef parent, String type) throws ClientException {
        return this.getChildrenIterator(parent, type, null, null);
    }

    public DocumentModelIterator getChildrenIterator(DocumentRef parent, String type, String perm, Filter filter) throws ClientException {
        return new DocumentModelChildrenIterator((CoreSession)this, parent, type, filter);
    }

    public DocumentModel getDocument(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Read");
            return this.readModel(doc);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get document " + docRef.toString(), (Throwable)e);
        }
    }

    public DocumentModelList getDocuments(DocumentRef[] docRefs) throws ClientException {
        ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>(docRefs.length);
        for (DocumentRef docRef : docRefs) {
            Document doc;
            try {
                doc = this.resolveReference(docRef);
                this.checkPermission(doc, "Read");
            }
            catch (DocumentException e) {
                continue;
            }
            docs.add(this.readModel(doc));
        }
        return new DocumentModelListImpl(docs);
    }

    public DocumentModelList getFiles(DocumentRef parent) throws ClientException {
        try {
            Document doc = this.resolveReference(parent);
            this.checkPermission(doc, "ReadChildren");
            Iterator<Document> children = doc.getChildren();
            DocumentModelListImpl docs = new DocumentModelListImpl();
            while (children.hasNext()) {
                Document child = children.next();
                if (child.isFolder() || !this.hasPermission(child, "Read")) continue;
                docs.add((Object)this.readModel(child));
            }
            return docs;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get leaf children for " + parent.toString(), (Throwable)e);
        }
    }

    public DocumentModelList getFiles(DocumentRef parent, Filter filter, Sorter sorter) throws ClientException {
        try {
            Document doc = this.resolveReference(parent);
            this.checkPermission(doc, "ReadChildren");
            Iterator<Document> children = doc.getChildren();
            DocumentModelListImpl docs = new DocumentModelListImpl();
            while (children.hasNext()) {
                Document child = children.next();
                if (child.isFolder() || !this.hasPermission(child, "Read")) continue;
                DocumentModel docModel = this.readModel(doc);
                if (filter != null && !filter.accept(docModel)) continue;
                docs.add((Object)this.readModel(child));
            }
            if (sorter != null) {
                Collections.sort(docs, sorter);
            }
            return docs;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get files for " + parent.toString(), (Throwable)e);
        }
    }

    public DocumentModelList getFolders(DocumentRef parent) throws ClientException {
        try {
            Document doc = this.resolveReference(parent);
            this.checkPermission(doc, "ReadChildren");
            Iterator<Document> children = doc.getChildren();
            DocumentModelListImpl docs = new DocumentModelListImpl();
            while (children.hasNext()) {
                Document child = children.next();
                if (!child.isFolder() || !this.hasPermission(child, "Read")) continue;
                docs.add((Object)this.readModel(child));
            }
            return docs;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get folders " + parent, (Throwable)e);
        }
    }

    public DocumentModelList getFolders(DocumentRef parent, Filter filter, Sorter sorter) throws ClientException {
        try {
            Document doc = this.resolveReference(parent);
            this.checkPermission(doc, "ReadChildren");
            Iterator<Document> children = doc.getChildren();
            DocumentModelListImpl docs = new DocumentModelListImpl();
            while (children.hasNext()) {
                Document child = children.next();
                if (!child.isFolder() || !this.hasPermission(child, "Read")) continue;
                DocumentModel childModel = this.readModel(child);
                if (filter != null && !filter.accept(childModel)) continue;
                docs.add((Object)childModel);
            }
            if (sorter != null) {
                Collections.sort(docs, sorter);
            }
            return docs;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get folders " + parent.toString(), (Throwable)e);
        }
    }

    public DocumentRef getParentDocumentRef(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            Document parentDoc = doc.getParent();
            return parentDoc != null ? new IdRef(parentDoc.getUUID()) : null;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get parent document ref for: " + docRef, (Throwable)e);
        }
    }

    public DocumentModel getParentDocument(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            Document parentDoc = doc.getParent();
            if (parentDoc == null) {
                return null;
            }
            if (!this.hasPermission(parentDoc, "Read")) {
                throw new DocumentSecurityException("Privilege READ is not granted to " + this.getPrincipal().getName());
            }
            return this.readModel(parentDoc);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get parent document of " + docRef, (Throwable)e);
        }
    }

    public List<DocumentModel> getParentDocuments(DocumentRef docRef) throws ClientException {
        if (null == docRef) {
            throw new IllegalArgumentException("null docRef");
        }
        ArrayList<DocumentModel> docsList = new ArrayList<DocumentModel>();
        try {
            for (Document doc = this.resolveReference(docRef); doc != null && !"/".equals(doc.getPath()) && this.hasPermission(doc, "Read"); doc = doc.getParent()) {
                docsList.add(this.readModel(doc));
            }
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get parent documents: " + docRef, (Throwable)e);
        }
        Collections.reverse(docsList);
        return docsList;
    }

    public DocumentModel getRootDocument() throws ClientException {
        try {
            return this.readModel(this.getSession().getRootDocument());
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get the root document", (Throwable)e);
        }
    }

    public boolean hasChildren(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Browse");
            return doc.hasChildren();
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to check for children for " + docRef, (Throwable)e);
        }
    }

    public DocumentModelList query(String query) throws ClientException {
        return this.query(query, null, 0L, 0L, false);
    }

    public DocumentModelList query(String query, int max) throws ClientException {
        return this.query(query, null, (long)max, 0L, false);
    }

    public DocumentModelList query(String query, Filter filter) throws ClientException {
        return this.query(query, filter, 0L, 0L, false);
    }

    public DocumentModelList query(String query, Filter filter, int max) throws ClientException {
        return this.query(query, filter, (long)max, 0L, false);
    }

    public DocumentModelList query(String query, Filter filter, long limit, long offset, boolean countTotal) throws ClientException {
        return this.query(query, "NXQL", filter, limit, offset, countTotal);
    }

    public DocumentModelList query(String query, String queryType, Filter filter, long limit, long offset, boolean countTotal) throws ClientException {
        long countUpTo = !countTotal ? 0L : (this.isLimitedResults() ? this.getMaxResults() : -1L);
        return this.query(query, queryType, filter, limit, offset, countUpTo);
    }

    protected long getMaxResults() {
        if (this.maxResults == null) {
            this.maxResults = Long.parseLong(Framework.getProperty((String)MAX_RESULTS_PROPERTY, (String)DEFAULT_MAX_RESULTS));
        }
        return this.maxResults;
    }

    protected boolean isLimitedResults() {
        if (this.limitedResults == null) {
            this.limitedResults = Boolean.parseBoolean(Framework.getProperty((String)LIMIT_RESULTS_PROPERTY));
        }
        return this.limitedResults;
    }

    protected void setMaxResults(long maxResults) {
        this.maxResults = maxResults;
    }

    protected void setLimitedResults(boolean limitedResults) {
        this.limitedResults = limitedResults;
    }

    public DocumentModelList query(String query, Filter filter, long limit, long offset, long countUpTo) throws ClientException {
        return this.query(query, "NXQL", filter, limit, offset, countUpTo);
    }

    public DocumentModelList query(String query, String queryType, Filter filter, long limit, long offset, long countUpTo) throws ClientException {
        SecurityService securityService = this.getSecurityService();
        Principal principal = this.getPrincipal();
        try {
            QueryResult results;
            boolean postFilter;
            boolean postFilterFilter;
            boolean postFilterPolicies;
            boolean postFilterPermission;
            Query compiledQuery = this.getSession().createQuery(query, queryType, new String[0]);
            String permission = "Browse";
            if (compiledQuery instanceof FilterableQuery) {
                postFilterPermission = false;
                String repoName = this.getRepositoryName();
                postFilterPolicies = !securityService.arePoliciesExpressibleInQuery(repoName);
                postFilterFilter = filter != null && !(filter instanceof FacetFilter);
                postFilter = postFilterPolicies || postFilterFilter;
                String[] principals = this.isAdministrator() ? null : SecurityService.getPrincipalsToCheck(principal);
                String[] permissions = securityService.getPermissionsToCheck(permission);
                QueryFilter queryFilter = new QueryFilter(principal, principals, permissions, filter instanceof FacetFilter ? (FacetFilter)filter : null, securityService.getPoliciesQueryTransformers(repoName), postFilter ? 0L : limit, postFilter ? 0L : offset);
                results = postFilter ? ((FilterableQuery)compiledQuery).execute(queryFilter, -1L) : ((FilterableQuery)compiledQuery).execute(queryFilter, countUpTo);
            } else {
                postFilterPermission = true;
                postFilterPolicies = securityService.arePoliciesRestrictingPermission(permission);
                postFilterFilter = filter != null;
                postFilter = true;
                results = compiledQuery.execute();
            }
            DocumentModelList dms = results.getDocumentModels();
            if (!postFilter) {
                return dms;
            }
            long start = limit == 0L || offset < 0L ? 0L : offset;
            long stop = start + (limit == 0L ? (long)dms.size() : limit);
            int n = 0;
            DocumentModelListImpl docs = new DocumentModelListImpl();
            for (DocumentModel model : dms) {
                if ((postFilterPermission || postFilterPolicies) && !this.hasPermission(model.getRef(), permission) || postFilterFilter && !filter.accept(model)) continue;
                if ((long)n < start) {
                    ++n;
                    continue;
                }
                if ((long)n >= stop) {
                    if (countUpTo == 0L) break;
                    ++n;
                    continue;
                }
                ++n;
                docs.add((Object)model);
            }
            if (countUpTo != 0L) {
                docs.setTotalSize((long)n);
            }
            return docs;
        }
        catch (Exception e) {
            throw new ClientException("Failed to execute query: " + this.tryToExtractMeaningfulErrMsg(e), (Throwable)e);
        }
    }

    public IterableQueryResult queryAndFetch(String query, String queryType, Object ... params) throws ClientException {
        try {
            Collection<Object> transformers;
            SecurityService securityService = this.getSecurityService();
            Principal principal = this.getPrincipal();
            String[] principals = this.isAdministrator() ? null : SecurityService.getPrincipalsToCheck(principal);
            String permission = "Browse";
            String[] permissions = securityService.getPermissionsToCheck(permission);
            if ("NXQL".equals(queryType)) {
                String repoName = this.getRepositoryName();
                transformers = securityService.getPoliciesQueryTransformers(repoName);
            } else {
                transformers = Collections.emptyList();
            }
            QueryFilter queryFilter = new QueryFilter(principal, principals, permissions, null, transformers, 0L, 0L);
            IterableQueryResult result = this.getSession().queryAndFetch(query, queryType, queryFilter, params);
            return result;
        }
        catch (Exception e) {
            throw new ClientException("Failed to execute query: " + queryType + ": " + query + ": " + this.tryToExtractMeaningfulErrMsg(e), (Throwable)e);
        }
    }

    private String tryToExtractMeaningfulErrMsg(Throwable t) {
        if (t instanceof QueryParseException) {
            return t.getMessage();
        }
        if (t.getCause() != null) {
            return this.tryToExtractMeaningfulErrMsg(t.getCause());
        }
        return t.getMessage();
    }

    public void removeChildren(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "RemoveChildren");
            Iterator<Document> children = doc.getChildren();
            while (children.hasNext()) {
                Document child = children.next();
                if (!this.hasPermission(child, "Remove")) continue;
                this.removeNotifyOneDoc(child);
            }
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to remove children for " + docRef, (Throwable)e);
        }
    }

    public boolean canRemoveDocument(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            return this.canRemoveDocument(doc);
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected boolean canRemoveDocument(Document doc) throws ClientException, DocumentException {
        if (this.isAdministrator()) {
            return true;
        }
        if (doc.isVersion()) {
            Document working;
            Collection<Document> proxies = this.getSession().getProxies(doc, null);
            if (!proxies.isEmpty()) {
                return false;
            }
            try {
                working = doc.getSourceDocument();
            }
            catch (DocumentException e) {
                working = null;
            }
            if (working != null) {
                return this.hasPermission(working, "WriteVersion");
            }
            return false;
        }
        if (!this.hasPermission(doc, "Remove")) {
            return false;
        }
        Document parent = doc.getParent();
        return parent == null || this.hasPermission(parent, "RemoveChildren");
    }

    public void removeDocument(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.removeDocument(doc);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to fetch document " + docRef + " before removal", (Throwable)e);
        }
    }

    protected void removeDocument(Document doc) throws ClientException {
        try {
            if (!this.canRemoveDocument(doc)) {
                throw new DocumentSecurityException("Permission denied: cannot remove document " + doc.getUUID());
            }
            this.removeNotifyOneDoc(doc);
        }
        catch (ConcurrentUpdateDocumentException e) {
            throw new ConcurrentUpdateException("Failed to remove document " + doc.getUUID(), (Throwable)e);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to remove document " + doc.getUUID(), (Throwable)e);
        }
        this.deleteDocumentCount.inc();
    }

    protected void removeNotifyOneDoc(Document doc) throws ClientException, DocumentException {
        DocumentModel docModel = this.readModel(doc);
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        if (docModel != null) {
            options.put("docTitle", (Serializable)((Object)docModel.getTitle()));
        }
        String versionLabel = "";
        Document sourceDoc = null;
        if (!doc.isVersion()) {
            this.notifyEvent("aboutToRemove", docModel, options, null, null, true, true);
            CoreService coreService = (CoreService)((Object)Framework.getLocalService(CoreService.class));
            coreService.getVersionRemovalPolicy().removeVersions(this.getSession(), doc, this);
        } else {
            versionLabel = docModel.getVersionLabel();
            try {
                sourceDoc = doc.getSourceDocument();
            }
            catch (DocumentException e) {
                sourceDoc = null;
            }
            this.notifyEvent("aboutToRemoveVersion", docModel, options, null, null, true, true);
        }
        doc.remove();
        if (doc.isVersion() && sourceDoc != null) {
            DocumentModel sourceDocModel = this.readModel(sourceDoc);
            if (sourceDocModel != null) {
                options.put("comment", (Serializable)((Object)versionLabel));
                this.notifyEvent("versionRemoved", sourceDocModel, options, null, null, false, false);
                options.remove("comment");
            }
            options.put("docSource", (Serializable)((Object)sourceDoc.getUUID()));
        }
        this.notifyEvent("documentRemoved", docModel, options, null, null, false, false);
    }

    public void removeDocuments(DocumentRef[] docRefs) throws ClientException {
        Document[] docs = new Document[docRefs.length];
        for (int i = 0; i < docs.length; ++i) {
            try {
                docs[i] = this.resolveReference(docRefs[i]);
                continue;
            }
            catch (DocumentException e) {
                throw new ClientException("Failed to resolve reference " + docRefs[i], (Throwable)e);
            }
        }
        Arrays.sort(docs, pathComparator);
        String[] paths = new String[docs.length];
        try {
            for (int i = 0; i < docs.length; ++i) {
                paths[i] = docs[i].getPath();
            }
            String latestRemoved = null;
            for (int i = 0; i < docs.length; ++i) {
                if (i != 0 && paths[i].startsWith(latestRemoved + "/")) continue;
                this.removeDocument(docs[i]);
                latestRemoved = paths[i];
            }
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get path of document", (Throwable)e);
        }
    }

    public void save() throws ClientException {
        try {
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            this.getSession().save();
            this.notifyEvent("sessionSaved", null, options, null, null, true, false);
        }
        catch (ConcurrentUpdateDocumentException e) {
            throw new ConcurrentUpdateException("Failed to save session", (Throwable)e);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to save session", (Throwable)e);
        }
    }

    public DocumentModel saveDocument(DocumentModel docModel) throws ClientException {
        try {
            boolean setReadWrite;
            if (docModel.getRef() == null) {
                throw new ClientException(String.format("cannot save document '%s' with null reference: document has probably not yet been created in the repository with 'CoreSession.createDocument(docModel)'", docModel.getTitle()));
            }
            Document doc = this.resolveReference(docModel.getRef());
            this.checkPermission(doc, "WriteProperties");
            Map<String, Serializable> options = this.getContextMapEventInfo(docModel);
            options.put("previousDocumentModel", (Serializable)this.readModel(doc));
            options.put("destinationName", (Serializable)((Object)docModel.getName()));
            this.notifyEvent("beforeDocumentModification", docModel, options, null, null, true, true);
            String name = (String)((Object)options.get("destinationName"));
            if (name != null && !name.equals(docModel.getName())) {
                doc = this.getSession().move(doc, doc.getParent(), name);
            }
            VersioningOption versioningOption = (VersioningOption)docModel.getContextData("VersioningOption");
            docModel.putContextData("VersioningOption", null);
            String checkinComment = (String)((Object)docModel.getContextData("CheckinComment"));
            docModel.putContextData("CheckinComment", null);
            Boolean disableAutoCheckOut = (Boolean)docModel.getContextData("DisableAutoCheckOut");
            docModel.putContextData("DisableAutoCheckOut", null);
            options.put("DisableAutoCheckOut", disableAutoCheckOut);
            boolean snapshot = Boolean.TRUE.equals(docModel.getContextData(ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE"));
            docModel.putContextData(ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE", null);
            boolean dirty = docModel.isDirty();
            if (versioningOption == null && snapshot && dirty) {
                String key = String.valueOf(docModel.getContextData(ScopeType.REQUEST, "VersioningOption"));
                docModel.putContextData(ScopeType.REQUEST, "VersioningOption", null);
                VersioningOption versioningOption2 = versioningOption = "inc_major".equals(key) ? VersioningOption.MAJOR : VersioningOption.MINOR;
            }
            if (!docModel.isImmutable()) {
                boolean checkout = this.getVersioningService().isPreSaveDoingCheckOut(doc, dirty, versioningOption, options);
                if (checkout) {
                    this.notifyEvent("aboutToCheckout", docModel, options, null, null, true, true);
                }
                versioningOption = this.getVersioningService().doPreSave(doc, dirty, versioningOption, checkinComment, options);
                if (checkout) {
                    DocumentModel checkedOutDoc = this.readModel(doc);
                    this.notifyEvent("documentCheckedOut", checkedOutDoc, options, null, null, true, false);
                }
            }
            boolean allowVersionWrite = Boolean.TRUE.equals(docModel.getContextData("allowVersionWrite"));
            docModel.putContextData("allowVersionWrite", null);
            boolean bl = setReadWrite = allowVersionWrite && doc.isVersion() && doc.isReadOnly();
            if (setReadWrite) {
                doc.setReadOnly(false);
            }
            docModel = this.writeModel(doc, docModel);
            if (setReadWrite) {
                doc.setReadOnly(true);
            }
            Document checkedInDoc = null;
            if (!docModel.isImmutable()) {
                boolean checkin = this.getVersioningService().isPostSaveDoingCheckIn(doc, versioningOption, options);
                if (checkin) {
                    this.notifyEvent("aboutToCheckIn", docModel, options, null, null, true, true);
                }
                checkedInDoc = this.getVersioningService().doPostSave(doc, versioningOption, checkinComment, options);
            }
            docModel = this.readModel(doc);
            if (checkedInDoc != null) {
                IdRef checkedInVersionRef = new IdRef(checkedInDoc.getUUID());
                this.notifyCheckedInVersion(docModel, (DocumentRef)checkedInVersionRef, options, checkinComment);
            }
            this.notifyEvent("documentModified", docModel, options, null, null, true, false);
            this.updateDocumentCount.inc();
            return docModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to save document " + docModel, (Throwable)e);
        }
    }

    @Deprecated
    public boolean isDirty(DocumentRef docRef) throws ClientException {
        try {
            return this.resolveReference(docRef).isCheckedOut();
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public void saveDocuments(DocumentModel[] docModels) throws ClientException {
        for (DocumentModel docModel : docModels) {
            this.saveDocument(docModel);
        }
    }

    public DocumentModel getSourceDocument(DocumentRef docRef) throws ClientException {
        assert (null != docRef);
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadVersion");
            Document headDocument = doc.getSourceDocument();
            if (headDocument == null) {
                throw new DocumentException("Source document has been deleted");
            }
            return this.readModel(headDocument);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get head document for " + docRef, (Throwable)e);
        }
    }

    protected VersionModel getVersionModel(Document version) throws DocumentException {
        VersionModelImpl versionModel = new VersionModelImpl();
        versionModel.setId(version.getUUID());
        versionModel.setCreated(version.getVersionCreationDate());
        versionModel.setDescription(version.getCheckinComment());
        versionModel.setLabel(version.getVersionLabel());
        return versionModel;
    }

    public VersionModel getLastVersion(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadVersion");
            Document version = doc.getLastVersion();
            return version == null ? null : this.getVersionModel(version);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get versions for " + docRef, (Throwable)e);
        }
    }

    public DocumentModel getLastDocumentVersion(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadVersion");
            Document version = doc.getLastVersion();
            return version == null ? null : this.readModel(version);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get versions for " + docRef, (Throwable)e);
        }
    }

    public DocumentRef getLastDocumentVersionRef(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadVersion");
            Document version = doc.getLastVersion();
            return version == null ? null : new IdRef(version.getUUID());
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get versions for " + docRef, (Throwable)e);
        }
    }

    public List<DocumentRef> getVersionsRefs(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadVersion");
            List<String> ids = doc.getVersionsIds();
            ArrayList<DocumentRef> refs = new ArrayList<DocumentRef>(ids.size());
            for (String id : ids) {
                refs.add((DocumentRef)new IdRef(id));
            }
            return refs;
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public List<DocumentModel> getVersions(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadVersion");
            List<Document> docVersions = doc.getVersions();
            ArrayList<DocumentModel> versions = new ArrayList<DocumentModel>(docVersions.size());
            for (Document version : docVersions) {
                versions.add(this.readModel(version));
            }
            return versions;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get versions for " + docRef, (Throwable)e);
        }
    }

    public List<VersionModel> getVersionsForDocument(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadVersion");
            List<Document> docVersions = doc.getVersions();
            ArrayList<VersionModel> versions = new ArrayList<VersionModel>(docVersions.size());
            for (Document version : docVersions) {
                versions.add(this.getVersionModel(version));
            }
            return versions;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get versions for " + docRef, (Throwable)e);
        }
    }

    public DocumentModel restoreToVersion(DocumentRef docRef, DocumentRef versionRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            Document ver = this.resolveReference(versionRef);
            return this.restoreToVersion(doc, ver, false, true);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to restore document", (Throwable)e);
        }
    }

    @Deprecated
    public DocumentModel restoreToVersion(DocumentRef docRef, VersionModel version) throws ClientException {
        return this.restoreToVersion(docRef, version, false);
    }

    @Deprecated
    public DocumentModel restoreToVersion(DocumentRef docRef, VersionModel version, boolean skipSnapshotCreation) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            Document ver = doc.getVersion(version.getLabel());
            return this.restoreToVersion(doc, ver, skipSnapshotCreation, false);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to restore document", (Throwable)e);
        }
    }

    public DocumentModel restoreToVersion(DocumentRef docRef, DocumentRef versionRef, boolean skipSnapshotCreation, boolean skipCheckout) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            Document ver = this.resolveReference(versionRef);
            return this.restoreToVersion(doc, ver, skipSnapshotCreation, skipCheckout);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to restore document", (Throwable)e);
        }
    }

    protected DocumentModel restoreToVersion(Document doc, Document version, boolean skipSnapshotCreation, boolean skipCheckout) throws ClientException {
        try {
            this.checkPermission(doc, "WriteVersion");
            DocumentModel docModel = this.readModel(doc);
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            if (!skipSnapshotCreation && doc.isCheckedOut()) {
                String checkinComment = (String)((Object)docModel.getContextData("CheckinComment"));
                docModel.putContextData("CheckinComment", null);
                this.notifyEvent("aboutToCheckIn", docModel, options, null, null, true, true);
                Document ver = this.getVersioningService().doCheckIn(doc, null, checkinComment);
                docModel.refresh(1, null);
                this.notifyCheckedInVersion(docModel, (DocumentRef)new IdRef(ver.getUUID()), null, checkinComment);
            }
            Long majorVer = doc.getLong("major_version");
            Long minorVer = doc.getLong("minor_version");
            if (majorVer != null || minorVer != null) {
                options.put("CURRENT_DOCUMENT_MAJOR_VERSION", majorVer);
                options.put("CURRENT_DOCUMENT_MINOR_VERSION", minorVer);
            }
            String versionUUID = version.getUUID();
            options.put("RESTORED_VERSION_UUID", (Serializable)((Object)versionUUID));
            this.notifyEvent("beforeRestoringDocument", docModel, options, null, null, true, true);
            this.writeModel(doc, docModel);
            doc.restore(version);
            docModel = this.readModel(doc);
            this.notifyEvent("documentRestored", docModel, options, null, docModel.getVersionLabel(), true, false);
            docModel = this.writeModel(doc, docModel);
            if (!skipCheckout) {
                this.notifyEvent("aboutToCheckout", docModel, options, null, null, true, true);
                this.getVersioningService().doCheckOut(doc);
                docModel = this.readModel(doc);
                this.notifyEvent("documentCheckedOut", docModel, options, null, null, true, false);
            }
            log.debug((Object)("Document restored to version:" + version.getUUID()));
            return docModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to restore document " + doc, (Throwable)e);
        }
    }

    public DocumentRef getBaseVersion(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Read");
            Document ver = doc.getBaseVersion();
            if (ver == null) {
                return null;
            }
            this.checkPermission(ver, "Read");
            return new IdRef(ver.getUUID());
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    @Deprecated
    public DocumentModel checkIn(DocumentRef docRef, VersionModel ver) throws ClientException {
        try {
            DocumentRef verRef = this.checkIn(docRef, VersioningOption.MINOR, ver == null ? null : ver.getDescription());
            return this.readModel(this.resolveReference(verRef));
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to check in document " + docRef, (Throwable)e);
        }
    }

    public DocumentRef checkIn(DocumentRef docRef, VersioningOption option, String checkinComment) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "WriteProperties");
            DocumentModel docModel = this.readModel(doc);
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            this.notifyEvent("aboutToCheckIn", docModel, options, null, null, true, true);
            this.writeModel(doc, docModel);
            Document version = this.getVersioningService().doCheckIn(doc, option, checkinComment);
            docModel = this.readModel(doc);
            IdRef checkedInVersionRef = new IdRef(version.getUUID());
            this.notifyCheckedInVersion(docModel, (DocumentRef)checkedInVersionRef, options, checkinComment);
            this.writeModel(doc, docModel);
            return checkedInVersionRef;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to check in document " + docRef, (Throwable)e);
        }
    }

    protected void notifyCheckedInVersion(DocumentModel docModel, DocumentRef checkedInVersionRef, Map<String, Serializable> options, String checkinComment) throws ClientException {
        Serializable optionsComment;
        String label = this.getVersioningService().getVersionLabel(docModel);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        if (options != null) {
            props.putAll(options);
        }
        props.put("versionLabel", (Serializable)((Object)label));
        props.put("checkInComment", (Serializable)((Object)checkinComment));
        props.put("checkedInVersionRef", (Serializable)checkedInVersionRef);
        if (checkinComment == null && options != null && (optionsComment = options.get("comment")) instanceof String) {
            checkinComment = (String)((Object)optionsComment);
        }
        String comment = checkinComment == null ? label : label + ' ' + checkinComment;
        props.put("comment", (Serializable)((Object)comment));
        this.notifyEvent("documentCheckedIn", docModel, props, null, null, true, false);
        this.notifyEvent("documentCreated", this.getDocument(checkedInVersionRef), props, null, null, true, false);
    }

    public void checkOut(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "WriteProperties");
            DocumentModel docModel = this.readModel(doc);
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            this.notifyEvent("aboutToCheckout", docModel, options, null, null, true, true);
            this.getVersioningService().doCheckOut(doc);
            docModel = this.readModel(doc);
            this.notifyEvent("documentCheckedOut", docModel, options, null, null, true, false);
            this.writeModel(doc, docModel);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to check out document " + docRef, (Throwable)e);
        }
    }

    public void internalCheckOut(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to check out document " + docRef, (Throwable)e);
        }
    }

    public boolean isCheckedOut(DocumentRef docRef) throws ClientException {
        assert (null != docRef);
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Browse");
            return doc.isCheckedOut();
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to check out document " + docRef, (Throwable)e);
        }
    }

    public String getVersionSeriesId(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Read");
            return doc.getVersionSeriesId();
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public DocumentModel getWorkingCopy(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadVersion");
            Document pwc = doc.getWorkingCopy();
            this.checkPermission(pwc, "Read");
            return pwc == null ? null : this.readModel(pwc);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get versions for " + docRef, (Throwable)e);
        }
    }

    public DocumentModel getVersion(String versionableId, VersionModel versionModel) throws ClientException {
        String id = versionModel.getId();
        if (id != null) {
            return this.getDocument((DocumentRef)new IdRef(id));
        }
        try {
            Document doc = this.getSession().getVersion(versionableId, versionModel);
            if (doc == null) {
                return null;
            }
            this.checkPermission(doc, "ReadProperties");
            this.checkPermission(doc, "ReadVersion");
            return this.readModel(doc);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get version " + versionModel.getLabel() + " for " + versionableId, (Throwable)e);
        }
    }

    public String getVersionLabel(DocumentModel docModel) throws ClientException {
        return this.getVersioningService().getVersionLabel(docModel);
    }

    public DocumentModel getDocumentWithVersion(DocumentRef docRef, VersionModel version) throws ClientException {
        String id = version.getId();
        if (id != null) {
            return this.getDocument((DocumentRef)new IdRef(id));
        }
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadProperties");
            this.checkPermission(doc, "ReadVersion");
            String docPath = doc.getPath();
            doc = doc.getVersion(version.getLabel());
            if (doc == null) {
                log.debug((Object)("Version " + version.getLabel() + " does not exist for " + docPath));
                return null;
            }
            log.debug((Object)("Retrieved the version " + version.getLabel() + " of the document " + docPath));
            return this.readModel(doc);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get version for " + docRef, (Throwable)e);
        }
    }

    public DocumentModel createProxy(DocumentRef docRef, DocumentRef folderRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            Document fold = this.resolveReference(folderRef);
            this.checkPermission(doc, "Read");
            this.checkPermission(fold, "AddChildren");
            return this.createProxyInternal(doc, fold, new HashMap<String, Serializable>());
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected DocumentModel createProxyInternal(Document doc, Document folder, Map<String, Serializable> options) throws ClientException {
        try {
            Document proxy = this.getSession().createProxy(doc, folder);
            DocumentModel proxyModel = this.readModel(proxy);
            this.notifyEvent("documentCreated", proxyModel, options, null, null, true, false);
            this.notifyEvent("documentProxyPublished", proxyModel, options, null, null, true, false);
            DocumentModel folderModel = this.readModel(folder);
            this.notifyEvent("sectionContentPublished", folderModel, options, null, null, true, false);
            return proxyModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to create proxy for doc: " + doc, (Throwable)e);
        }
    }

    protected List<String> removeExistingProxies(Document doc, Document folder) throws DocumentException, ClientException {
        Collection<Document> otherProxies = this.getSession().getProxies(doc, folder);
        ArrayList<String> removedProxyIds = new ArrayList<String>(otherProxies.size());
        for (Document otherProxy : otherProxies) {
            removedProxyIds.add(otherProxy.getUUID());
            this.removeNotifyOneDoc(otherProxy);
        }
        return removedProxyIds;
    }

    protected DocumentModel updateExistingProxies(Document doc, Document folder, Document target) throws DocumentException, ClientException {
        Collection<Document> proxies = this.getSession().getProxies(doc, folder);
        try {
            if (proxies.size() == 1) {
                for (Document proxy : proxies) {
                    if (!(proxy instanceof DocumentProxy)) continue;
                    ((DocumentProxy)proxy).setTargetDocument(target);
                    return this.readModel(proxy);
                }
            }
        }
        catch (UnsupportedOperationException e) {
            log.error((Object)"Cannot update proxy, try to remove");
        }
        return null;
    }

    public DocumentModelList getProxies(DocumentRef docRef, DocumentRef folderRef) throws ClientException {
        try {
            Document folder = null;
            if (folderRef != null) {
                folder = this.resolveReference(folderRef);
                this.checkPermission(folder, "ReadChildren");
            }
            Document doc = this.resolveReference(docRef);
            Collection<Document> children = this.getSession().getProxies(doc, folder);
            DocumentModelListImpl docs = new DocumentModelListImpl();
            for (Document child : children) {
                if (!this.hasPermission(child, "Read")) continue;
                docs.add((Object)this.readModel(child));
            }
            return docs;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get children for " + folderRef, (Throwable)e);
        }
    }

    public String[] getProxyVersions(DocumentRef docRef, DocumentRef folderRef) throws ClientException {
        try {
            Document folder = this.resolveReference(folderRef);
            Document doc = this.resolveReference(docRef);
            this.checkPermission(folder, "ReadChildren");
            Collection<Document> children = this.getSession().getProxies(doc, folder);
            if (children.isEmpty()) {
                return null;
            }
            ArrayList<String> versions = new ArrayList<String>();
            for (Document child : children) {
                if (!this.hasPermission(child, "Read")) continue;
                Document target = ((DocumentProxy)child).getTargetDocument();
                if (target.isVersion()) {
                    versions.add(target.getVersionLabel());
                    continue;
                }
                versions.add("");
            }
            return versions.toArray(new String[versions.size()]);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get children for " + folderRef.toString(), (Throwable)e);
        }
    }

    public List<String> getAvailableSecurityPermissions() throws ClientException {
        return Arrays.asList(this.getSecurityService().getPermissionProvider().getPermissions());
    }

    public DataModel getDataModel(DocumentRef docRef, Schema schema) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Read");
            return DocumentModelFactory.createDataModel(doc, schema);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get data model for " + docRef + ':' + schema, (Throwable)e);
        }
    }

    protected Object getDataModelField(DocumentRef docRef, String schema, String field) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            if (doc != null) {
                this.checkPermission(doc, "Read");
                Schema docSchema = doc.getType().getSchema(schema);
                if (docSchema != null) {
                    String prefix = docSchema.getNamespace().prefix;
                    if (prefix != null && prefix.length() > 0) {
                        field = prefix + ':' + field;
                    }
                    return doc.getPropertyValue(field);
                }
                log.warn((Object)("Cannot find schema with name=" + schema));
            } else {
                log.warn((Object)("Cannot resolve docRef=" + docRef));
            }
            return null;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get data model field " + schema + ':' + field, (Throwable)e);
        }
    }

    public SerializableInputStream getContentData(String key) throws ClientException {
        try {
            InputStream in = this.getSession().getDataStream(key);
            return new SerializableInputStream(in);
        }
        catch (Exception e) {
            throw new ClientException("Failed to get data stream for " + key, (Throwable)e);
        }
    }

    public String getCurrentLifeCycleState(DocumentRef docRef) throws ClientException {
        String lifeCycleState;
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadLifeCycle");
            lifeCycleState = doc.getLifeCycleState();
        }
        catch (LifeCycleException e) {
            ClientException ce = new ClientException("Failed to get life cycle " + docRef, (Throwable)e);
            ce.fillInStackTrace();
            throw ce;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get content data " + docRef, (Throwable)e);
        }
        return lifeCycleState;
    }

    public String getLifeCyclePolicy(DocumentRef docRef) throws ClientException {
        String lifecyclePolicy;
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadLifeCycle");
            lifecyclePolicy = doc.getLifeCyclePolicy();
        }
        catch (LifeCycleException e) {
            ClientException ce = new ClientException("Failed to get life cycle policy" + docRef, (Throwable)e);
            ce.fillInStackTrace();
            throw ce;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get content data " + docRef, (Throwable)e);
        }
        return lifecyclePolicy;
    }

    private boolean followTransition(DocumentRef docRef, String transition, ScopedMap options) throws ClientException {
        boolean operationResult;
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "WriteLifeCycle");
            if (!(doc.isVersion() || doc.isProxy() || doc.isCheckedOut())) {
                this.checkOut(docRef);
                doc = this.resolveReference(docRef);
            }
            String formerStateName = doc.getLifeCycleState();
            operationResult = doc.followTransition(transition);
            if (operationResult) {
                HashMap<String, Serializable> eventOptions = new HashMap<String, Serializable>();
                eventOptions.put("from", (Serializable)((Object)formerStateName));
                eventOptions.put("to", (Serializable)((Object)doc.getLifeCycleState()));
                eventOptions.put("transition", (Serializable)((Object)transition));
                String comment = (String)((Object)options.getScopedValue("comment"));
                DocumentModel docModel = this.readModel(doc);
                this.notifyEvent("lifecycle_transition_event", docModel, eventOptions, "eventLifeCycleCategory", comment, true, false);
                if (!docModel.isImmutable()) {
                    this.writeModel(doc, docModel);
                }
            }
        }
        catch (LifeCycleException e) {
            ClientException ce = new ClientException("Unable to follow transition <" + transition + "> for document : " + docRef, (Throwable)e);
            ce.fillInStackTrace();
            throw ce;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get content data " + docRef, (Throwable)e);
        }
        return operationResult;
    }

    public boolean followTransition(DocumentModel docModel, String transition) throws ClientException {
        return this.followTransition(docModel.getRef(), transition, docModel.getContextData());
    }

    public boolean followTransition(DocumentRef docRef, String transition) throws ClientException {
        return this.followTransition(docRef, transition, new ScopedMap());
    }

    public Collection<String> getAllowedStateTransitions(DocumentRef docRef) throws ClientException {
        Collection<String> allowedStateTransitions;
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadLifeCycle");
            allowedStateTransitions = doc.getAllowedStateTransitions();
        }
        catch (LifeCycleException e) {
            ClientException ce = new ClientException("Unable to get allowed state transitions for document : " + docRef, (Throwable)e);
            ce.fillInStackTrace();
            throw ce;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get content data " + docRef, (Throwable)e);
        }
        return allowedStateTransitions;
    }

    public void reinitLifeCycleState(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "WriteLifeCycle");
            LifeCycleService service = NXCore.getLifeCycleService();
            service.reinitLifeCycle(doc);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get content data " + docRef, (Throwable)e);
        }
        catch (LifeCycleException e) {
            throw new ClientException("Failed to reinit life cycle " + docRef, (Throwable)e);
        }
    }

    public Object[] getDataModelsField(DocumentRef[] docRefs, String schema, String field) throws ClientException {
        assert (docRefs != null);
        assert (schema != null);
        assert (field != null);
        Object[] values = new Object[docRefs.length];
        int i = 0;
        for (DocumentRef docRef : docRefs) {
            Object value = this.getDataModelField(docRef, schema, field);
            values[i++] = value;
        }
        return values;
    }

    public DocumentRef[] getParentDocumentRefs(DocumentRef docRef) throws ClientException {
        ArrayList<IdRef> docRefs = new ArrayList<IdRef>();
        try {
            Document doc = this.resolveReference(docRef);
            for (Document parentDoc = doc.getParent(); parentDoc != null; parentDoc = parentDoc.getParent()) {
                IdRef parentDocRef = new IdRef(parentDoc.getUUID());
                docRefs.add(parentDocRef);
            }
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get all parent documents: " + docRef, (Throwable)e);
        }
        DocumentRef[] refs = new DocumentRef[docRefs.size()];
        return docRefs.toArray(refs);
    }

    public Object[] getDataModelsFieldUp(DocumentRef docRef, String schema, String field) throws ClientException {
        DocumentRef[] parentRefs = this.getParentDocumentRefs(docRef);
        DocumentRef[] allRefs = new DocumentRef[parentRefs.length + 1];
        allRefs[0] = docRef;
        System.arraycopy(parentRefs, 0, allRefs, 1, parentRefs.length);
        return this.getDataModelsField(allRefs, schema, field);
    }

    protected String oldLockKey(Lock lock) {
        if (lock == null) {
            return null;
        }
        String lockCreationDate = lock.getCreated() == null ? null : DateFormat.getDateInstance(2).format(new Date(lock.getCreated().getTimeInMillis()));
        return lock.getOwner() + ':' + lockCreationDate;
    }

    @Deprecated
    public String getLock(DocumentRef docRef) throws ClientException {
        Lock lock = this.getLockInfo(docRef);
        return this.oldLockKey(lock);
    }

    @Deprecated
    public void setLock(DocumentRef docRef, String key) throws ClientException {
        this.setLock(docRef);
    }

    @Deprecated
    public String unlock(DocumentRef docRef) throws ClientException {
        Lock lock = this.removeLock(docRef);
        return this.oldLockKey(lock);
    }

    public Lock setLock(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "WriteProperties");
            Lock lock = new Lock(this.getPrincipal().getName(), (Calendar)new GregorianCalendar());
            Lock oldLock = doc.setLock(lock);
            if (oldLock != null) {
                throw new ClientException("Document already locked by " + oldLock.getOwner() + ": " + docRef);
            }
            DocumentModel docModel = this.readModel(doc);
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            options.put("lock", (Serializable)lock);
            this.notifyEvent("documentLocked", docModel, options, null, null, true, false);
            return lock;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to set lock on " + docRef, (Throwable)e);
        }
    }

    public Lock getLockInfo(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Read");
            return doc.getLock();
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get lock info on " + docRef, (Throwable)e);
        }
    }

    public Lock removeLock(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            String owner = this.hasPermission(docRef, "Unlock") ? null : this.getPrincipal().getName();
            Lock lock = doc.removeLock(owner);
            if (lock == null) {
                return null;
            }
            if (lock.getFailed()) {
                throw new ClientException("Document already locked by " + lock.getOwner() + ": " + docRef);
            }
            DocumentModel docModel = this.readModel(doc);
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            options.put("lock", (Serializable)lock);
            this.notifyEvent("documentUnlocked", docModel, options, null, null, true, false);
            return lock;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to set lock on " + docRef, (Throwable)e);
        }
    }

    protected boolean isAdministrator() {
        Principal principal = this.getPrincipal();
        if (Framework.isTestModeSet() && "Administrator".equals(principal.getName())) {
            return true;
        }
        if ("system".equals(principal.getName())) {
            return true;
        }
        if (principal instanceof NuxeoPrincipal) {
            return ((NuxeoPrincipal)principal).isAdministrator();
        }
        return false;
    }

    public void applyDefaultPermissions(String userOrGroupName) throws ClientException {
        if (null == userOrGroupName) {
            throw new ClientException("Null parameters received.");
        }
        if (!this.isAdministrator()) {
            throw new DocumentSecurityException("You need to be an Administrator to do this.");
        }
        DocumentModel rootDocument = this.getRootDocument();
        ACPImpl acp = new ACPImpl();
        UserEntryImpl userEntry = new UserEntryImpl(userOrGroupName);
        userEntry.addPrivilege("Read", true, false);
        acp.setRules(new UserEntry[]{userEntry});
        this.setACP(rootDocument.getRef(), (ACP)acp, false);
    }

    public DocumentModel publishDocument(DocumentModel docToPublish, DocumentModel section) throws ClientException {
        return this.publishDocument(docToPublish, section, true);
    }

    public DocumentModel publishDocument(DocumentModel docModel, DocumentModel section, boolean overwriteExistingProxy) throws ClientException {
        try {
            Document target;
            Document doc = this.resolveReference(docModel.getRef());
            Document sec = this.resolveReference(section.getRef());
            this.checkPermission(doc, "Read");
            this.checkPermission(sec, "AddChildren");
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            DocumentModel proxy = null;
            if (docModel.isProxy() || docModel.isVersion()) {
                if (overwriteExistingProxy) {
                    List<String> removedProxyIds = this.removeExistingProxies(doc, sec);
                    options.put("replacedProxyRefs", (Serializable)((Object)removedProxyIds));
                }
                target = doc;
            } else {
                String checkinComment = (String)((Object)docModel.getContextData("CheckinComment"));
                docModel.putContextData("CheckinComment", null);
                if (doc.isCheckedOut() || doc.getLastVersion() == null) {
                    if (!doc.isCheckedOut()) {
                        this.notifyEvent("aboutToCheckout", docModel, options, null, null, true, true);
                        this.getVersioningService().doCheckOut(doc);
                        docModel = this.readModel(doc);
                        this.notifyEvent("documentCheckedOut", docModel, options, null, null, true, false);
                    }
                    this.notifyEvent("aboutToCheckIn", docModel, options, null, null, true, true);
                    Document version = this.getVersioningService().doCheckIn(doc, null, checkinComment);
                    docModel.refresh(129, null);
                    this.notifyCheckedInVersion(docModel, (DocumentRef)new IdRef(version.getUUID()), null, checkinComment);
                }
                target = doc.getBaseVersion();
                if (overwriteExistingProxy) {
                    proxy = this.updateExistingProxies(doc, sec, target);
                    if (proxy == null) {
                        List<String> removedProxyIds = this.removeExistingProxies(doc, sec);
                        options.put("replacedProxyRefs", (Serializable)((Object)removedProxyIds));
                    } else {
                        this.notifyEvent("documentProxyUpdated", proxy, options, null, null, true, false);
                        this.notifyEvent("documentProxyPublished", proxy, options, null, null, true, false);
                        this.notifyEvent("sectionContentPublished", section, options, null, null, true, false);
                    }
                }
            }
            if (proxy == null) {
                proxy = this.createProxyInternal(target, sec, options);
            }
            return proxy;
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public String getSuperParentType(DocumentModel doc) throws ClientException {
        DocumentModel superSpace = this.getSuperSpace(doc);
        if (superSpace == null) {
            return null;
        }
        return superSpace.getType();
    }

    public DocumentModel getSuperSpace(DocumentModel doc) throws ClientException {
        if (doc == null) {
            throw new ClientException("getSuperSpace: document is null");
        }
        if (doc.hasFacet("SuperSpace")) {
            return doc;
        }
        DocumentModel parent = this.getDirectAccessibleParent(doc.getRef());
        if (parent == null || "/".equals(parent.getPathAsString())) {
            return this.getRootDocument();
        }
        return this.getSuperSpace(parent);
    }

    private DocumentModel getDirectAccessibleParent(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            Document parentDoc = doc.getParent();
            if (parentDoc == null) {
                return this.readModel(doc);
            }
            if (!this.hasPermission(parentDoc, "Read")) {
                String parentPath = parentDoc.getPath();
                if ("/".equals(parentPath)) {
                    return this.getRootDocument();
                }
                return this.getDirectAccessibleParent((DocumentRef)new PathRef(parentDoc.getPath()));
            }
            return this.readModel(parentDoc);
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public <T extends Serializable> T getDocumentSystemProp(DocumentRef ref, String systemProperty, Class<T> type) throws ClientException, DocumentException {
        Document doc;
        try {
            doc = this.resolveReference(ref);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get document " + ref, (Throwable)e);
        }
        return doc.getSystemProp(systemProperty, type);
    }

    public <T extends Serializable> void setDocumentSystemProp(DocumentRef ref, String systemProperty, T value) throws ClientException, DocumentException {
        Document doc;
        try {
            doc = this.resolveReference(ref);
            if (systemProperty != null && systemProperty.startsWith(BINARY_TEXT_SYS_PROP)) {
                DocumentModel docModel = this.readModel(doc);
                HashMap<String, Serializable> options = new HashMap<String, Serializable>();
                options.put(systemProperty, Boolean.valueOf(value != null));
                this.notifyEvent("binaryTextUpdated", docModel, options, null, null, false, true);
            }
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get document " + ref, (Throwable)e);
        }
        doc.setSystemProp(systemProperty, value);
    }

    public void orderBefore(DocumentRef parent, String src, String dest) throws ClientException {
        try {
            if (src == null || src.equals(dest)) {
                return;
            }
            Document doc = this.resolveReference(parent);
            doc.orderBefore(src, dest);
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            DocumentModel docModel = this.readModel(doc);
            String comment = src;
            options.put("reorderedChild", (Serializable)((Object)src));
            this.notifyEvent("childrenOrderChanged", docModel, options, null, comment, true, false);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to resolve documents: " + src + ", " + dest, (Throwable)e);
        }
    }

    public DocumentModel.DocumentModelRefresh refreshDocument(DocumentRef ref, int refreshFlags, String[] schemas) throws ClientException {
        try {
            Document doc = this.resolveReference(ref);
            if (doc == null) {
                throw new ClientException("No Such Document: " + ref);
            }
            if ((refreshFlags & 0x105) != 0) {
                this.checkPermission(doc, "Read");
            }
            if ((refreshFlags & 0x20) != 0) {
                this.checkPermission(doc, "ReadSecurity");
            }
            DocumentModel.DocumentModelRefresh refresh = DocumentModelFactory.refreshDocumentModel(doc, refreshFlags, schemas);
            if ((refreshFlags & 0x20) != 0) {
                refresh.acp = this.getSession().getMergedACP(doc);
            }
            return refresh;
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException("Failed to get refresh data", (Throwable)e);
        }
    }

    public String[] getPermissionsToCheck(String permission) {
        return this.getSecurityService().getPermissionsToCheck(permission);
    }

    public <T extends DetachedAdapter> T adaptFirstMatchingDocumentWithFacet(DocumentRef docRef, String facet, Class<T> adapterClass) throws ClientException {
        Document doc = this.getFirstParentDocumentWithFacet(docRef, facet);
        if (doc != null) {
            DocumentModel docModel = this.readModel(doc);
            this.loadDataModelsForFacet(docModel, doc, facet);
            docModel.detach(false);
            return (T)((DetachedAdapter)docModel.getAdapter(adapterClass));
        }
        return null;
    }

    protected void loadDataModelsForFacet(DocumentModel docModel, Document doc, String facetName) throws ClientException {
        String[] facetSchemas;
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        CompositeType facet = schemaManager.getFacet(facetName);
        if (facet == null) {
            return;
        }
        for (String schema : facetSchemas = facet.getSchemaNames()) {
            try {
                DataModel dm = DocumentModelFactory.createDataModel(doc, schemaManager.getSchema(schema));
                docModel.getDataModels().put((Object)schema, (Object)dm);
            }
            catch (DocumentException e) {
                throw new ClientException((Throwable)e);
            }
        }
    }

    protected Document getFirstParentDocumentWithFacet(DocumentRef docRef, String facet) throws ClientException {
        try {
            Document doc;
            for (doc = this.resolveReference(docRef); doc != null && !doc.hasFacet(facet); doc = doc.getParent()) {
            }
            return doc;
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public Map<String, String> getBinaryFulltext(DocumentRef ref) throws ClientException {
        try {
            Document doc = this.resolveReference(ref);
            this.checkPermission(doc, "Read");
            return this.getSession().getBinaryFulltext((Serializable)((Object)ref.toString()));
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get fulltext info  on " + ref, (Throwable)e);
        }
    }
}

