/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.util;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;

public class ListUtils {
    private ListUtils() {
    }

    public static <T> List<T> batchList(List<T> list, BigInteger maxItems, BigInteger skipCount, int defaultMax) {
        return ListUtils.getBatchedList(list, maxItems, skipCount, defaultMax).getList();
    }

    public static <T> BatchedList<T> getBatchedList(List<T> list, BigInteger maxItems, BigInteger skipCount, int defaultMax) {
        boolean hasMoreItems;
        int max;
        int skip;
        int n = skip = skipCount == null ? 0 : skipCount.intValue();
        if (skip < 0) {
            skip = 0;
        }
        int n2 = max = maxItems == null ? -1 : maxItems.intValue();
        if (max < 0) {
            max = defaultMax;
        }
        BatchedList<T> res = new BatchedList<T>();
        res.setNumItems(list.size());
        if (skip >= list.size()) {
            res.setHasMoreItems(false);
            res.setList(Collections.emptyList());
            return res;
        }
        if (max > list.size() - skip) {
            max = list.size() - skip;
        }
        boolean bl = hasMoreItems = max < list.size() - skip;
        if (skip > 0 || hasMoreItems) {
            list = list.subList(skip, skip + max);
        }
        res.setHasMoreItems(hasMoreItems);
        res.setList(list);
        return res;
    }

    public static class BatchedList<T> {
        public List<T> list;
        public boolean hasMoreItems = false;
        public int numItems;

        public List<T> getList() {
            return this.list;
        }

        public void setList(List<T> list) {
            this.list = list;
        }

        public Boolean getHasMoreItems() {
            return this.hasMoreItems;
        }

        public void setHasMoreItems(boolean hasMoreItems) {
            this.hasMoreItems = hasMoreItems;
        }

        public BigInteger getNumItems() {
            return BigInteger.valueOf(this.numItems);
        }

        public void setNumItems(int numItems) {
            this.numItems = numItems;
        }
    }
}

