/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.ajax.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.ext.HtmlMessages;
import org.apache.myfaces.custom.ajax.AjaxCallbacks;
import org.apache.myfaces.custom.inputAjax.HtmlInputTextAjax;
import org.apache.myfaces.custom.util.ComponentUtils;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlMessageRendererBase;

public final class AjaxRendererUtils {
    public static final String STYLECLASS_LOADER = "myFacesInputSuggestAjax";
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$ajax$util$AjaxRendererUtils == null ? (class$org$apache$myfaces$custom$ajax$util$AjaxRendererUtils = AjaxRendererUtils.class$("org.apache.myfaces.custom.ajax.util.AjaxRendererUtils")) : class$org$apache$myfaces$custom$ajax$util$AjaxRendererUtils));
    public static final String JAVASCRIPT_ENCODED = "org.apache.myfaces.custom.inputAjax.JAVASCRIPT_ENCODED";
    public static final String JS_MYFACES_NAMESPACE = "_MyFaces_inputAjax_";
    static /* synthetic */ Class class$org$apache$myfaces$custom$ajax$util$AjaxRendererUtils;
    static /* synthetic */ Class class$org$apache$myfaces$custom$prototype$PrototypeResourceLoader;

    private AjaxRendererUtils() {
    }

    public static void addPrototypeScript(FacesContext context, UIComponent component, AddResource addResource) {
        String javascriptLocation = (String)component.getAttributes().get("org.apache.myfaces.JAVASCRIPT_LOCATION");
        if (javascriptLocation != null) {
            addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, javascriptLocation + "/prototype.js");
            addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, javascriptLocation + "/effects.js");
        } else {
            addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$prototype$PrototypeResourceLoader == null ? (class$org$apache$myfaces$custom$prototype$PrototypeResourceLoader = AjaxRendererUtils.class$("org.apache.myfaces.custom.prototype.PrototypeResourceLoader")) : class$org$apache$myfaces$custom$prototype$PrototypeResourceLoader, "prototype.js");
            addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$prototype$PrototypeResourceLoader == null ? (class$org$apache$myfaces$custom$prototype$PrototypeResourceLoader = AjaxRendererUtils.class$("org.apache.myfaces.custom.prototype.PrototypeResourceLoader")) : class$org$apache$myfaces$custom$prototype$PrototypeResourceLoader, "effects.js");
        }
        addResource.addStyleSheet(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$ajax$util$AjaxRendererUtils == null ? (class$org$apache$myfaces$custom$ajax$util$AjaxRendererUtils = AjaxRendererUtils.class$("org.apache.myfaces.custom.ajax.util.AjaxRendererUtils")) : class$org$apache$myfaces$custom$ajax$util$AjaxRendererUtils, "myFaces_Ajax.css");
    }

    public static void writeAjaxScript(FacesContext context, ResponseWriter out, AjaxCallbacks component) throws IOException {
        AjaxRendererUtils.writeAjaxScript(context, out, component, null);
    }

    public static void writeAjaxScript(FacesContext context, ResponseWriter out, AjaxCallbacks component, String extraParams) throws IOException {
        UIComponent ajaxMessages;
        UIComponent uiComponent = (UIComponent)component;
        String clientId = uiComponent.getClientId(context);
        String viewId = context.getViewRoot().getViewId();
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        String ajaxURL = viewHandler.getActionURL(context, viewId);
        String ajaxMessagesId = null;
        if (uiComponent instanceof HtmlInputTextAjax && (ajaxMessages = ComponentUtils.findFirstMessagesComponent(context, (UIComponent)context.getViewRoot())) != null && ((HtmlMessages)ajaxMessages).getForceSpan()) {
            ajaxMessagesId = ajaxMessages.getClientId(context);
        }
        String jsNameSpace = JS_MYFACES_NAMESPACE;
        String AJAX_RESPONSE_MAP = "_MyFaces_inputAjax_ajaxResponseMap";
        if (!context.getExternalContext().getRequestMap().containsKey(JAVASCRIPT_ENCODED)) {
            out.startElement("script", null);
            out.writeAttribute("type", (Object)"text/javascript", null);
            out.writeText((Object)("var " + jsNameSpace + "ajaxUrl = '" + ajaxURL + "';\n"), null);
            out.writeText((Object)("var " + jsNameSpace + "globalErrorsId = '" + ajaxMessagesId + "';\n"), null);
            out.writeText((Object)("var " + AJAX_RESPONSE_MAP + " = new Object();\n"), null);
            out.endElement("script");
            AddResource addResource = AddResourceFactory.getInstance((FacesContext)context);
            addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$ajax$util$AjaxRendererUtils == null ? (class$org$apache$myfaces$custom$ajax$util$AjaxRendererUtils = AjaxRendererUtils.class$("org.apache.myfaces.custom.ajax.util.AjaxRendererUtils")) : class$org$apache$myfaces$custom$ajax$util$AjaxRendererUtils, "inputAjax.js");
            context.getExternalContext().getRequestMap().put(JAVASCRIPT_ENCODED, Boolean.TRUE);
        }
        out.startElement("script", null);
        out.writeAttribute("type", (Object)"text/javascript", null);
        out.writeText((Object)(AJAX_RESPONSE_MAP + "['" + clientId + "'] = new Object();\n"), null);
        if (component.getOnSuccess() != null) {
            out.writeText((Object)(AJAX_RESPONSE_MAP + "['" + clientId + "']['onSuccessFunction'] = " + component.getOnSuccess() + ";\n"), null);
        }
        if (component.getOnFailure() != null) {
            out.writeText((Object)(AJAX_RESPONSE_MAP + "['" + clientId + "']['onFailureFunction'] = " + component.getOnFailure() + ";\n"), null);
        }
        if (component.getOnStart() != null) {
            out.writeText((Object)(AJAX_RESPONSE_MAP + "['" + clientId + "']['onStartFunction'] = " + component.getOnStart() + ";\n"), null);
        }
        out.endElement("script");
    }

    public static void encodeAjax(FacesContext context, UIComponent component) throws IOException {
        AjaxRendererUtils.encodeAjax(context, component, null);
    }

    public static void encodeAjax(FacesContext context, UIComponent component, Map extraReturnAttributes) throws IOException {
        String clientId = component.getClientId(context);
        Object responseOb = context.getExternalContext().getResponse();
        if (responseOb instanceof HttpServletResponse) {
            HttpServletResponse response = (HttpServletResponse)responseOb;
            StringBuffer buff = new StringBuffer();
            boolean hasErrorMessages = false;
            Iterator iter = context.getMessages(clientId);
            while (iter.hasNext()) {
                FacesMessage msg = (FacesMessage)iter.next();
                String style = "";
                String styleClass = "";
                String msgForId = clientId + "_msgFor";
                UIComponent msgComponent = context.getViewRoot().findComponent(msgForId);
                String msgId = null;
                if (msgComponent != null) {
                    String[] styleAndClass = HtmlMessageRendererBase.getStyleAndStyleClass((UIComponent)msgComponent, (FacesMessage.Severity)msg.getSeverity());
                    style = styleAndClass[0];
                    styleClass = styleAndClass[1];
                    msgId = msgComponent.getClientId(context);
                }
                buff.append("<error elname=\"").append(clientId).append("\" severity=\"").append(msg.getSeverity().toString());
                if (styleClass != null) {
                    buff.append("\" styleClass=\"").append(styleClass);
                }
                if (style != null) {
                    buff.append("\" style=\"").append(style);
                }
                buff.append("\" summary=\"").append(msg.getSummary()).append("\" ");
                if (msgId != null) {
                    buff.append(" msgId=\"").append(msgId).append("\"");
                }
                buff.append(">\n");
                String detail = msg.getDetail();
                if (detail != null) {
                    buff.append("<detail>");
                    buff.append(msg.getDetail());
                    buff.append("</detail>\n");
                }
                buff.append("</error>\n");
                hasErrorMessages = true;
            }
            if (!hasErrorMessages) {
                buff.append("<elementUpdated elname=\"").append(clientId).append("\"");
                if (component instanceof UIOutput) {
                    UIOutput uiOutput = (UIOutput)component;
                    buff.append(" elvalue=\"").append(uiOutput.getValue()).append("\"");
                }
                if (extraReturnAttributes != null) {
                    Iterator iter2 = extraReturnAttributes.keySet().iterator();
                    while (iter2.hasNext()) {
                        String key = (String)iter2.next();
                        buff.append(" ").append(key).append("=\"").append(extraReturnAttributes.get(key).toString()).append("\"");
                    }
                }
                buff.append(" />");
                buff.append("\n");
            }
            String output = buff.toString();
            log.debug((Object)output);
            PrintWriter out = response.getWriter();
            out.print(output);
        }
    }

    public static void writeLoadingImage(FacesContext context, UIComponent comp) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(comp.getClientId(context) + "_loaderImg"), null);
        writer.writeAttribute("class", (Object)STYLECLASS_LOADER, null);
        writer.write("<spacer type=\"block\" width=\"15\" height=\"15\"/>");
        writer.endElement("span");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

