/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.conversation;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.myfaces.custom.conversation.Conversation;
import org.apache.myfaces.custom.conversation.PersistenceManager;

public class ConversationContext {
    private final long id;
    private final Object mutex = new Object();
    private final Map conversations = new TreeMap();
    private Conversation currentConversation;
    private long lastAccess;

    protected ConversationContext(long id) {
        this.id = id;
        this.touch();
    }

    protected void touch() {
        this.lastAccess = System.currentTimeMillis();
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownContext() {
        Object object = this.mutex;
        synchronized (object) {
            Iterator iterConversation = this.conversations.values().iterator();
            while (iterConversation.hasNext()) {
                Conversation conversation = (Conversation)iterConversation.next();
                conversation.endConversation(false);
            }
            this.conversations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startConversation(String name, boolean persistence) {
        Object object = this.mutex;
        synchronized (object) {
            this.touch();
            Conversation conversation = (Conversation)this.conversations.get(name);
            if (conversation == null) {
                conversation = new Conversation(name, persistence);
                this.conversations.put(name, conversation);
            }
            this.currentConversation = conversation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endConversation(Conversation conversation, boolean regularEnd) {
        Object object = this.mutex;
        synchronized (object) {
            this.touch();
            conversation.endConversation(regularEnd);
            this.conversations.remove(conversation.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endConversation(String name, boolean regularEnd) {
        Object object = this.mutex;
        synchronized (object) {
            this.touch();
            Conversation conversation = (Conversation)this.conversations.get(name);
            if (conversation != null) {
                this.endConversation(conversation, regularEnd);
            }
        }
    }

    public Conversation getCurrentConversation() {
        this.touch();
        return this.currentConversation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasConversations() {
        Object object = this.mutex;
        synchronized (object) {
            this.touch();
            return this.conversations.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasConversation(String name) {
        Object object = this.mutex;
        synchronized (object) {
            this.touch();
            return this.conversations.get(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conversation getConversation(String name) {
        Object object = this.mutex;
        synchronized (object) {
            this.touch();
            return (Conversation)this.conversations.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conversation findConversation(Object instance) {
        Object object = this.mutex;
        synchronized (object) {
            this.touch();
            Iterator iterConversations = this.conversations.values().iterator();
            while (iterConversations.hasNext()) {
                Conversation conversation = (Conversation)iterConversations.next();
                if (!conversation.hasBean(instance)) continue;
                return conversation;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findBean(String name) {
        Object object = this.mutex;
        synchronized (object) {
            this.touch();
            Iterator iterConversations = this.conversations.values().iterator();
            while (iterConversations.hasNext()) {
                Conversation conversation = (Conversation)iterConversations.next();
                if (!conversation.hasBean(name)) continue;
                return conversation.getBean(name);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceManager getPersistenceManager() {
        Object object = this.mutex;
        synchronized (object) {
            this.touch();
            Iterator iterConversations = this.conversations.values().iterator();
            while (iterConversations.hasNext()) {
                Conversation conversation = (Conversation)iterConversations.next();
                if (!conversation.isPersistence()) continue;
                return conversation.getPersistenceManager();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachPersistence() {
        Object object = this.mutex;
        synchronized (object) {
            this.touch();
            Iterator iterConversations = this.conversations.values().iterator();
            while (iterConversations.hasNext()) {
                Conversation conversation = (Conversation)iterConversations.next();
                if (!conversation.isPersistence()) continue;
                conversation.getPersistenceManager().detach();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgePersistence() {
        Object object = this.mutex;
        synchronized (object) {
            this.touch();
            Iterator iterConversations = this.conversations.values().iterator();
            while (iterConversations.hasNext()) {
                Conversation conversation = (Conversation)iterConversations.next();
                if (!conversation.isPersistence()) continue;
                conversation.getPersistenceManager().purge();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachPersistence() {
        Object object = this.mutex;
        synchronized (object) {
            this.touch();
            Iterator iterConversations = this.conversations.values().iterator();
            while (iterConversations.hasNext()) {
                Conversation conversation = (Conversation)iterConversations.next();
                if (!conversation.isPersistence()) continue;
                conversation.getPersistenceManager().attach();
            }
        }
    }

    public long getId() {
        return this.id;
    }
}

