/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.conversation;

import java.util.Iterator;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.custom.conversation.AbstractConversationComponent;
import org.apache.myfaces.custom.conversation.Conversation;
import org.apache.myfaces.custom.conversation.ConversationManager;
import org.apache.myfaces.custom.conversation.UIEndConversation;
import org.apache.myfaces.custom.conversation.UIStartConversation;

public class ConversationUtils {
    private ConversationUtils() {
    }

    public static UICommand findParentCommand(UIComponent base) {
        UIComponent parent = base;
        do {
            if (!((parent = parent.getParent()) instanceof UICommand)) continue;
            return (UICommand)parent;
        } while (parent != null);
        return null;
    }

    public static AbstractConversationComponent findStartOrEndConversationComponent(UIComponent component, String conversationName) {
        Iterator iterComponents = component.getFacetsAndChildren();
        while (iterComponents.hasNext()) {
            AbstractConversationComponent conversation;
            Object child = iterComponents.next();
            if (!(child instanceof UIStartConversation || child instanceof UIEndConversation ? (conversation = (AbstractConversationComponent)((Object)child)).getName().equals(conversationName) : child instanceof UIComponent && (conversation = ConversationUtils.findStartOrEndConversationComponent((UIComponent)child, conversationName)) != null)) continue;
            return conversation;
        }
        return null;
    }

    public static String extractBeanName(ValueBinding vb) {
        String valueBinding = vb.getExpressionString();
        return valueBinding.substring(2, valueBinding.length() - 1);
    }

    static void endAndRestartConversation(FacesContext context, String conversationName, Boolean restart, MethodBinding restartAction) {
        ConversationManager conversationManager = ConversationManager.getInstance(context);
        Conversation conversation = conversationManager.getConversation(conversationName);
        conversationManager.endConversation(conversationName, true);
        if (restart != null && restart.booleanValue() && conversation != null) {
            conversationManager.startConversation(conversationName, conversation.isPersistence());
            if (restartAction != null) {
                restartAction.invoke(context, null);
            }
        }
    }
}

