/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.conversation;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.custom.conversation.AbstractConversationComponent;
import org.apache.myfaces.custom.conversation.ConversationManager;
import org.apache.myfaces.custom.redirectTracker.RedirectTrackerManager;

public class UIEnsureConversation
extends AbstractConversationComponent {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.EnsureConversation";
    private String redirectTo;
    private Boolean preCheck;

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.checkConversation(context, this.getName());
    }

    public void decode(FacesContext context) {
        super.decode(context);
        try {
            this.checkConversation(context, this.getName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] states = (Object[])state;
        super.restoreState(context, states[0]);
        this.redirectTo = (String)states[1];
        this.preCheck = (Boolean)states[2];
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.redirectTo, this.preCheck};
    }

    protected void checkConversation(FacesContext context, String name) throws IOException {
        ConversationManager conversationManager = ConversationManager.getInstance();
        if (Boolean.TRUE.equals(this.preCheck)) {
            String actionResult = (String)this.getAction().invoke(context, null);
            if (actionResult == null) {
                return;
            }
            conversationManager.getMessager().setConversationNotActive(context, this.getName());
            return;
        }
        if (!conversationManager.hasConversation(name)) {
            if (this.getAction() != null) {
                String actionResult = (String)this.getAction().invoke(context, null);
                if (actionResult == null) {
                    return;
                }
                conversationManager.getMessager().setConversationNotActive(context, this.getName());
                context.getApplication().getNavigationHandler().handleNavigation(context, null, actionResult);
            } else {
                conversationManager.getMessager().setConversationNotActive(context, this.getName());
                String actionUrl = context.getApplication().getViewHandler().getActionURL(context, this.getRedirectTo());
                String encodedActionUrl = context.getExternalContext().encodeActionURL(actionUrl);
                RedirectTrackerManager manager = RedirectTrackerManager.getInstance(context);
                if (manager != null) {
                    encodedActionUrl = manager.trackRedirect(context, encodedActionUrl);
                }
                context.getExternalContext().redirect(encodedActionUrl);
            }
            return;
        }
    }

    public String getRedirectTo() {
        if (this.redirectTo != null) {
            return this.redirectTo;
        }
        ValueBinding vb = this.getValueBinding("redirectTo");
        if (vb == null) {
            return null;
        }
        return (String)vb.getValue(this.getFacesContext());
    }

    public void setRedirectTo(String redirectTo) {
        this.redirectTo = redirectTo;
    }
}

