/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.graphicimagedynamic;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.util.ParameterResourceHandler;
import org.apache.myfaces.custom.graphicimagedynamic.GraphicImageDynamic;
import org.apache.myfaces.custom.graphicimagedynamic.ImageContext;
import org.apache.myfaces.custom.graphicimagedynamic.ImageRenderer;
import org.apache.myfaces.renderkit.html.ext.HtmlImageRenderer;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.renderkit.html.util.ResourceHandler;
import org.apache.myfaces.renderkit.html.util.ResourceLoader;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.util.ClassUtils;

public class GraphicImageDynamicRenderer
extends HtmlImageRenderer
implements ResourceLoader {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$graphicimagedynamic$GraphicImageDynamicRenderer == null ? (class$org$apache$myfaces$custom$graphicimagedynamic$GraphicImageDynamicRenderer = GraphicImageDynamicRenderer.class$("org.apache.myfaces.custom.graphicimagedynamic.GraphicImageDynamicRenderer")) : class$org$apache$myfaces$custom$graphicimagedynamic$GraphicImageDynamicRenderer));
    private static final String RENDERER_PARAM = "_renderer";
    private static final String WIDTH_PARAM = "_width";
    private static final String HEIGHT_PARAM = "_height";
    public static final String RENDERER_TYPE = "org.apache.myfaces.GraphicImageDynamicRenderer";
    static /* synthetic */ Class class$org$apache$myfaces$custom$graphicimagedynamic$GraphicImageDynamicRenderer;
    static /* synthetic */ Class class$org$apache$myfaces$custom$graphicimagedynamic$GraphicImageDynamic;
    static /* synthetic */ Class class$org$apache$myfaces$custom$graphicimagedynamic$ImageRenderer;

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Class imageRendererClass;
        String height;
        RendererUtils.checkParamValidity((FacesContext)context, (UIComponent)component, (Class)(class$org$apache$myfaces$custom$graphicimagedynamic$GraphicImageDynamic == null ? (class$org$apache$myfaces$custom$graphicimagedynamic$GraphicImageDynamic = GraphicImageDynamicRenderer.class$("org.apache.myfaces.custom.graphicimagedynamic.GraphicImageDynamic")) : class$org$apache$myfaces$custom$graphicimagedynamic$GraphicImageDynamic));
        GraphicImageDynamic graphicImageDynamic = (GraphicImageDynamic)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("img", (UIComponent)graphicImageDynamic);
        HtmlRendererUtils.writeIdIfNecessary((ResponseWriter)writer, (UIComponent)graphicImageDynamic, (FacesContext)context);
        HtmlRendererUtils.renderHTMLAttributes((ResponseWriter)writer, (UIComponent)graphicImageDynamic, (String[])HTML.IMG_PASSTHROUGH_ATTRIBUTES);
        Map params = this.getParameterMap(context, component);
        String width = graphicImageDynamic.getWidth();
        if (width != null) {
            params.put(WIDTH_PARAM, width);
        }
        if ((height = graphicImageDynamic.getHeight()) != null) {
            params.put(HEIGHT_PARAM, height);
        }
        if ((imageRendererClass = graphicImageDynamic.getImageRendererClass()) == null) {
            throw new FacesException("No imageRendererClass defined for component " + component.getId());
        }
        params.put(RENDERER_PARAM, imageRendererClass.getName());
        AddResource addResource = AddResourceFactory.getInstance((FacesContext)context);
        String url = addResource.getResourceUri(context, (ResourceHandler)new ParameterResourceHandler(((Object)((Object)this)).getClass(), params));
        writer.writeAttribute("src", (Object)url, null);
        writer.endElement("img");
    }

    protected Map getParameterMap(FacesContext context, UIComponent component) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator iter = component.getChildren().iterator();
        while (iter.hasNext()) {
            UIParameter uiparam;
            Object value;
            UIComponent child = (UIComponent)iter.next();
            if (!(child instanceof UIParameter) || (value = (uiparam = (UIParameter)child).getValue()) == null) continue;
            result.put(uiparam.getName(), value);
        }
        return result;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveResource(ServletContext context, HttpServletRequest request, HttpServletResponse response, String resourceUri) throws IOException {
        FacesContextFactory facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = lifecycleFactory.getLifecycle(this.getLifecycleId(context));
        FacesContext facesContext = facesContextFactory.getFacesContext((Object)context, (Object)request, (Object)response, lifecycle);
        facesContext.setResponseStream((ResponseStream)new ImageResponseStream((OutputStream)response.getOutputStream()));
        try {
            Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
            Object rendererValue = requestMap.get(RENDERER_PARAM);
            if (rendererValue == null) {
                throw new FacesException("no image renderer defined.");
            }
            try {
                Class rendererClass = ClassUtils.classForName((String)rendererValue.toString());
                if (!(class$org$apache$myfaces$custom$graphicimagedynamic$ImageRenderer == null ? (class$org$apache$myfaces$custom$graphicimagedynamic$ImageRenderer = GraphicImageDynamicRenderer.class$("org.apache.myfaces.custom.graphicimagedynamic.ImageRenderer")) : class$org$apache$myfaces$custom$graphicimagedynamic$ImageRenderer).isAssignableFrom(rendererClass)) {
                    throw new FacesException("Image renderer class [" + rendererValue + "] does not implement " + (class$org$apache$myfaces$custom$graphicimagedynamic$ImageRenderer == null ? (class$org$apache$myfaces$custom$graphicimagedynamic$ImageRenderer = GraphicImageDynamicRenderer.class$("org.apache.myfaces.custom.graphicimagedynamic.ImageRenderer")) : class$org$apache$myfaces$custom$graphicimagedynamic$ImageRenderer).getName());
                }
                try {
                    ImageRenderer imageRenderer = (ImageRenderer)rendererClass.newInstance();
                    this.renderImage(imageRenderer, facesContext);
                }
                catch (InstantiationException e) {
                    throw new FacesException("could not instantiate image renderer class " + rendererValue + " : " + e.getMessage(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new FacesException("could not instantiate image renderer class " + rendererValue + " : " + e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    throw new FacesException("could not renderer image " + rendererValue + " : " + e.getMessage(), (Throwable)e);
                }
            }
            catch (ClassNotFoundException e) {
                throw new FacesException("image renderer class not found: " + e.getMessage(), (Throwable)e);
            }
            facesContext.getResponseStream().close();
        }
        finally {
            facesContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderImage(ImageRenderer imageRenderer, FacesContext facesContext) throws Exception {
        String contentType;
        ImageContext imageContext = this.createImageContext(facesContext);
        imageRenderer.setContext(facesContext, imageContext);
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        int contentLength = imageRenderer.getContentLength();
        if (contentLength > 0) {
            response.setContentLength(contentLength);
        }
        if ((contentType = imageRenderer.getContentType()) != null && contentType.length() > 0) {
            response.setContentType(contentType);
        }
        ResponseStream out = facesContext.getResponseStream();
        try {
            imageRenderer.renderResource(out);
        }
        finally {
            out.close();
            facesContext.responseComplete();
        }
    }

    protected ImageContext createImageContext(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestParameterMap();
        Object value = requestMap.get(WIDTH_PARAM);
        Integer width = null;
        if (value != null) {
            try {
                width = Integer.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                log.error((Object)("Invalid value for image width : " + value + ", " + e.getMessage()), (Throwable)e);
            }
        }
        Integer height = null;
        value = requestMap.get(HEIGHT_PARAM);
        if (value != null) {
            try {
                height = Integer.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                log.error((Object)("Invalid value for image height : " + value + ", " + e.getMessage()), (Throwable)e);
            }
        }
        return new SimpleImageContext(requestMap, width, height);
    }

    private String getLifecycleId(ServletContext context) {
        String lifecycleId = context.getInitParameter("javax.faces.LIFECYCLE_ID");
        return lifecycleId != null ? lifecycleId : "DEFAULT";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ImageResponseStream
    extends ResponseStream {
        private final OutputStream _out;

        private ImageResponseStream(OutputStream out) {
            this._out = out;
        }

        public void close() throws IOException {
            this._out.flush();
            this._out.close();
        }

        public void flush() throws IOException {
            this._out.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this._out.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this._out.write(b);
        }

        public void write(int b) throws IOException {
            this._out.write(b);
        }
    }

    protected static class SimpleImageContext
    implements ImageContext {
        private final Map _params;
        private final Integer _width;
        private final Integer _height;

        public SimpleImageContext(Map params, Integer width, Integer height) {
            this._params = params;
            this._width = width;
            this._height = height;
        }

        public Map getParamters() {
            return this._params;
        }

        public Integer getWidth() {
            return this._width;
        }

        public Integer getHeight() {
            return this._height;
        }
    }
}

