/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.picklist;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.commons.collections.CollectionUtils;
import org.apache.myfaces.custom.picklist.HtmlSelectManyPicklist;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlListboxRendererBase;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class HtmlPicklistRenderer
extends HtmlListboxRendererBase {
    private static final String FUNCTION_ADD_TO_SELECTED = "myfaces_picklist_addToSelected";
    private static final String FUNCTION_REMOVE_FROM_SELECTED = "myfaces_picklist_removeFromSelected";
    private static final String AVAILABLE_SUFFIX = "_AVAILABLE";
    private static final String SELECTED_SUFFIX = "_SELECTED";
    private static final String HIDDEN_SUFFIX = "_HIDDEN";
    static /* synthetic */ Class class$org$apache$myfaces$custom$picklist$HtmlSelectManyPicklist;
    static /* synthetic */ Class class$org$apache$myfaces$custom$picklist$HtmlPicklistRenderer;

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererUtils.checkParamValidity((FacesContext)facesContext, (UIComponent)uiComponent, null);
        if (!(uiComponent instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + uiComponent.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        String hiddenClientId = uiComponent.getClientId(facesContext) + HIDDEN_SUFFIX;
        Map paramValuesMap = facesContext.getExternalContext().getRequestParameterValuesMap();
        if (HtmlRendererUtils.isDisabledOrReadOnly((UIComponent)uiComponent)) {
            return;
        }
        if (paramValuesMap.containsKey(hiddenClientId)) {
            String[] valuesInline = (String[])paramValuesMap.get(hiddenClientId);
            if (valuesInline[0].trim().equals("")) {
                ((EditableValueHolder)uiComponent).setSubmittedValue((Object)new String[0]);
            } else {
                String[] reqValues = valuesInline[0].split(",");
                ((EditableValueHolder)uiComponent).setSubmittedValue((Object)reqValues);
            }
        } else {
            ((EditableValueHolder)uiComponent).setSubmittedValue((Object)new String[0]);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity((FacesContext)facesContext, (UIComponent)uiComponent, (Class)(class$org$apache$myfaces$custom$picklist$HtmlSelectManyPicklist == null ? (class$org$apache$myfaces$custom$picklist$HtmlSelectManyPicklist = HtmlPicklistRenderer.class$("org.apache.myfaces.custom.picklist.HtmlSelectManyPicklist")) : class$org$apache$myfaces$custom$picklist$HtmlSelectManyPicklist));
        HtmlSelectManyPicklist picklist = (HtmlSelectManyPicklist)uiComponent;
        this.encodeJavascript(facesContext, uiComponent);
        String availableListClientId = uiComponent.getClientId(facesContext) + AVAILABLE_SUFFIX;
        String selectedListClientId = uiComponent.getClientId(facesContext) + SELECTED_SUFFIX;
        String hiddenFieldCliendId = uiComponent.getClientId(facesContext) + HIDDEN_SUFFIX;
        List selectItemList = RendererUtils.getSelectItemList((UISelectMany)((UISelectMany)uiComponent));
        Converter converter = HtmlRendererUtils.findUISelectManyConverterFailsafe((FacesContext)facesContext, (UIComponent)uiComponent);
        Set lookupSet = HtmlRendererUtils.getSubmittedOrSelectedValuesAsSet((boolean)true, (UIComponent)uiComponent, (FacesContext)facesContext, (Converter)converter);
        List selectItemsForSelectedValues = this.selectItemsForSelectedList(facesContext, uiComponent, selectItemList, converter, lookupSet);
        List selectItemsForAvailableList = this.selectItemsForAvailableList(facesContext, uiComponent, selectItemList, selectItemsForSelectedValues, converter);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", uiComponent);
        writer.startElement("tr", uiComponent);
        writer.startElement("td", uiComponent);
        this.encodeSelect(facesContext, (UIComponent)picklist, availableListClientId, this.isDisabled(facesContext, uiComponent), picklist.getSize(), selectItemsForAvailableList, converter);
        writer.endElement("td");
        writer.startElement("td", uiComponent);
        String javascriptAddToSelected = "myfaces_picklist_addToSelected('" + availableListClientId + "','" + selectedListClientId + "','" + hiddenFieldCliendId + "')";
        String javascriptRemoveFromSelected = "myfaces_picklist_removeFromSelected('" + availableListClientId + "','" + selectedListClientId + "','" + hiddenFieldCliendId + "')";
        this.encodeSwapButton(facesContext, uiComponent, javascriptAddToSelected, ">");
        writer.startElement("br", uiComponent);
        writer.endElement("br");
        this.encodeSwapButton(facesContext, uiComponent, javascriptRemoveFromSelected, "<");
        writer.endElement("td");
        writer.startElement("td", uiComponent);
        this.encodeSelect(facesContext, (UIComponent)picklist, selectedListClientId, this.isDisabled(facesContext, uiComponent), picklist.getSize(), selectItemsForSelectedValues, converter);
        this.encodeHiddenField(facesContext, uiComponent, hiddenFieldCliendId, lookupSet);
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
    }

    private void encodeJavascript(FacesContext facesContext, UIComponent uiComponent) {
        AddResource addResource = AddResourceFactory.getInstance((FacesContext)facesContext);
        addResource.addJavaScriptAtPosition(facesContext, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$picklist$HtmlPicklistRenderer == null ? (class$org$apache$myfaces$custom$picklist$HtmlPicklistRenderer = HtmlPicklistRenderer.class$("org.apache.myfaces.custom.picklist.HtmlPicklistRenderer")) : class$org$apache$myfaces$custom$picklist$HtmlPicklistRenderer, "picklist.js");
    }

    private void encodeSwapButton(FacesContext facesContext, UIComponent uiComponent, String javaScriptFunction, String text) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("onclick", (Object)javaScriptFunction, null);
        writer.writeAttribute("value", (Object)text, null);
        writer.endElement("input");
    }

    private void encodeSelect(FacesContext facesContext, UIComponent uiComponent, String clientId, boolean disabled, int size, List selectItemsToDisplay, Converter converter) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("select", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("multiple", (Object)"true", null);
        if (size == 0) {
            writer.writeAttribute("size", (Object)Integer.toString(selectItemsToDisplay.size()), null);
        } else {
            writer.writeAttribute("size", (Object)Integer.toString(size), null);
        }
        HtmlRendererUtils.renderHTMLAttributes((ResponseWriter)writer, (UIComponent)uiComponent, (String[])HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        HtmlRendererUtils.renderSelectOptions((FacesContext)facesContext, (UIComponent)uiComponent, (Converter)converter, (Set)Collections.EMPTY_SET, (List)selectItemsToDisplay);
        writer.writeText((Object)"", null);
        writer.endElement("select");
    }

    private void encodeHiddenField(FacesContext facesContext, UIComponent uiComponent, String hiddenFieldCliendId, Set lookupSet) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", "type");
        writer.writeAttribute("id", (Object)hiddenFieldCliendId, "id");
        writer.writeAttribute("name", (Object)hiddenFieldCliendId, null);
        StringBuffer sb = new StringBuffer();
        int n = 0;
        Iterator i = lookupSet.iterator();
        while (i.hasNext()) {
            if (n > 0) {
                sb.append(",");
            }
            String value = (String)i.next();
            sb.append(value);
            ++n;
        }
        writer.writeAttribute("value", (Object)sb.toString(), null);
        writer.endElement("input");
    }

    private List selectItemsForSelectedList(FacesContext facesContext, UIComponent uiComponent, List selectItemList, Converter converter, Set lookupSet) {
        ArrayList<SelectItem> selectItemForSelectedValues = new ArrayList<SelectItem>(lookupSet.size());
        Iterator i = selectItemList.iterator();
        while (i.hasNext()) {
            SelectItem selectItem = (SelectItem)i.next();
            String itemStrValue = RendererUtils.getConvertedStringValue((FacesContext)facesContext, (UIComponent)uiComponent, (Converter)converter, (SelectItem)selectItem);
            Iterator i2 = lookupSet.iterator();
            while (i2.hasNext()) {
                Object value = i2.next();
                if (!value.equals(itemStrValue)) continue;
                selectItemForSelectedValues.add(selectItem);
            }
        }
        return selectItemForSelectedValues;
    }

    private List selectItemsForAvailableList(FacesContext facesContext, UIComponent uiComponent, List selectItemList, List selectItemsForSelectedList, Converter converter) {
        return new ArrayList(CollectionUtils.subtract((Collection)selectItemList, (Collection)selectItemsForSelectedList));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

