/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.security;

import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.apache.myfaces.custom.security.SecurityContextImpl;

public class SecurityContextVariableResolver
extends VariableResolver {
    private static final String SECURITY_CONTEXT = "securityContext";
    private static final String INIT_PARAM_SECURITY_CONTEXT = "org.apache.myfaces.SECURITY_CONTEXT";
    private VariableResolver originalResolver;

    public SecurityContextVariableResolver(VariableResolver variableresolver) {
        this.originalResolver = variableresolver;
    }

    public Object resolveVariable(FacesContext facesContext, String name) throws EvaluationException {
        if (SECURITY_CONTEXT.equals(name)) {
            return this.getSecurityContextImpl(facesContext);
        }
        return this.originalResolver.resolveVariable(facesContext, name);
    }

    private Object getSecurityContextImpl(FacesContext facesContext) {
        String className = facesContext.getExternalContext().getInitParameter(INIT_PARAM_SECURITY_CONTEXT);
        if (className == null) {
            return new SecurityContextImpl();
        }
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new EvaluationException((Throwable)e);
        }
    }
}

