/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.toggle;

import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class TogglePanel
extends HtmlPanelGroup {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.TogglePanel";
    public static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.TogglePanel";
    public static final boolean DEFAULT_TOGGLED = false;
    private Boolean _toggled = null;

    public TogglePanel() {
        this.setRendererType("org.apache.myfaces.TogglePanel");
    }

    public boolean isToggled() {
        if (this._toggled != null) {
            return this._toggled;
        }
        ValueBinding vb = this.getValueBinding("toggled");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void setToggled(boolean toggleMode) {
        this._toggled = toggleMode;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._toggled};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._toggled = (Boolean)values[1];
    }

    public void processDecodes(FacesContext context) {
        super.processDecodes(context);
        String hiddenFieldId = this.getClientId(context) + "_hidden";
        String toggleMode = (String)context.getExternalContext().getRequestParameterMap().get(hiddenFieldId);
        if (toggleMode != null && toggleMode.trim().equals("1")) {
            this.setToggled(true);
        }
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        this.setToggled(false);
    }
}

