/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.ext;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.custom.clientvalidation.common.CVUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlFormRendererBase;

public class HtmlFormRenderer
extends HtmlFormRendererBase {
    private static String CLIENT_VALIDATON_SCRIPT = "return tomahawk.executeClientLifeCycle();";

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        if (CVUtils.isCVEnabled() && !this.isDecorated(facesContext, component)) {
            this.decorateOnSubmit(facesContext, component);
        }
        super.encodeBegin(facesContext, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        if (CVUtils.isCVEnabled()) {
            CVUtils.encodeJavascript(facesContext);
            CVUtils.queueCVCalls((UIComponent)facesContext.getViewRoot());
            CVUtils.encodeValidationScript(facesContext);
        }
    }

    private boolean isDecorated(FacesContext facesContext, UIComponent child) {
        String onSubmit = (String)child.getAttributes().get("onsubmit");
        return onSubmit != null && onSubmit.indexOf(CLIENT_VALIDATON_SCRIPT) != -1;
    }

    private void decorateOnSubmit(FacesContext facesContext, UIComponent child) {
        String onSubmitEvent = (String)child.getAttributes().get("onsubmit");
        if (onSubmitEvent == null) {
            child.getAttributes().put("onsubmit", CLIENT_VALIDATON_SCRIPT);
        } else {
            child.getAttributes().put("onsubmit", onSubmitEvent + ";" + CLIENT_VALIDATON_SCRIPT);
        }
    }
}

