/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.management;

import java.util.LinkedHashMap;
import java.util.List;
import org.nuxeo.ecm.core.storage.sql.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.sql.BinaryManagerStatus;
import org.nuxeo.ecm.core.storage.sql.RepositoryManagement;
import org.nuxeo.ecm.core.storage.sql.RepositoryResolver;
import org.nuxeo.ecm.core.storage.sql.management.RepositoryStatusMBean;

public class RepositoryStatus
implements RepositoryStatusMBean {
    @Override
    public String listActiveSessions() {
        List repositories = RepositoryResolver.getRepositories();
        StringBuilder buf = new StringBuilder();
        buf.append("Actives sessions for SQL repositories:<br />");
        for (RepositoryManagement repository : repositories) {
            buf.append("<b>").append(repository.getName()).append("</b>: ");
            buf.append(repository.getActiveSessionsCount());
            buf.append("<br />");
        }
        return buf.toString();
    }

    @Override
    public int getActiveSessionsCount() {
        List repositories = RepositoryResolver.getRepositories();
        int count = 0;
        for (RepositoryManagement repository : repositories) {
            count += repository.getActiveSessionsCount();
        }
        return count;
    }

    @Override
    public String clearCaches() {
        List repositories = RepositoryResolver.getRepositories();
        StringBuilder buf = new StringBuilder();
        buf.append("Cleared cached objects for SQL repositories:<br />");
        for (RepositoryManagement repository : repositories) {
            buf.append("<b>").append(repository.getName()).append("</b>: ");
            buf.append(repository.clearCaches());
            buf.append("<br />");
        }
        return buf.toString();
    }

    @Override
    public long getCachesSize() {
        List repositories = RepositoryResolver.getRepositories();
        long size = 0L;
        for (RepositoryManagement repository : repositories) {
            size += repository.getCacheSize();
        }
        return size;
    }

    @Override
    public String listRemoteSessions() {
        List repositories = RepositoryResolver.getRepositories();
        StringBuilder buf = new StringBuilder();
        buf.append("Actives remote session for SQL repositories:<br />");
        for (RepositoryManagement repository : repositories) {
            buf.append("<b>").append(repository.getName()).append("</b>");
            buf.append("<br/>");
        }
        return buf.toString();
    }

    @Override
    public BinaryManagerStatus gcBinaries(boolean delete) {
        BinaryGarbageCollector gc;
        BinaryManagerStatus status = new BinaryManagerStatus();
        List repositories = RepositoryResolver.getRepositories();
        long start = System.currentTimeMillis();
        LinkedHashMap<String, BinaryGarbageCollector> repogcs = new LinkedHashMap<String, BinaryGarbageCollector>();
        LinkedHashMap<String, BinaryGarbageCollector> gcs = new LinkedHashMap<String, BinaryGarbageCollector>();
        for (RepositoryManagement repository : repositories) {
            String gcid;
            gc = repository.getBinaryGarbageCollector();
            if (gc == null) {
                // empty if block
            }
            if (gcs.containsKey(gcid = gc.getId())) {
                gc = (BinaryGarbageCollector)gcs.get(gcid);
            } else {
                gcs.put(gcid, gc);
                gc.start();
            }
            repogcs.put(repository.getName(), gc);
        }
        for (RepositoryManagement repository : repositories) {
            gc = (BinaryGarbageCollector)repogcs.get(repository.getName());
            repository.markReferencedBinaries(gc);
        }
        for (BinaryGarbageCollector gc2 : gcs.values()) {
            gc2.stop(delete);
            BinaryManagerStatus s = gc2.getStatus();
            status.numBinaries += s.numBinaries;
            status.sizeBinaries += s.sizeBinaries;
            status.numBinariesGC += s.numBinariesGC;
            status.sizeBinariesGC += s.sizeBinariesGC;
        }
        status.gcDuration = System.currentTimeMillis() - start;
        return status;
    }

    @Override
    public boolean isBinariesGCInProgress() {
        List repositories = RepositoryResolver.getRepositories();
        for (RepositoryManagement repo : repositories) {
            BinaryGarbageCollector gc = repo.getBinaryGarbageCollector();
            if (!(gc != null & gc.isInProgress())) continue;
            return true;
        }
        return false;
    }
}

