/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.primitives;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.schema.types.PrimitiveType;

public final class BinaryType
extends PrimitiveType {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(BinaryType.class);
    public static final String ID = "binary";
    public static final BinaryType INSTANCE = new BinaryType();

    private BinaryType() {
        super(ID);
    }

    @Override
    public boolean validate(Object object) {
        return true;
    }

    @Override
    public Object convert(Object value) {
        if (value instanceof CharSequence) {
            return new ByteArrayInputStream(value.toString().getBytes());
        }
        if (value instanceof byte[]) {
            return new ByteArrayInputStream((byte[])value);
        }
        if (value instanceof InputStream) {
            return value;
        }
        return null;
    }

    public static Object parseString(String str) {
        return new ByteArrayInputStream(str.getBytes());
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public Object decode(String str) {
        if (str == null) {
            return null;
        }
        return new ByteArrayInputStream(str.getBytes());
    }

    @Override
    public String encode(Object object) {
        if (object instanceof InputStream) {
            try {
                return FileUtils.read((InputStream)((InputStream)object));
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                return null;
            }
        }
        return object.toString();
    }
}

