/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.invite;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.user.invite.InvitationUserFactory;
import org.nuxeo.ecm.user.invite.UserRegistrationException;
import org.nuxeo.runtime.api.Framework;

public class DefaultInvitationUserFactory
implements InvitationUserFactory {
    private static final Log log = LogFactory.getLog(DefaultInvitationUserFactory.class);

    @Override
    public void doPostUserCreation(CoreSession session, DocumentModel registrationDoc, NuxeoPrincipal user) throws ClientException, UserRegistrationException {
    }

    @Override
    public NuxeoPrincipal doCreateUser(CoreSession session, DocumentModel registrationDoc) throws ClientException, UserRegistrationException {
        UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
        String email = (String)((Object)registrationDoc.getPropertyValue("userinfo:email"));
        if (email == null) {
            throw new UserRegistrationException("Email address must be specififed");
        }
        String login = (String)((Object)registrationDoc.getPropertyValue("userinfo:login"));
        NuxeoPrincipal user = userManager.getPrincipal(login);
        if (user == null) {
            DocumentModel newUserDoc = userManager.getBareUserModel();
            newUserDoc.setPropertyValue("username", registrationDoc.getPropertyValue("userinfo:login"));
            newUserDoc.setPropertyValue("password", registrationDoc.getPropertyValue("userinfo:password"));
            newUserDoc.setPropertyValue("firstName", registrationDoc.getPropertyValue("userinfo:firstName"));
            newUserDoc.setPropertyValue("lastName", registrationDoc.getPropertyValue("userinfo:lastName"));
            newUserDoc.setPropertyValue("email", registrationDoc.getPropertyValue("userinfo:email"));
            newUserDoc.setPropertyValue("company", registrationDoc.getPropertyValue("userinfo:company"));
            userManager.createUser(newUserDoc);
            user = userManager.getPrincipal(login);
            log.info((Object)("New user created:" + user.getName()));
        } else if (!email.equals(((NuxeoPrincipalImpl)user).getEmail())) {
            throw new UserRegistrationException("This login is not available");
        }
        return user;
    }
}

