/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.ra;

import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.storage.PartialList;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.ra.ManagedConnectionImpl;
import org.nuxeo.runtime.services.streaming.FileSource;

public class ConnectionImpl
implements Session {
    private ManagedConnectionImpl managedConnection;
    private SessionImpl session;

    public ConnectionImpl(ManagedConnectionImpl managedConnection) {
        this.managedConnection = managedConnection;
    }

    protected ManagedConnectionImpl getManagedConnection() {
        return this.managedConnection;
    }

    protected void setManagedConnection(ManagedConnectionImpl managedConnection) {
        this.managedConnection = managedConnection;
    }

    protected void associate(SessionImpl session) {
        this.session = session;
    }

    protected void disassociate() {
        this.session = null;
    }

    public void close() throws ResourceException {
        this.disassociate();
        this.managedConnection = null;
    }

    public Interaction createInteraction() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    private Session getSession() throws StorageException {
        if (this.session == null) {
            throw new StorageException("Cannot use closed connection handle: " + this);
        }
        return this.session;
    }

    public Mapper getMapper() throws StorageException {
        return this.getSession().getMapper();
    }

    public boolean isLive() {
        return this.session != null && this.session.isLive();
    }

    public boolean isStateSharedByAllThreadSessions() {
        return true;
    }

    public String getRepositoryName() throws StorageException {
        return this.getSession().getRepositoryName();
    }

    public Binary getBinary(InputStream in) throws StorageException {
        return this.getSession().getBinary(in);
    }

    public Binary getBinary(FileSource source) throws StorageException {
        return this.getSession().getBinary(source);
    }

    public Model getModel() throws StorageException {
        return this.getSession().getModel();
    }

    public void save() throws StorageException {
        this.getSession().save();
    }

    public Node getRootNode() throws StorageException {
        return this.getSession().getRootNode();
    }

    public Node getNodeById(Serializable id) throws StorageException {
        return this.getSession().getNodeById(id);
    }

    public List<Node> getNodesByIds(List<Serializable> ids) throws StorageException {
        return this.getSession().getNodesByIds(ids);
    }

    public Node getNodeByPath(String path, Node node) throws StorageException {
        return this.getSession().getNodeByPath(path, node);
    }

    public boolean addMixinType(Node node, String mixin) throws StorageException {
        return this.getSession().addMixinType(node, mixin);
    }

    public boolean removeMixinType(Node node, String mixin) throws StorageException {
        return this.getSession().removeMixinType(node, mixin);
    }

    public boolean hasChildNode(Node parent, String name, boolean complexProp) throws StorageException {
        return this.getSession().hasChildNode(parent, name, complexProp);
    }

    public Node getChildNode(Node parent, String name, boolean complexProp) throws StorageException {
        return this.getSession().getChildNode(parent, name, complexProp);
    }

    public boolean hasChildren(Node parent, boolean complexProp) throws StorageException {
        return this.getSession().hasChildren(parent, complexProp);
    }

    public List<Node> getChildren(Node parent, String name, boolean complexProp) throws StorageException {
        return this.getSession().getChildren(parent, name, complexProp);
    }

    public Node addChildNode(Node parent, String name, Long pos, String typeName, boolean complexProp) throws StorageException {
        return this.getSession().addChildNode(parent, name, pos, typeName, complexProp);
    }

    public Node addChildNode(Serializable id, Node parent, String name, Long pos, String typeName, boolean complexProp) throws StorageException {
        return this.getSession().addChildNode(id, parent, name, pos, typeName, complexProp);
    }

    public void removeNode(Node node) throws StorageException {
        this.getSession().removeNode(node);
    }

    public void removePropertyNode(Node node) throws StorageException {
        this.getSession().removePropertyNode(node);
    }

    public Node getParentNode(Node node) throws StorageException {
        return this.getSession().getParentNode(node);
    }

    public String getPath(Node node) throws StorageException {
        return this.getSession().getPath(node);
    }

    public void orderBefore(Node node, Node src, Node dest) throws StorageException {
        this.getSession().orderBefore(node, src, dest);
    }

    public Node move(Node source, Node parent, String name) throws StorageException {
        return this.getSession().move(source, parent, name);
    }

    public Node copy(Node source, Node parent, String name) throws StorageException {
        return this.getSession().copy(source, parent, name);
    }

    public Node checkIn(Node node, String label, String checkinComment) throws StorageException {
        return this.getSession().checkIn(node, label, checkinComment);
    }

    public void checkOut(Node node) throws StorageException {
        this.getSession().checkOut(node);
    }

    public void restore(Node node, Node version) throws StorageException {
        this.getSession().restore(node, version);
    }

    public Node getVersionByLabel(Serializable versionSeriesId, String label) throws StorageException {
        return this.getSession().getVersionByLabel(versionSeriesId, label);
    }

    public List<Node> getVersions(Serializable versionSeriesId) throws StorageException {
        return this.getSession().getVersions(versionSeriesId);
    }

    public Node getLastVersion(Serializable versionSeriesId) throws StorageException {
        return this.getSession().getLastVersion(versionSeriesId);
    }

    public List<Node> getProxies(Node document, Node parent) throws StorageException {
        return this.getSession().getProxies(document, parent);
    }

    public void setProxyTarget(Node proxy, Serializable targetId) throws StorageException {
        this.getSession().setProxyTarget(proxy, targetId);
    }

    public Node addProxy(Serializable targetId, Serializable versionSeriesId, Node parent, String name, Long pos) throws StorageException {
        return this.getSession().addProxy(targetId, versionSeriesId, parent, name, pos);
    }

    public PartialList<Serializable> query(String query, QueryFilter queryFilter, boolean countTotal) throws StorageException {
        return this.getSession().query(query, queryFilter, countTotal);
    }

    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, boolean countTotal) throws StorageException {
        return this.getSession().query(query, queryType, queryFilter, countTotal);
    }

    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, long countUpTo) throws StorageException {
        return this.getSession().query(query, queryType, queryFilter, countUpTo);
    }

    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, Object ... params) throws StorageException {
        return this.getSession().queryAndFetch(query, queryType, queryFilter, params);
    }

    public Lock getLock(Serializable id) throws StorageException {
        return this.getSession().getLock(id);
    }

    public Lock setLock(Serializable id, Lock lock) throws StorageException {
        return this.getSession().setLock(id, lock);
    }

    public Lock removeLock(Serializable id, String owner, boolean force) throws StorageException {
        return this.getSession().removeLock(id, owner, force);
    }

    public void requireReadAclsUpdate() {
        if (this.session != null) {
            this.session.requireReadAclsUpdate();
        }
    }

    public void updateReadAcls() throws StorageException {
        this.getSession().updateReadAcls();
    }

    public void rebuildReadAcls() throws StorageException {
        this.getSession().rebuildReadAcls();
    }

    public Map<String, String> getBinaryFulltext(Serializable id) throws StorageException {
        return this.getSession().getBinaryFulltext(id);
    }
}

