/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.ra;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepositoryService;
import org.nuxeo.ecm.core.storage.sql.ra.ManagedConnectionFactoryImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerConfiguration;
import org.nuxeo.runtime.jtajca.NuxeoContainer;

public class PoolingRepositoryFactory
implements RepositoryFactory {
    private String repositoryName;
    private static final String[] CM_NAMES_PREFIXES = new String[]{"java:comp/NuxeoConnectionManager/", "java:comp/env/NuxeoConnectionManager/", "java:NuxeoConnectionManager/"};

    public void init(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public Object call() {
        SQLRepositoryService sqlRepositoryService = (SQLRepositoryService)Framework.getLocalService(SQLRepositoryService.class);
        RepositoryDescriptor descriptor = sqlRepositoryService.getRepositoryDescriptor(this.repositoryName);
        NuxeoConnectionManagerConfiguration pool = descriptor.pool;
        ManagedConnectionFactoryImpl managedConnectionFactory = new ManagedConnectionFactoryImpl();
        managedConnectionFactory.setName(this.repositoryName);
        try {
            ConnectionManager connectionManager = PoolingRepositoryFactory.lookupConnectionManager(this.repositoryName, pool);
            return (Repository)managedConnectionFactory.createConnectionFactory(connectionManager);
        }
        catch (NamingException | ResourceException e) {
            throw new RuntimeException(e);
        }
    }

    protected static ConnectionManager lookupConnectionManager(String repositoryName, NuxeoConnectionManagerConfiguration pool) throws NamingException {
        ConnectionManager cm = NuxeoContainer.getConnectionManager((String)repositoryName);
        if (cm != null) {
            return cm;
        }
        InitialContext context = new InitialContext();
        for (String name : CM_NAMES_PREFIXES) {
            try {
                cm = (ConnectionManager)context.lookup(name + repositoryName);
                if (cm == null) continue;
                return cm;
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        cm = NuxeoContainer.installConnectionManager((String)repositoryName, (NuxeoConnectionManagerConfiguration)pool);
        if (cm != null) {
            return cm;
        }
        throw new NamingException("NuxeoConnectionManager not found in JNDI");
    }
}

