/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class RedisOutputStream
extends FilterOutputStream {
    protected final byte[] buf;
    protected int count;
    private static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};

    public RedisOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public RedisOutputStream(OutputStream out, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public void write(byte b) throws IOException {
        this.buf[this.count++] = b;
        if (this.count == this.buf.length) {
            this.flushBuffer();
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.flushBuffer();
            this.out.write(b, off, len);
        } else {
            if (len >= this.buf.length - this.count) {
                this.flushBuffer();
            }
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
        }
    }

    public void writeAsciiCrLf(String in) throws IOException {
        int size = in.length();
        for (int i = 0; i != size; ++i) {
            this.buf[this.count++] = (byte)in.charAt(i);
            if (this.count != this.buf.length) continue;
            this.flushBuffer();
        }
        this.writeCrLf();
    }

    public static boolean isSurrogate(char ch) {
        return ch >= '\ud800' && ch <= '\udfff';
    }

    public static int utf8Length(String str) {
        int strLen = str.length();
        int utfLen = 0;
        for (int i = 0; i != strLen; ++i) {
            char c = str.charAt(i);
            if (c < '\u0080') {
                ++utfLen;
                continue;
            }
            if (c < '\u0800') {
                utfLen += 2;
                continue;
            }
            if (RedisOutputStream.isSurrogate(c)) {
                ++i;
                utfLen += 4;
                continue;
            }
            utfLen += 3;
        }
        return utfLen;
    }

    public void writeCrLf() throws IOException {
        if (2 >= this.buf.length - this.count) {
            this.flushBuffer();
        }
        this.buf[this.count++] = 13;
        this.buf[this.count++] = 10;
    }

    public void writeUtf8CrLf(String str) throws IOException {
        char c;
        int i;
        int strLen = str.length();
        for (i = 0; i < strLen && (c = str.charAt(i)) < '\u0080'; ++i) {
            this.buf[this.count++] = (byte)c;
            if (this.count != this.buf.length) continue;
            this.flushBuffer();
        }
        while (i < strLen) {
            c = str.charAt(i);
            if (c < '\u0080') {
                this.buf[this.count++] = (byte)c;
                if (this.count == this.buf.length) {
                    this.flushBuffer();
                }
            } else if (c < '\u0800') {
                if (2 >= this.buf.length - this.count) {
                    this.flushBuffer();
                }
                this.buf[this.count++] = (byte)(0xC0 | c >> 6);
                this.buf[this.count++] = (byte)(0x80 | c & 0x3F);
            } else if (RedisOutputStream.isSurrogate(c)) {
                if (4 >= this.buf.length - this.count) {
                    this.flushBuffer();
                }
                int uc = Character.toCodePoint(c, str.charAt(i++));
                this.buf[this.count++] = (byte)(0xF0 | uc >> 18);
                this.buf[this.count++] = (byte)(0x80 | uc >> 12 & 0x3F);
                this.buf[this.count++] = (byte)(0x80 | uc >> 6 & 0x3F);
                this.buf[this.count++] = (byte)(0x80 | uc & 0x3F);
            } else {
                if (3 >= this.buf.length - this.count) {
                    this.flushBuffer();
                }
                this.buf[this.count++] = (byte)(0xE0 | c >> 12);
                this.buf[this.count++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buf[this.count++] = (byte)(0x80 | c & 0x3F);
            }
            ++i;
        }
        this.writeCrLf();
    }

    public void writeIntCrLf(int value) throws IOException {
        int r;
        int q;
        if (value < 0) {
            this.write(45);
            value = -value;
        }
        int size = 0;
        while (value > sizeTable[size]) {
            ++size;
        }
        if (++size >= this.buf.length - this.count) {
            this.flushBuffer();
        }
        int charPos = this.count + size;
        while (value >= 65536) {
            q = value / 100;
            r = value - ((q << 6) + (q << 5) + (q << 2));
            value = q;
            this.buf[--charPos] = DigitOnes[r];
            this.buf[--charPos] = DigitTens[r];
        }
        do {
            q = value * 52429 >>> 19;
            r = value - ((q << 3) + (q << 1));
            this.buf[--charPos] = digits[r];
        } while ((value = q) != 0);
        this.count += size;
        this.writeCrLf();
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }
}

