/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.PropertyType;

public abstract class BaseProperty {
    protected final String name;
    public final PropertyType type;
    private final boolean readonly;

    public BaseProperty(String name, PropertyType type, boolean readonly) {
        this.name = name;
        this.type = type;
        this.readonly = readonly;
    }

    public String getName() {
        return this.name;
    }

    public void refresh(boolean keepChanges) throws StorageException {
        throw new UnsupportedOperationException();
    }

    public void remove() throws StorageException {
        throw new UnsupportedOperationException();
    }

    public void save() throws StorageException {
        throw new UnsupportedOperationException();
    }

    protected void checkWritable() throws StorageException {
        if (this.readonly) {
            throw new StorageException("Cannot write property: " + this.name);
        }
    }
}

