/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.FulltextParser;
import org.nuxeo.ecm.core.storage.sql.ModelFulltext;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.RepositoryManagement;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepository;
import org.nuxeo.runtime.api.Framework;

public class RepositoryResolver {
    public static final Map<String, RepositoryImpl> testRepositories = new HashMap<String, RepositoryImpl>();
    private static final String CONNECTIONFACTORYIMPL_CLASS = "org.nuxeo.ecm.core.storage.sql.ra.ConnectionFactoryImpl";

    private RepositoryResolver() {
    }

    public static void registerTestRepository(RepositoryImpl repo) {
        testRepositories.put(repo.getName(), repo);
    }

    public static List<RepositoryManagement> getRepositories() {
        RepositoryService repositoryService = (RepositoryService)Framework.getLocalService(RepositoryService.class);
        List repositoryNames = repositoryService.getRepositoryNames();
        ArrayList<RepositoryManagement> repositories = new ArrayList<RepositoryManagement>(repositoryNames.size());
        for (String repositoryName : repositoryNames) {
            repositories.add(RepositoryResolver.getRepository(repositoryName));
        }
        return repositories;
    }

    public static Repository getRepository(String repositoryName) {
        RepositoryService repositoryService = (RepositoryService)Framework.getLocalService(RepositoryService.class);
        Object repo = repositoryService.getRepository(repositoryName);
        if (repo == null) {
            repo = testRepositories.get(repositoryName);
        }
        if (repo == null) {
            throw new ClientRuntimeException("Cannot find repository " + repositoryName);
        }
        if (repo instanceof Repository) {
            return (Repository)repo;
        }
        if (repo instanceof SQLRepository) {
            return ((SQLRepository)repo).repository;
        }
        throw new RuntimeException("Unknown repository class: " + repo.getClass().getName());
    }

    public static BinaryManager getBinaryManager(String repositoryName) {
        return RepositoryResolver.getRepositoryImpl(RepositoryResolver.getRepository(repositoryName)).getBinaryManager();
    }

    public static Class<? extends FulltextParser> getFulltextParserClass(String repositoryName) {
        return RepositoryResolver.getRepositoryImpl(RepositoryResolver.getRepository(repositoryName)).getFulltextParserClass();
    }

    public static ModelFulltext getModelFulltext(String repositoryName) {
        return RepositoryResolver.getRepositoryImpl(RepositoryResolver.getRepository(repositoryName)).getModel().getFulltextInfo();
    }

    public static RepositoryImpl getRepositoryImpl(Repository repository) {
        if (repository instanceof RepositoryImpl) {
            return (RepositoryImpl)repository;
        }
        if (CONNECTIONFACTORYIMPL_CLASS.equals(repository.getClass().getName())) {
            try {
                Field f1 = repository.getClass().getDeclaredField("managedConnectionFactory");
                f1.setAccessible(true);
                Object factory = f1.get(repository);
                Field f2 = factory.getClass().getDeclaredField("repository");
                f2.setAccessible(true);
                return (RepositoryImpl)f2.get(factory);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unknown repository class: " + repository.getClass());
    }
}

