/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;
import org.nuxeo.runtime.api.Framework;

public class SQLRepository
implements Repository {
    private static final Log log = LogFactory.getLog(SQLRepository.class);
    public final RepositoryImpl repository;
    private final SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
    private final String name;

    public SQLRepository(RepositoryDescriptor descriptor) {
        try {
            this.repository = new RepositoryImpl(descriptor);
            this.name = descriptor.name;
        }
        catch (StorageException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public String getName() {
        return this.name;
    }

    public Session getSession(NuxeoPrincipal principal, String sessionId) throws DocumentException {
        try {
            return new SQLSession(this.repository.getConnection(), this, principal, sessionId);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public SchemaManager getTypeManager() {
        return this.schemaManager;
    }

    public void initialize() {
    }

    public synchronized Session[] getOpenedSessions() {
        return new Session[0];
    }

    public void shutdown() {
        try {
            this.repository.close();
        }
        catch (StorageException e) {
            log.error((Object)"Cannot close repository", (Throwable)((Object)e));
        }
    }

    public int getStartedSessionsCount() {
        return 0;
    }

    public int getClosedSessionsCount() {
        return 0;
    }

    public int getActiveSessionsCount() {
        return 0;
    }
}

