/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.util.concurrent.Callable;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class SQLRepositoryService
extends DefaultComponent {
    private static final String XP_REPOSITORY = "repository";
    protected RepositoryDescriptorRegistry registry = new RepositoryDescriptorRegistry();

    public void activate(ComponentContext context) throws Exception {
        this.registry.clear();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.registry.clear();
    }

    public void registerContribution(Object contrib, String xpoint, ComponentInstance contributor) {
        if (!XP_REPOSITORY.equals(xpoint)) {
            throw new RuntimeException("Unknown extension point: " + xpoint);
        }
        this.addContribution((RepositoryDescriptor)contrib);
    }

    public void unregisterContribution(Object contrib, String xpoint, ComponentInstance contributor) throws Exception {
        if (!XP_REPOSITORY.equals(xpoint)) {
            throw new RuntimeException("Unknown extension point: " + xpoint);
        }
        this.removeContribution((RepositoryDescriptor)contrib);
    }

    protected void addContribution(RepositoryDescriptor descriptor) {
        this.registry.addContribution(descriptor);
        this.updateRegistration(descriptor.name);
    }

    protected void removeContribution(RepositoryDescriptor descriptor) {
        this.registry.removeContribution(descriptor);
        this.updateRegistration(descriptor.name);
    }

    protected void updateRegistration(String repositoryName) {
        RepositoryFactory repositoryFactory;
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        RepositoryDescriptor descriptor = this.registry.getRepositoryDescriptor(repositoryName);
        if (descriptor == null) {
            repositoryManager.removeRepository(repositoryName);
            return;
        }
        Class<? extends RepositoryFactory> repositoryFactoryClass = descriptor.getRepositoryFactoryClass();
        if (repositoryFactoryClass == null) {
            repositoryManager.removeRepository(repositoryName);
            return;
        }
        try {
            repositoryFactory = repositoryFactoryClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Cannot instantiate repository: " + repositoryName, e);
        }
        repositoryFactory.init(repositoryName);
        Repository repository = new Repository(repositoryName, descriptor.label, descriptor.isDefault(), (Callable)repositoryFactory);
        repositoryManager.addRepository(repository);
    }

    public RepositoryDescriptor getRepositoryDescriptor(String name) {
        return this.registry.getRepositoryDescriptor(name);
    }

    protected static class RepositoryDescriptorRegistry
    extends SimpleContributionRegistry<RepositoryDescriptor> {
        protected RepositoryDescriptorRegistry() {
        }

        public String getContributionId(RepositoryDescriptor contrib) {
            return contrib.name;
        }

        public RepositoryDescriptor clone(RepositoryDescriptor orig) {
            return new RepositoryDescriptor(orig);
        }

        public void merge(RepositoryDescriptor src, RepositoryDescriptor dst) {
            dst.merge(src);
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public void clear() {
            this.currentContribs.clear();
        }

        public RepositoryDescriptor getRepositoryDescriptor(String id) {
            return (RepositoryDescriptor)this.getCurrentContribution(id);
        }
    }
}

