/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.ecm.platform.relations.api.Blank;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.GraphDescription;
import org.nuxeo.ecm.platform.relations.api.Literal;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.QueryResult;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.Subject;
import org.nuxeo.ecm.platform.relations.api.impl.NodeFactory;
import org.nuxeo.ecm.platform.relations.api.impl.RelationDate;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.platform.relations.api.util.RelationConstants;
import org.nuxeo.runtime.api.Framework;

public class CoreGraph
implements Graph {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CoreGraph.class);
    public static final String OPTION_DOCTYPE = "doctype";
    public static final String REL_TYPE = "Relation";
    public static final String REL_PREDICATE = "relation:predicate";
    public static final String REL_SOURCE_ID = "relation:source";
    public static final String REL_SOURCE_URI = "relation:sourceUri";
    public static final String REL_TARGET_ID = "relation:target";
    public static final String REL_TARGET_URI = "relation:targetUri";
    public static final String REL_TARGET_STRING = "relation:targetString";
    public static final String DC_CREATED = "dc:created";
    public static final String DC_CREATOR = "dc:creator";
    public static final String DC_MODIFIED = "dc:modified";
    public static final String DC_TITLE = "dc:title";
    public static final String DC_DESCRIPTION = "dc:description";
    public static String BLANK_NS = "-:";
    public static String DOCUMENT_NAMESPACE = "http://www.nuxeo.org/document/uid/";
    public static String DOCUMENT_NAMESPACE2 = DOCUMENT_NAMESPACE.substring(0, DOCUMENT_NAMESPACE.length() - 1);
    public static final String COMMENT_NAMESPACE = "http://www.nuxeo.org/comments/uid";
    public static final String[] DOC_NAMESPACES = new String[]{DOCUMENT_NAMESPACE, DOCUMENT_NAMESPACE2, "http://www.nuxeo.org/comments/uid"};
    protected static final List<Statement> EMPTY_STATEMENTS = Collections.emptyList();
    protected static final Statement ALL = new StatementImpl(null, null, null);
    protected CoreSession session;
    protected String name;
    protected String docType = "Relation";
    public Map<String, String> namespaces;
    public List<String> namespaceList = Collections.emptyList();

    public CoreGraph(CoreSession session) {
        this.session = session;
    }

    public void setDescription(GraphDescription graphDescription) {
        this.name = graphDescription.getName();
        this.setOptions(graphDescription.getOptions());
        this.namespaces = graphDescription.getNamespaces();
        this.namespaceList = this.namespaces == null ? Collections.emptyList() : new ArrayList<String>(new LinkedHashSet<String>(this.namespaces.values()));
    }

    protected void setOptions(Map<String, String> options) {
        for (Map.Entry<String, String> option : options.entrySet()) {
            String baseType;
            String key = option.getKey();
            String type = option.getValue();
            if (!key.equals(OPTION_DOCTYPE)) continue;
            SchemaManager sm = (SchemaManager)Framework.getLocalService(SchemaManager.class);
            DocumentType documentType = sm.getDocumentType(type);
            if (documentType == null) {
                throw new IllegalArgumentException("Unknown type: " + type + " for graph: " + this.name);
            }
            Type[] th = documentType.getTypeHierarchy();
            String string = baseType = th.length == 0 ? type : th[th.length - 1].getName();
            if (!REL_TYPE.equals(baseType)) {
                throw new IllegalArgumentException("Not a Relation type: " + type + " for graph: " + this.name);
            }
            this.docType = type;
        }
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public Long size() {
        SizeFinder sizeFinder = this.session == null ? new SizeFinder() : new SizeFinder(this.session);
        try {
            sizeFinder.runUnrestricted();
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        return sizeFinder.size;
    }

    public void clear() {
        this.remove(Collections.singletonList(ALL));
    }

    public void add(Statement statement) {
        this.add(Collections.singletonList(statement));
    }

    public void add(List<Statement> statements) {
        StatementAdder statementAdder = this.session == null ? new StatementAdder(statements) : new StatementAdder(statements, this.session);
        try {
            statementAdder.runUnrestricted();
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove(Statement statement) {
        this.remove(Collections.singletonList(statement));
    }

    public void remove(List<Statement> statements) {
        StatementRemover statementRemover = this.session == null ? new StatementRemover(statements) : new StatementRemover(statements, this.session);
        try {
            statementRemover.runUnrestricted();
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Statement> getStatements() {
        return this.getStatements(ALL);
    }

    public List<Statement> getStatements(Node subject, Node predicate, Node object) {
        return this.getStatements((Statement)new StatementImpl(subject, predicate, object));
    }

    public List<Statement> getStatements(Statement statement) {
        StatementFinder statementFinder = this.session == null ? new StatementFinder(statement) : new StatementFinder(statement, this.session);
        try {
            statementFinder.runUnrestricted();
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        return statementFinder.statements;
    }

    public List<Node> getSubjects(Node predicate, Node object) {
        List<Statement> statements = this.getStatements((Statement)new StatementImpl(null, predicate, object));
        ArrayList<Node> nodes = new ArrayList<Node>(statements.size());
        for (Statement statement : statements) {
            nodes.add((Node)statement.getSubject());
        }
        return nodes;
    }

    public List<Node> getPredicates(Node subject, Node object) {
        List<Statement> statements = this.getStatements((Statement)new StatementImpl(subject, null, object));
        ArrayList<Node> nodes = new ArrayList<Node>(statements.size());
        for (Statement statement : statements) {
            nodes.add((Node)statement.getPredicate());
        }
        return nodes;
    }

    public List<Node> getObjects(Node subject, Node predicate) {
        List<Statement> statements = this.getStatements((Statement)new StatementImpl(subject, predicate, null));
        ArrayList<Node> nodes = new ArrayList<Node>(statements.size());
        for (Statement statement : statements) {
            nodes.add(statement.getObject());
        }
        return nodes;
    }

    public boolean hasStatement(Statement statement) {
        if (statement == null) {
            return false;
        }
        return !this.getStatements(statement).isEmpty();
    }

    public boolean hasResource(Resource resource) {
        if (resource == null) {
            return false;
        }
        ResourceFinder resourceFinder = this.session == null ? new ResourceFinder(resource) : new ResourceFinder(resource, this.session);
        try {
            resourceFinder.runUnrestricted();
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        return resourceFinder.found;
    }

    public QueryResult query(String queryString, String language, String baseURI) {
        throw new UnsupportedOperationException();
    }

    public boolean read(String path, String lang, String base) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
            boolean bl = this.read(in, lang, base);
            return bl;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    public boolean write(String path, String lang, String base) {
        OutputStream out = null;
        try {
            out = new FileOutputStream(new File(path));
            boolean bl = this.write(out, lang, base);
            return bl;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    public boolean read(InputStream in, String lang, String base) {
        throw new UnsupportedOperationException();
    }

    public boolean write(OutputStream out, String lang, String base) {
        throw new UnsupportedOperationException();
    }

    protected static String getDefaultRepositoryName() {
        try {
            return ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepositoryName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String whereBuilder(String query, Statement statement) throws ClientException {
        Node o;
        Subject s;
        ArrayList<String> params = new ArrayList<String>(3);
        ArrayList<String> clauses = new ArrayList<String>(3);
        Resource p = statement.getPredicate();
        if (p != null) {
            NodeAsString pn = CoreGraph.getNodeAsString((Node)p);
            if (pn.uri == null) {
                return null;
            }
            clauses.add("relation:predicate = ?");
            params.add(pn.uri);
        }
        if ((s = statement.getSubject()) != null) {
            NodeAsString sn = CoreGraph.getNodeAsString((Node)s);
            if (sn.id != null) {
                clauses.add("relation:source = ?");
                params.add(sn.id);
            } else {
                clauses.add("relation:sourceUri = ?");
                params.add(sn.uri);
            }
        }
        if ((o = statement.getObject()) != null) {
            NodeAsString on = CoreGraph.getNodeAsString(o);
            if (on.id != null) {
                clauses.add("relation:target = ?");
                params.add(on.id);
            } else if (on.uri != null) {
                clauses.add("relation:targetUri = ?");
                params.add(on.uri);
            } else {
                clauses.add("relation:targetString = ?");
                params.add(on.string);
            }
        }
        if (!clauses.isEmpty()) {
            query = query + " WHERE " + StringUtils.join(clauses, (String)" AND ");
            query = NXQLQueryBuilder.getQuery((String)query, (Object[])params.toArray(), (boolean)true, (boolean)true, (SortInfo[])new SortInfo[0]);
        }
        return query;
    }

    protected static NodeAsString getNodeAsString(Node node) {
        NodeAsString nas = new NodeAsString();
        if (node.isBlank()) {
            String id = ((Blank)node).getId();
            nas.uri = BLANK_NS + (id == null ? "" : id);
        } else if (node.isLiteral()) {
            nas.string = ((Literal)node).getValue();
        } else if (node.isQNameResource()) {
            String ns = ((QNameResource)node).getNamespace();
            if (DOCUMENT_NAMESPACE.equals(ns) || DOCUMENT_NAMESPACE2.equals(ns) || COMMENT_NAMESPACE.equals(ns)) {
                nas.id = CoreGraph.localNameToId(((QNameResource)node).getLocalName());
            } else {
                nas.uri = ((Resource)node).getUri();
            }
        } else {
            String uri = ((Resource)node).getUri();
            for (String ns : DOC_NAMESPACES) {
                if (!uri.startsWith(ns)) continue;
                nas.id = CoreGraph.localNameToId(uri.substring(ns.length()));
                break;
            }
            if (nas.id == null) {
                nas.uri = uri;
            }
        }
        return nas;
    }

    protected static String localNameToId(String localName) {
        String[] split = localName.split("/");
        if (split.length == 1) {
            return localName;
        }
        return split[1];
    }

    protected static String getAuthor(Statement statement) {
        return CoreGraph.getStringProperty(statement, RelationConstants.AUTHOR);
    }

    protected static void setAuthor(Statement statement, String author) {
        CoreGraph.setStringProperty(statement, RelationConstants.AUTHOR, author);
    }

    protected static Date getCreationDate(Statement statement) {
        return CoreGraph.getDateProperty(statement, RelationConstants.CREATION_DATE);
    }

    protected static void setCreationDate(Statement statement, Calendar created) {
        CoreGraph.setDateProperty(statement, RelationConstants.CREATION_DATE, created);
    }

    protected static Date getModificationDate(Statement statement) {
        return CoreGraph.getDateProperty(statement, RelationConstants.MODIFICATION_DATE);
    }

    protected static void setModificationDate(Statement statement, Calendar modified) {
        CoreGraph.setDateProperty(statement, RelationConstants.MODIFICATION_DATE, modified);
    }

    protected static String getComment(Statement statement) {
        return CoreGraph.getStringProperty(statement, RelationConstants.COMMENT);
    }

    protected static void setComment(Statement statement, String comment) {
        CoreGraph.setStringProperty(statement, RelationConstants.COMMENT, comment);
    }

    protected static String getStringProperty(Statement statement, Resource prop) {
        Node node = statement.getProperty(prop);
        if (node == null || !node.isLiteral()) {
            return null;
        }
        return ((Literal)node).getValue();
    }

    protected static void setStringProperty(Statement statement, Resource prop, String string) {
        if (string == null) {
            return;
        }
        statement.setProperty(prop, (Node)NodeFactory.createLiteral((String)string));
    }

    protected static Date getDateProperty(Statement statement, Resource prop) {
        Node node = statement.getProperty(prop);
        if (node == null || !node.isLiteral()) {
            return null;
        }
        return RelationDate.getDate((Literal)((Literal)node));
    }

    protected static void setDateProperty(Statement statement, Resource prop, Calendar date) {
        if (date == null) {
            return;
        }
        statement.setProperty(prop, (Node)RelationDate.getLiteralDate((Calendar)date));
    }

    protected class ResourceFinder
    extends UnrestrictedSessionRunner {
        protected boolean found;
        protected Resource resource;

        protected ResourceFinder(Resource resource) {
            super(CoreGraph.getDefaultRepositoryName());
            this.resource = resource;
        }

        protected ResourceFinder(Resource resource, CoreSession session) {
            super(session);
            this.resource = resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws ClientException {
            String query = "SELECT ecm:uuid FROM " + CoreGraph.this.docType;
            query = this.whereAnyBuilder(query, this.resource);
            try (IterableQueryResult it = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
                this.found = it.iterator().hasNext();
            }
        }

        protected String whereAnyBuilder(String query, Resource resource) throws ClientException {
            ArrayList<String> params = new ArrayList<String>(3);
            ArrayList<String> clauses = new ArrayList<String>(3);
            NodeAsString nas = CoreGraph.getNodeAsString((Node)resource);
            if (nas.id != null) {
                clauses.add("relation:source = ?");
                params.add(nas.id);
                clauses.add("relation:targetUri = ?");
                params.add(DOCUMENT_NAMESPACE + this.session.getRepositoryName() + '/' + nas.id);
            } else if (nas.uri != null) {
                for (String ns : DOC_NAMESPACES) {
                    if (!nas.uri.startsWith(ns)) continue;
                    String id = CoreGraph.localNameToId(nas.uri.substring(ns.length()));
                    clauses.add("relation:source = ?");
                    params.add(id);
                    break;
                }
                clauses.add("relation:sourceUri = ?");
                params.add(nas.uri);
                clauses.add("relation:targetUri = ?");
                params.add(nas.uri);
                clauses.add("relation:predicate = ?");
                params.add(nas.uri);
            }
            query = query + " WHERE " + StringUtils.join(clauses, (String)" OR ");
            query = NXQLQueryBuilder.getQuery((String)query, (Object[])params.toArray(), (boolean)true, (boolean)true, (SortInfo[])new SortInfo[0]);
            return query;
        }
    }

    protected class StatementFinder
    extends UnrestrictedSessionRunner {
        protected List<Statement> statements;
        protected Statement statement;

        protected StatementFinder(Statement statement) {
            super(CoreGraph.getDefaultRepositoryName());
            this.statement = statement;
        }

        protected StatementFinder(Statement statement, CoreSession session) {
            super(session);
            this.statement = statement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws ClientException {
            String query = "SELECT relation:predicate, relation:source, relation:sourceUri, relation:target, relation:targetUri, relation:targetString, dc:created, dc:creator, dc:modified, dc:description FROM " + CoreGraph.this.docType;
            if ((query = CoreGraph.this.whereBuilder(query, this.statement)) == null) {
                this.statements = EMPTY_STATEMENTS;
                return;
            }
            this.statements = new ArrayList<Statement>();
            try (IterableQueryResult it = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
                for (Map map : it) {
                    String pred = (String)map.get(CoreGraph.REL_PREDICATE);
                    String source = (String)map.get(CoreGraph.REL_SOURCE_ID);
                    String sourceUri = (String)map.get(CoreGraph.REL_SOURCE_URI);
                    String target = (String)map.get(CoreGraph.REL_TARGET_ID);
                    String targetUri = (String)map.get(CoreGraph.REL_TARGET_URI);
                    String targetString = (String)map.get(CoreGraph.REL_TARGET_STRING);
                    Calendar created = (Calendar)map.get(CoreGraph.DC_CREATED);
                    String creator = (String)map.get(CoreGraph.DC_CREATOR);
                    Calendar modified = (Calendar)map.get(CoreGraph.DC_MODIFIED);
                    String comment = (String)map.get(CoreGraph.DC_DESCRIPTION);
                    Resource predicate = NodeFactory.createResource((String)pred);
                    Object subject = source != null ? this.createId(source) : this.createUri(sourceUri);
                    Object object = target != null ? this.createId(target) : (targetUri != null ? this.createUri(targetUri) : NodeFactory.createLiteral((String)targetString));
                    StatementImpl statement = new StatementImpl((Node)subject, (Node)predicate, (Node)object);
                    CoreGraph.setCreationDate((Statement)statement, created);
                    CoreGraph.setAuthor((Statement)statement, creator);
                    CoreGraph.setModificationDate((Statement)statement, modified);
                    CoreGraph.setComment((Statement)statement, comment);
                    this.statements.add((Statement)statement);
                }
            }
        }

        protected QNameResource createId(String id) {
            return NodeFactory.createQNameResource((String)DOCUMENT_NAMESPACE, (String)(this.session.getRepositoryName() + '/' + id));
        }

        protected Node createUri(String uri) {
            if (uri.startsWith(BLANK_NS)) {
                String id = uri.substring(BLANK_NS.length());
                return NodeFactory.createBlank((String)(id.isEmpty() ? null : id));
            }
            for (String ns : CoreGraph.this.namespaceList) {
                if (!uri.startsWith(ns)) continue;
                String localName = uri.substring(ns.length());
                return NodeFactory.createQNameResource((String)ns, (String)localName);
            }
            return NodeFactory.createResource((String)uri);
        }
    }

    protected class StatementRemover
    extends UnrestrictedSessionRunner {
        protected List<Statement> statements;
        protected Date now;

        protected StatementRemover(List<Statement> statements) {
            super(CoreGraph.getDefaultRepositoryName());
            this.statements = statements;
        }

        protected StatementRemover(List<Statement> statements, CoreSession session) {
            super(session);
            this.statements = statements;
        }

        public void run() throws ClientException {
            this.now = new Date();
            for (Statement statement : this.statements) {
                this.remove(statement);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void remove(Statement statement) throws ClientException {
            String query = "SELECT ecm:uuid FROM " + CoreGraph.this.docType;
            if ((query = CoreGraph.this.whereBuilder(query, statement)) == null) {
                return;
            }
            try (IterableQueryResult it = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
                for (Map map : it) {
                    String id = (String)map.get("ecm:uuid");
                    this.session.removeDocument((DocumentRef)new IdRef(id));
                }
            }
        }
    }

    protected class StatementAdder
    extends UnrestrictedSessionRunner {
        protected List<Statement> statements;
        protected Date now;

        protected StatementAdder(List<Statement> statements) {
            super(CoreGraph.getDefaultRepositoryName(), "system");
            this.statements = statements;
        }

        protected StatementAdder(List<Statement> statements, CoreSession session) {
            super(session);
            this.statements = statements;
        }

        public void run() throws ClientException {
            this.now = new Date();
            for (Statement statement : this.statements) {
                this.add(statement);
            }
        }

        protected void add(Statement statement) throws ClientException {
            Date modified;
            Date created;
            Resource pred = statement.getPredicate();
            NodeAsString predicate = CoreGraph.getNodeAsString((Node)pred);
            if (predicate.uri == null) {
                throw new IllegalArgumentException("Invalid predicate in statement: " + statement);
            }
            Subject subject = statement.getSubject();
            if (subject.isLiteral()) {
                throw new IllegalArgumentException("Invalid literal subject in statement: " + statement);
            }
            NodeAsString source = CoreGraph.getNodeAsString((Node)subject);
            Node object = statement.getObject();
            NodeAsString target = CoreGraph.getNodeAsString(object);
            String author = CoreGraph.getAuthor(statement);
            if (author == null) {
                author = this.getOriginatingUsername();
            }
            if ((created = CoreGraph.getCreationDate(statement)) == null) {
                created = this.now;
            }
            if ((modified = CoreGraph.getModificationDate(statement)) == null) {
                modified = this.now;
            }
            String comment = CoreGraph.getComment(statement);
            String title = (source.id != null ? source.id : source.uri) + " " + predicate.uri.substring(predicate.uri.lastIndexOf(47) + 1) + " " + (target.id != null ? target.id : (target.uri != null ? target.uri : target.string));
            int MAX_TITLE = 200;
            if (title.length() > MAX_TITLE) {
                title = title.substring(0, MAX_TITLE);
            }
            DocumentModel rel = this.session.createDocumentModel(null, "relation", CoreGraph.this.docType);
            rel.setPropertyValue(CoreGraph.REL_PREDICATE, (Serializable)((Object)predicate.uri));
            if (source.id != null) {
                rel.setPropertyValue(CoreGraph.REL_SOURCE_ID, (Serializable)((Object)source.id));
            } else {
                rel.setPropertyValue(CoreGraph.REL_SOURCE_URI, (Serializable)((Object)source.uri));
            }
            if (target.id != null) {
                rel.setPropertyValue(CoreGraph.REL_TARGET_ID, (Serializable)((Object)target.id));
            } else if (target.uri != null) {
                rel.setPropertyValue(CoreGraph.REL_TARGET_URI, (Serializable)((Object)target.uri));
            } else {
                rel.setPropertyValue(CoreGraph.REL_TARGET_STRING, (Serializable)((Object)target.string));
            }
            if (author != null) {
                rel.setPropertyValue(CoreGraph.DC_CREATOR, (Serializable)((Object)author));
            }
            if (created != null) {
                rel.setPropertyValue(CoreGraph.DC_CREATED, (Serializable)created);
            }
            if (modified != null) {
                rel.setPropertyValue(CoreGraph.DC_MODIFIED, (Serializable)modified);
            }
            rel.setPropertyValue(CoreGraph.DC_TITLE, (Serializable)((Object)title));
            if (comment != null) {
                rel.setPropertyValue(CoreGraph.DC_DESCRIPTION, (Serializable)((Object)comment));
            }
            this.session.createDocument(rel);
        }
    }

    protected class SizeFinder
    extends UnrestrictedSessionRunner {
        protected long size;

        protected SizeFinder() {
            super(CoreGraph.getDefaultRepositoryName());
        }

        protected SizeFinder(CoreSession session) {
            super(session);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws ClientException {
            try (IterableQueryResult it = this.session.queryAndFetch("SELECT ecm:uuid FROM " + CoreGraph.this.docType, "NXQL", new Object[0]);){
                this.size = it.size();
            }
        }
    }

    protected static class NodeAsString {
        public String id;
        public String uri;
        public String string;

        protected NodeAsString() {
        }
    }
}

