/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.api.ws;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Endpoint;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.ws.WSEndpointManagerImpl;

@XObject(value="endpoint")
public class WSEndpointDescriptor {
    @XNode(value="@name")
    public String name;
    @XNode(value="@address")
    public String address;
    @XNode(value="@implementor")
    public Class<?> clazz;
    @XNodeList(value="handlers/handler", type=String[].class, componentType=Class.class)
    public Class<? extends Handler>[] handlers;
    @XNode(value="@namespace")
    public String namespace;
    @XNode(value="@wsdl")
    public String wsdl;
    @XNode(value="@port")
    public String port;
    @XNode(value="@service")
    public String service;
    @XNode(value="enable-mtom")
    public boolean mtom;

    public Object getImplementorInstance() throws IllegalAccessException, InstantiationException {
        return this.clazz != null ? this.clazz.newInstance() : null;
    }

    public Endpoint toEndpoint() throws IOException, IllegalAccessException, InstantiationException {
        Endpoint ep = Endpoint.create((Object)this.getImplementorInstance());
        ArrayList<StreamSource> metadata = new ArrayList<StreamSource>();
        HashMap<String, QName> properties = new HashMap<String, QName>();
        if (!StringUtils.isBlank((String)this.port)) {
            properties.put("javax.xml.ws.wsdl.port", new QName(this.namespace, this.port));
        }
        if (!StringUtils.isBlank((String)this.port)) {
            properties.put("javax.xml.ws.wsdl.service", new QName(this.namespace, this.service));
        }
        if (!StringUtils.isBlank((String)this.wsdl)) {
            URL wsdlURL = WSEndpointManagerImpl.class.getClassLoader().getResource(this.wsdl);
            if (wsdlURL == null) {
                throw new FileNotFoundException("WSDL: " + this.wsdl);
            }
            StreamSource src = new StreamSource(wsdlURL.openStream());
            src.setSystemId(wsdlURL.toExternalForm());
            metadata.add(src);
        }
        ep.setMetadata(metadata);
        ep.setProperties(properties);
        return ep;
    }

    public void configurePostPublishing(Endpoint ep) throws IllegalAccessException, InstantiationException {
        if (this.handlers != null) {
            List handlerChain = ep.getBinding().getHandlerChain();
            for (Class<? extends Handler> handler : this.handlers) {
                handlerChain.add(handler.newInstance());
            }
            ep.getBinding().setHandlerChain(handlerChain);
        }
        if (this.mtom && ep.getBinding() instanceof SOAPBinding) {
            SOAPBinding binding = (SOAPBinding)ep.getBinding();
            binding.setMTOMEnabled(this.mtom);
        }
    }
}

