/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.ArrayBooleanList;
import org.apache.commons.collections.primitives.BooleanIterator;
import org.apache.commons.collections.primitives.BooleanList;
import org.apache.commons.collections.primitives.BooleanListIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableBooleanIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableBooleanList;
import org.apache.commons.collections.primitives.decorators.UnmodifiableBooleanListIterator;

public final class BooleanCollections {
    public static final BooleanList EMPTY_BOOLEAN_LIST = BooleanCollections.unmodifiableBooleanList(new ArrayBooleanList(0));
    public static final BooleanIterator EMPTY_BOOLEAN_ITERATOR = BooleanCollections.unmodifiableBooleanIterator(EMPTY_BOOLEAN_LIST.iterator());
    public static final BooleanListIterator EMPTY_BOOLEAN_LIST_ITERATOR = BooleanCollections.unmodifiableBooleanListIterator(EMPTY_BOOLEAN_LIST.listIterator());

    private BooleanCollections() {
    }

    @Nonnull
    public static BooleanList singletonBooleanList(boolean bl) {
        ArrayBooleanList arrayBooleanList = new ArrayBooleanList(1);
        arrayBooleanList.add(bl);
        return UnmodifiableBooleanList.wrap(arrayBooleanList);
    }

    @Nonnull
    public static BooleanIterator singletonBooleanIterator(boolean bl) {
        return BooleanCollections.singletonBooleanList(bl).iterator();
    }

    @Nonnull
    public static BooleanListIterator singletonBooleanListIterator(boolean bl) {
        return BooleanCollections.singletonBooleanList(bl).listIterator();
    }

    @Nonnull
    public static BooleanList unmodifiableBooleanList(@Nonnull BooleanList booleanList) throws NullPointerException {
        if (null == booleanList) {
            throw new NullPointerException();
        }
        return UnmodifiableBooleanList.wrap(booleanList);
    }

    @Nonnull
    public static BooleanIterator unmodifiableBooleanIterator(@Nonnull BooleanIterator booleanIterator) {
        if (null == booleanIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableBooleanIterator.wrap(booleanIterator);
    }

    @Nonnull
    public static BooleanListIterator unmodifiableBooleanListIterator(@Nonnull BooleanListIterator booleanListIterator) {
        if (null == booleanListIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableBooleanListIterator.wrap(booleanListIterator);
    }

    @Nonnull
    public static BooleanList getEmptyBooleanList() {
        return EMPTY_BOOLEAN_LIST;
    }

    @Nonnull
    public static BooleanIterator getEmptyBooleanIterator() {
        return EMPTY_BOOLEAN_ITERATOR;
    }

    @Nonnull
    public static BooleanListIterator getEmptyBooleanListIterator() {
        return EMPTY_BOOLEAN_LIST_ITERATOR;
    }
}

