/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.hash.HashCodeGenerator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.AbstractFloatCollection;
import org.apache.commons.collections.primitives.FloatCollection;
import org.apache.commons.collections.primitives.FloatIterator;
import org.apache.commons.collections.primitives.FloatList;
import org.apache.commons.collections.primitives.FloatListIterator;

public abstract class RandomAccessFloatList
extends AbstractFloatCollection
implements FloatList {
    private int _modCount = 0;

    protected RandomAccessFloatList() {
    }

    @Override
    public abstract float get(int var1);

    @Override
    public abstract int size();

    @Override
    public float removeElementAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float set(int n, float f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, float f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(float f) {
        this.add(this.size(), f);
        return true;
    }

    @Override
    public boolean addAll(int n, @Nonnull FloatCollection floatCollection) {
        int n2 = n;
        boolean bl = false;
        FloatIterator floatIterator = floatCollection.iterator();
        while (floatIterator.hasNext()) {
            this.add(n2++, floatIterator.next());
            bl = true;
        }
        return bl;
    }

    @Override
    public int indexOf(float f) {
        int n = 0;
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            if (floatIterator.next() == f) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(float f) {
        FloatListIterator floatListIterator = this.listIterator(this.size());
        while (floatListIterator.hasPrevious()) {
            if (floatListIterator.previous() != f) continue;
            return floatListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public FloatIterator iterator() {
        return this.listIterator();
    }

    @Override
    public FloatListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public FloatListIterator listIterator(int n) {
        return new RandomAccessFloatListIterator(this, n);
    }

    @Override
    public FloatList subList(int n, int n2) {
        return new RandomAccessFloatSubList(this, n, n2);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FloatList)) {
            return false;
        }
        FloatList floatList = (FloatList)object;
        if (this.size() != floatList.size()) {
            return false;
        }
        FloatIterator floatIterator = floatList.iterator();
        FloatIterator floatIterator2 = this.iterator();
        while (floatIterator2.hasNext()) {
            if (floatIterator2.next() == floatIterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(this);
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            hashCodeGenerator.append(floatIterator.next());
        }
        return hashCodeGenerator.getHashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            stringBuilder.append(floatIterator.next());
            if (!floatIterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    protected static class RandomAccessFloatSubList
    extends RandomAccessFloatList {
        private int _offset = 0;
        private int _limit = 0;
        private RandomAccessFloatList _list = null;
        private ComodChecker _comod = null;

        RandomAccessFloatSubList(RandomAccessFloatList randomAccessFloatList, int n, int n2) {
            if (n < 0 || n2 > randomAccessFloatList.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            this._list = randomAccessFloatList;
            this._offset = n;
            this._limit = n2 - n;
            this._comod = new ComodChecker(randomAccessFloatList);
            this._comod.resyncModCount();
        }

        @Override
        public float get(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            return this._list.get(this.toUnderlyingIndex(n));
        }

        @Override
        public float removeElementAt(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            float f = this._list.removeElementAt(this.toUnderlyingIndex(n));
            --this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
            return f;
        }

        @Override
        public float set(int n, float f) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            float f2 = this._list.set(this.toUnderlyingIndex(n), f);
            this.incrModCount();
            this._comod.resyncModCount();
            return f2;
        }

        @Override
        public void add(int n, float f) {
            this.checkRangeIncludingEndpoint(n);
            this._comod.assertNotComodified();
            this._list.add(this.toUnderlyingIndex(n), f);
            ++this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
        }

        @Override
        public int size() {
            this._comod.assertNotComodified();
            return this._limit;
        }

        private void checkRange(int n) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + ")");
            }
        }

        private void checkRangeIncludingEndpoint(int n) {
            if (n < 0 || n > this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + "]");
            }
        }

        private int toUnderlyingIndex(int n) {
            return n + this._offset;
        }
    }

    protected static class RandomAccessFloatListIterator
    extends ComodChecker
    implements FloatListIterator {
        private int _nextIndex = 0;
        private int _lastReturnedIndex = -1;

        RandomAccessFloatListIterator(RandomAccessFloatList randomAccessFloatList, int n) {
            super(randomAccessFloatList);
            if (n < 0 || n > this.getList().size()) {
                throw new IndexOutOfBoundsException("Index " + n + " not in [0," + this.getList().size() + ")");
            }
            this._nextIndex = n;
            this.resyncModCount();
        }

        @Override
        public boolean hasNext() {
            this.assertNotComodified();
            return this._nextIndex < this.getList().size();
        }

        @Override
        public boolean hasPrevious() {
            this.assertNotComodified();
            return this._nextIndex > 0;
        }

        @Override
        public int nextIndex() {
            this.assertNotComodified();
            return this._nextIndex;
        }

        @Override
        public int previousIndex() {
            this.assertNotComodified();
            return this._nextIndex - 1;
        }

        @Override
        public float next() {
            this.assertNotComodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            float f = this.getList().get(this._nextIndex);
            this._lastReturnedIndex = this._nextIndex++;
            return f;
        }

        @Override
        public float previous() {
            this.assertNotComodified();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            float f = this.getList().get(this._nextIndex - 1);
            this._lastReturnedIndex = this._nextIndex - 1;
            --this._nextIndex;
            return f;
        }

        @Override
        public void add(float f) {
            this.assertNotComodified();
            this.getList().add(this._nextIndex, f);
            ++this._nextIndex;
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void remove() {
            this.assertNotComodified();
            if (this._lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (this._lastReturnedIndex == this._nextIndex) {
                this.getList().removeElementAt(this._lastReturnedIndex);
            } else {
                this.getList().removeElementAt(this._lastReturnedIndex);
                --this._nextIndex;
            }
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void set(float f) {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().set(this._lastReturnedIndex, f);
            this.resyncModCount();
        }
    }

    private static class ComodChecker {
        private RandomAccessFloatList _source = null;
        private int _expectedModCount = -1;

        ComodChecker(RandomAccessFloatList randomAccessFloatList) {
            this._source = randomAccessFloatList;
            this.resyncModCount();
        }

        protected RandomAccessFloatList getList() {
            return this._source;
        }

        protected void assertNotComodified() throws ConcurrentModificationException {
            if (this._expectedModCount != this.getList().getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void resyncModCount() {
            this._expectedModCount = this.getList().getModCount();
        }
    }
}

