/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webdav.resource;

import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.java.dev.webdav.jaxrs.methods.PROPFIND;
import net.java.dev.webdav.jaxrs.xml.elements.HRef;
import net.java.dev.webdav.jaxrs.xml.elements.LockEntry;
import net.java.dev.webdav.jaxrs.xml.elements.LockScope;
import net.java.dev.webdav.jaxrs.xml.elements.LockType;
import net.java.dev.webdav.jaxrs.xml.elements.MultiStatus;
import net.java.dev.webdav.jaxrs.xml.elements.Prop;
import net.java.dev.webdav.jaxrs.xml.elements.PropFind;
import net.java.dev.webdav.jaxrs.xml.elements.PropStat;
import net.java.dev.webdav.jaxrs.xml.elements.Status;
import net.java.dev.webdav.jaxrs.xml.properties.SupportedLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.webdav.backend.Backend;
import org.nuxeo.ecm.webdav.jaxrs.Util;
import org.nuxeo.ecm.webdav.resource.ExistingResource;
import org.nuxeo.ecm.webdav.resource.PropStatBuilderExt;
import org.nuxeo.runtime.services.streaming.InputStreamSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class FileResource
extends ExistingResource {
    private static final Log log = LogFactory.getLog(FileResource.class);

    public FileResource(String path, DocumentModel doc, HttpServletRequest request, Backend backend) throws Exception {
        super(path, doc, request, backend);
    }

    @GET
    public Object get() throws Exception {
        String mimeType;
        Blob content = null;
        BlobHolder bh = (BlobHolder)this.doc.getAdapter(BlobHolder.class);
        if (bh != null) {
            try {
                content = bh.getBlob();
            }
            catch (ClientException e) {
                log.error((Object)"Unable to get blob", (Throwable)e);
            }
        }
        if (content == null) {
            return Response.ok((Object)"").build();
        }
        try {
            mimeType = content.getMimeType();
        }
        catch (Exception e) {
            mimeType = "application/octet-stream";
        }
        if ("???".equals(mimeType)) {
            mimeType = "application/octet-stream";
        }
        return Response.ok((Object)content).type(mimeType).build();
    }

    @PUT
    public Response put() throws Exception {
        if (this.backend.isLocked(this.doc.getRef()) && !this.backend.canUnlock(this.doc.getRef())) {
            return Response.status((int)423).build();
        }
        try {
            StreamingBlob content = new StreamingBlob((StreamSource)new InputStreamSource((InputStream)this.request.getInputStream()));
            content.persist();
            String contentType = this.request.getContentType();
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            content.setMimeType(contentType);
            content.setFilename(this.name);
            this.backend.updateDocument(this.doc, this.name, (Blob)content);
            return Response.created((URI)new URI(URLEncoder.encode(this.path, "UTF8"))).build();
        }
        catch (Exception e) {
            log.error((Object)"Error during PUT method execution", (Throwable)e);
            return Response.status((int)409).build();
        }
    }

    @PROPFIND
    public Response propfind(@Context UriInfo uriInfo) throws Exception {
        net.java.dev.webdav.jaxrs.xml.elements.Response response;
        Unmarshaller u = Util.getUnmarshaller();
        Prop prop = null;
        if (this.request.getInputStream() != null && this.request.getContentLength() > 0) {
            PropFind propFind;
            try {
                propFind = (PropFind)u.unmarshal((InputStream)this.request.getInputStream());
            }
            catch (JAXBException e) {
                return Response.status((int)400).build();
            }
            prop = propFind.getProp();
        }
        PropStatBuilderExt props = this.getPropStatBuilderExt(this.doc, uriInfo);
        PropStat propStatFound = props.build();
        PropStat propStatNotFound = null;
        if (prop != null) {
            propStatNotFound = props.notFound(prop);
        }
        URI uri = uriInfo.getRequestUri();
        PropStat filePropStat = new PropStat(new Prop(new Object[]{new SupportedLock(new LockEntry[]{new LockEntry(LockScope.EXCLUSIVE, LockType.WRITE)})}), new Status(Response.Status.OK));
        if (this.doc.isLocked()) {
            PropStat lockDiscoveryPropStat = new PropStat(new Prop(new Object[]{this.getLockDiscovery(this.doc, uriInfo)}), new Status(Response.Status.OK));
            response = propStatNotFound != null ? new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(uri), null, null, null, filePropStat, new PropStat[]{propStatFound, propStatNotFound, lockDiscoveryPropStat}) : new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(uri), null, null, null, filePropStat, new PropStat[]{propStatFound, lockDiscoveryPropStat});
        } else {
            response = propStatNotFound != null ? new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(uri), null, null, null, filePropStat, new PropStat[]{propStatFound, propStatNotFound}) : new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(uri), null, null, null, filePropStat, new PropStat[]{propStatFound});
        }
        MultiStatus st = new MultiStatus(new net.java.dev.webdav.jaxrs.xml.elements.Response[]{response});
        return Response.status((int)207).entity((Object)st).build();
    }
}

