/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.status;

import java.util.Calendar;
import org.nuxeo.connect.connector.ConnectSecurityError;
import org.nuxeo.connect.data.SubscriptionStatus;

public class SubscriptionStatusWrapper
extends SubscriptionStatus {
    protected boolean isSecurityError = false;
    protected boolean canNotReachConnectServer = false;
    protected boolean versionMismatch = false;
    protected Calendar refreshDate;

    public SubscriptionStatusWrapper(String errorMessage) {
        this.errorMessage = errorMessage;
        this.refreshDate = Calendar.getInstance();
    }

    public SubscriptionStatusWrapper(ConnectSecurityError securityException) {
        this(securityException.getMessage());
        this.isSecurityError = true;
    }

    public SubscriptionStatusWrapper(SubscriptionStatus status) {
        this.contractStatus = status.getContractStatus();
        this.description = status.getDescription();
        this.instanceType = status.getInstanceType();
        this.message = status.getMessage();
        this.errorMessage = status.getErrorMessage();
        this.endDate = status.getEndDate();
        this.refreshDate = Calendar.getInstance();
    }

    public String getinstanceTypeLabel() {
        return "label.instancetype." + this.getInstanceType().toString();
    }

    public String getContractStatusLabel() {
        return "label.subscriptionStatus." + this.getContractStatus();
    }

    public boolean isError() {
        return this.errorMessage != null || this.isSecurityError || this.versionMismatch || this.canNotReachConnectServer;
    }

    public boolean isConnectServerUnreachable() {
        return this.canNotReachConnectServer;
    }

    public boolean isVersionMismatch() {
        return this.versionMismatch;
    }

    public boolean isSecurityError() {
        return this.isSecurityError;
    }

    public Calendar getRefreshDate() {
        return this.refreshDate;
    }
}

