/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.solver;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.cudf.Log;
import org.eclipse.equinox.p2.cudf.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.metadata.NotRequirement;
import org.eclipse.equinox.p2.cudf.query.CapabilityQuery;
import org.eclipse.equinox.p2.cudf.query.Collector;
import org.eclipse.equinox.p2.cudf.query.QueryableArray;
import org.eclipse.equinox.p2.cudf.solver.Explanation;
import org.eclipse.equinox.p2.cudf.solver.ExplanationJob;
import org.eclipse.equinox.p2.cudf.solver.Messages;
import org.eclipse.equinox.p2.cudf.solver.OptimizationFunction;
import org.eclipse.equinox.p2.cudf.solver.Pair;
import org.eclipse.equinox.p2.cudf.solver.SolverConfiguration;
import org.eclipse.equinox.p2.cudf.solver.Tracing;
import org.eclipse.equinox.p2.cudf.solver.TwoTierMap;
import org.eclipse.equinox.p2.cudf.solver.UserDefinedOptimizationFunction;
import org.eclipse.osgi.util.NLS;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.restarts.LubyRestarts;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.SolverFactory;
import org.sat4j.pb.core.PBSolverResolution;
import org.sat4j.pb.tools.DependencyHelper;
import org.sat4j.pb.tools.LexicoHelper;
import org.sat4j.pb.tools.WeightedObject;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.TimeoutException;

public class Projector {
    private static final boolean DEBUG = false;
    private static final boolean TIMING = false;
    private static final boolean DEBUG_ENCODING = false;
    private static final boolean PURGE = true;
    private QueryableArray picker;
    private Map<InstallableUnit, AbstractVariable> noopVariables;
    private List<AbstractVariable> abstractVariables;
    private TwoTierMap slice;
    LexicoHelper<Object, String> dependencyHelper;
    private Collection<InstallableUnit> solution;
    private Collection<Object> assumptions;
    private MultiStatus result;
    private InstallableUnit entryPoint;
    private SolverConfiguration configuration;
    private OptimizationFunction optFunction;
    private List<AbstractVariable> optionalityVariables;
    private List<Pair> optionalityPairs;
    private boolean isSatisfiable;

    public Projector(QueryableArray q) {
        this.picker = q;
        this.noopVariables = new HashMap<InstallableUnit, AbstractVariable>();
        this.slice = new TwoTierMap(q.getSize(), 1);
        this.abstractVariables = new ArrayList<AbstractVariable>();
        this.result = new MultiStatus("org.eclipse.equinox.p2.cudf", 0, Messages.Planner_Problems_resolving_plan, null);
        this.assumptions = new ArrayList<Object>();
        this.optionalityVariables = new ArrayList<AbstractVariable>();
        this.optionalityPairs = new ArrayList<Pair>();
    }

    private void purgeIU(InstallableUnit iu) {
        iu.setCapabilities(InstallableUnit.NO_PROVIDES);
        iu.setRequiredCapabilities(InstallableUnit.NO_REQUIRES);
    }

    public void encode(InstallableUnit entryPointIU, SolverConfiguration conf) {
        block12: {
            this.configuration = conf;
            this.entryPoint = entryPointIU;
            this.solution = null;
            try {
                IPBSolver solver;
                long start = 0L;
                if (conf.encoding) {
                    solver = SolverFactory.newOPBStringSolver();
                } else {
                    PBSolverResolution mysolver = SolverFactory.newCompetPBResLongWLMixedConstraintsObjectiveExpSimp();
                    mysolver.setSimplifier(mysolver.SIMPLE_SIMPLIFICATION);
                    mysolver.setRestartStrategy((RestartStrategy)new LubyRestarts(512));
                    solver = mysolver;
                }
                if ("default".equals(this.configuration.timeout)) {
                    solver.setTimeout(300);
                } else {
                    int number = Integer.valueOf(this.configuration.timeout.substring(0, this.configuration.timeout.length() - 1));
                    if (this.configuration.timeout.endsWith("s")) {
                        solver.setTimeout(number);
                    } else {
                        solver.setTimeoutOnConflicts(number);
                    }
                }
                solver.setVerbose(this.configuration.verbose);
                solver.setLogPrefix("# ");
                Log.printlnNoPrefix(solver.toString("# "));
                this.dependencyHelper = new LexicoHelper(solver, conf.explain);
                Iterator<InstallableUnit> iusToEncode = this.picker.iterator();
                ArrayList<InstallableUnit> iusToOrder = new ArrayList<InstallableUnit>(this.picker.getSize());
                while (iusToEncode.hasNext()) {
                    iusToOrder.add(iusToEncode.next());
                }
                Collections.sort(iusToOrder);
                for (InstallableUnit iuToEncode : iusToOrder) {
                    if (iuToEncode == entryPointIU) continue;
                    this.processIU(iuToEncode, false);
                }
                this.createConstraintsForSingleton();
                this.createMustHave(entryPointIU);
                this.optFunction = this.getOptimizationFactory(this.configuration.objective);
                this.setObjectiveFunction(this.optFunction.createOptimizationFunction(entryPointIU));
            }
            catch (IllegalStateException e) {
                this.result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.cudf", e.getMessage(), (Throwable)e));
                if (this.configuration.verbose) {
                    Log.println("*** PBM *** " + e.getMessage());
                }
            }
            catch (ContradictionException e) {
                this.result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.cudf", Messages.Planner_Unsatisfiable_problem));
                if (!this.configuration.verbose) break block12;
                Log.println("Unsat OPB problem ");
            }
        }
    }

    private OptimizationFunction getOptimizationFactory(String optFunctionName) {
        UserDefinedOptimizationFunction function = null;
        function = "p2".equals(optFunctionName) ? new UserDefinedOptimizationFunction(optFunctionName) : ("paranoid".equals(optFunctionName) ? new UserDefinedOptimizationFunction("-removed,-changed") : ("trendy".equals(optFunctionName) ? new UserDefinedOptimizationFunction("-removed,-notuptodate,-unsat_recommends,-new") : new UserDefinedOptimizationFunction(optFunctionName)));
        Log.println("Optimization function: " + ((OptimizationFunction)function).getName());
        function.slice = this.slice;
        function.noopVariables = this.noopVariables;
        function.picker = this.picker;
        function.dependencyHelper = this.dependencyHelper;
        function.optionalityVariables = this.optionalityVariables;
        function.optionalityPairs = this.optionalityPairs;
        return function;
    }

    private void setObjectiveFunction(List<WeightedObject<Object>> weightedObjects) {
        if (weightedObjects == null) {
            return;
        }
        this.dependencyHelper.setObjectiveFunction(weightedObjects.toArray(new WeightedObject[weightedObjects.size()]));
    }

    private void createMustHave(InstallableUnit iu) throws ContradictionException {
        this.processIU(iu, true);
        this.dependencyHelper.setTrue((Object)iu, (Object)new Explanation.IUToInstall(iu).toString());
    }

    private void createNegation(InstallableUnit iu, IRequiredCapability req) throws ContradictionException {
        this.dependencyHelper.setFalse((Object)iu, (Object)new Explanation.MissingIU(iu, req).toString());
    }

    private void expandNegatedRequirement(IRequiredCapability req, InstallableUnit iu, boolean isRootIu) throws ContradictionException {
        Explanation explanation;
        IRequiredCapability negatedReq = ((NotRequirement)req).getRequirement();
        List<AbstractVariable> matches = this.getApplicableMatches(negatedReq);
        matches.remove(iu);
        if (matches.isEmpty()) {
            return;
        }
        if (isRootIu) {
            InstallableUnit reqIu = (InstallableUnit)matches.iterator().next();
            explanation = new Explanation.IUToInstall(reqIu);
        } else {
            explanation = new Explanation.HardRequirement(iu, req);
        }
        this.createNegationImplication(iu, matches, explanation);
    }

    private void expandRequirement(IRequiredCapability req, InstallableUnit iu, boolean isRootIu) throws ContradictionException {
        if (req.isNegation()) {
            this.expandNegatedRequirement(req, iu, isRootIu);
            return;
        }
        List<AbstractVariable> matches = this.getApplicableMatches(req);
        if (!req.isOptional()) {
            if (matches.isEmpty()) {
                this.missingRequirement(iu, req);
            } else {
                if (req.getArity() == 1) {
                    this.createAtMostOne(matches.toArray(new InstallableUnit[matches.size()]));
                    return;
                }
                InstallableUnit reqIu = (InstallableUnit)matches.iterator().next();
                Explanation.IUToInstall explanation = new Explanation.IUToInstall(reqIu);
                this.createImplication(iu, matches, explanation);
            }
        } else {
            AbstractVariable abs = this.getAbstractVariable(iu.toString() + "->" + req.toString());
            matches.add(abs);
            this.createImplication(iu, matches, Explanation.OPTIONAL_REQUIREMENT);
            this.optionalityVariables.add(abs);
            this.optionalityPairs.add(new Pair(iu, abs));
        }
    }

    private void expandRequirements(IRequiredCapability[] reqs, InstallableUnit iu, boolean isRootIu) throws ContradictionException {
        if (reqs.length == 0) {
            return;
        }
        for (int i = 0; i < reqs.length; ++i) {
            this.expandRequirement(reqs[i], iu, isRootIu);
        }
    }

    public void processIU(InstallableUnit iu, boolean isRootIU) throws ContradictionException {
        this.slice.put(iu.getId(), iu.getVersion(), iu);
        this.expandRequirements(this.getRequiredCapabilities(iu), iu, isRootIU);
    }

    private IRequiredCapability[] getRequiredCapabilities(InstallableUnit iu) {
        return iu.getRequiredCapabilities();
    }

    private void missingRequirement(InstallableUnit iu, IRequiredCapability req) throws ContradictionException {
        this.result.add((IStatus)new Status(2, "org.eclipse.equinox.p2.cudf", NLS.bind(Messages.Planner_Unsatisfied_dependency, iu, req)));
        this.createNegation(iu, req);
    }

    private List<AbstractVariable> getApplicableMatches(IRequiredCapability req) {
        ArrayList<AbstractVariable> target = new ArrayList<AbstractVariable>();
        Collector matches = this.picker.query(new CapabilityQuery(req), new Collector(), null);
        Iterator<?> iterator = matches.iterator();
        while (iterator.hasNext()) {
            InstallableUnit match = (InstallableUnit)iterator.next();
            target.add(match);
        }
        return target;
    }

    private void createNegationImplication(InstallableUnit left, List<AbstractVariable> right, Explanation name) throws ContradictionException {
        Iterator<AbstractVariable> iterator = right.iterator();
        while (iterator.hasNext()) {
            this.dependencyHelper.implication(new Object[]{left}).impliesNot((Object)iterator.next()).named((Object)name.toString());
        }
    }

    private void createImplication(InstallableUnit left, List<AbstractVariable> right, Explanation name) throws ContradictionException {
        this.dependencyHelper.implication(new Object[]{left}).implies(right.toArray(new Object[right.size()])).named((Object)name.toString());
    }

    private void createConstraintsForSingleton() throws ContradictionException {
        Set s = this.slice.entrySet();
        for (Map.Entry entry : s) {
            InstallableUnit[] singletonArray;
            Map conflictingEntries = (Map)entry.getValue();
            if (conflictingEntries.size() < 2) continue;
            Collection conflictingVersions = conflictingEntries.values();
            ArrayList<InstallableUnit> singletons = new ArrayList<InstallableUnit>();
            ArrayList<InstallableUnit> nonSingletons = new ArrayList<InstallableUnit>();
            for (InstallableUnit iu : conflictingVersions) {
                if (iu.isSingleton()) {
                    singletons.add(iu);
                    continue;
                }
                nonSingletons.add(iu);
            }
            if (singletons.isEmpty()) continue;
            if (nonSingletons.isEmpty()) {
                singletonArray = singletons.toArray(new InstallableUnit[singletons.size()]);
                this.createAtMostOne(singletonArray);
                continue;
            }
            singletonArray = singletons.toArray(new InstallableUnit[singletons.size() + 1]);
            Iterator iterator2 = nonSingletons.iterator();
            while (iterator2.hasNext()) {
                singletonArray[singletonArray.length - 1] = (InstallableUnit)iterator2.next();
                this.createAtMostOne(singletonArray);
            }
        }
    }

    private void createAtMostOne(InstallableUnit[] ius) throws ContradictionException {
        this.dependencyHelper.atMost(1, (Object[])ius).named((Object)new Explanation.Singleton(ius).toString());
    }

    private AbstractVariable getAbstractVariable(String name) {
        AbstractVariable abstractVariable = new AbstractVariable(name);
        this.abstractVariables.add(abstractVariable);
        return abstractVariable;
    }

    private void purge() {
        Iterator<InstallableUnit> iusToEncode = this.picker.iterator();
        while (iusToEncode.hasNext()) {
            this.purgeIU(iusToEncode.next());
        }
        this.picker = null;
        this.noopVariables = null;
        this.abstractVariables = null;
        this.slice = null;
    }

    public IStatus invokeSolver() {
        block8: {
            this.purge();
            this.isSatisfiable = false;
            if (this.result.getSeverity() == 4) {
                return this.result;
            }
            long start = System.currentTimeMillis();
            try {
                Log.println("p cnf " + this.dependencyHelper.getSolver().nVars() + " " + this.dependencyHelper.getSolver().nConstraints());
                if (this.dependencyHelper.hasASolution(this.assumptions)) {
                    this.isSatisfiable = true;
                    this.backToIU();
                    long stop = System.currentTimeMillis();
                    if (this.configuration.verbose) {
                        this.dependencyHelper.getSolver().printStat(new PrintWriter(System.out, true), "# ");
                    }
                } else {
                    long stop = System.currentTimeMillis();
                    this.result.merge((IStatus)new Status(4, "org.eclipse.equinox.p2.cudf", Messages.Planner_Unsatisfiable_problem));
                }
            }
            catch (TimeoutException e) {
                this.result.merge((IStatus)new Status(4, "org.eclipse.equinox.p2.cudf", Messages.Planner_Timeout));
                if (this.configuration.verbose) {
                    Log.println("Timeout reached");
                }
            }
            catch (Exception e) {
                this.result.merge((IStatus)new Status(4, "org.eclipse.equinox.p2.cudf", Messages.Planner_Unexpected_problem, (Throwable)e));
                if (!this.configuration.verbose) break block8;
                Log.println("*** PBM *** " + e.getMessage());
            }
        }
        return this.result;
    }

    private void backToIU() {
        this.solution = null;
        if (!this.isSatisfiable) {
            return;
        }
        this.solution = new ArrayList<InstallableUnit>();
        IVec sat4jSolution = this.dependencyHelper.getSolution();
        if (sat4jSolution.isEmpty()) {
            return;
        }
        if (this.optFunction != null && this.configuration.verbose) {
            String solutionValue = this.optFunction.printSolutionValue();
            Log.println(solutionValue);
        }
        for (Object var : sat4jSolution) {
            InstallableUnit iu;
            if (!(var instanceof InstallableUnit) || (iu = (InstallableUnit)var) == this.entryPoint) continue;
            this.solution.add(iu);
        }
    }

    private void printSolution(Collection<InstallableUnit> state) {
        ArrayList<InstallableUnit> l = new ArrayList<InstallableUnit>(state);
        Collections.sort(l);
        Tracing.debug("Solution:");
        Tracing.debug("Numbers of IUs selected: " + l.size());
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            Tracing.debug(iterator.next().toString());
        }
    }

    public Collection<InstallableUnit> extractSolution() {
        return this.solution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<?> getExplanation() {
        ExplanationJob job = new ExplanationJob((DependencyHelper<?, ?>)this.dependencyHelper);
        job.schedule();
        NullProgressMonitor pm = new NullProgressMonitor();
        pm.beginTask(Messages.Planner_NoSolution, 1000);
        try {
            ExplanationJob explanationJob = job;
            synchronized (explanationJob) {
                while (job.getExplanationResult() == null && job.getState() != 0) {
                    if (pm.isCanceled()) {
                        job.cancel();
                        throw new OperationCanceledException();
                    }
                    pm.worked(1);
                    try {
                        ((Object)((Object)job)).wait(100L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        finally {
            pm.done();
        }
        return job.getExplanationResult();
    }

    public void stopSolver() {
        this.dependencyHelper.stopSolver();
    }

    public Collection<InstallableUnit> getBestSolutionFoundSoFar() {
        if (this.solution == null) {
            this.backToIU();
        }
        if (this.solution == null) {
            return null;
        }
        return this.extractSolution();
    }

    public Map<OptimizationFunction.Criteria, List<String>> getSolutionDetails() {
        if (this.getBestSolutionFoundSoFar() == null) {
            return null;
        }
        return this.optFunction.getSolutionDetails();
    }

    public static class AbstractVariable {
        private String str;

        protected AbstractVariable() {
        }

        protected AbstractVariable(String str) {
            this.str = str;
        }

        public String toString() {
            return "AbstractVariable: " + (this.str == null ? "" + this.hashCode() : this.str);
        }
    }
}

