/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.ConcurrentModificationException;
import org.nuxeo.ecm.core.api.model.Delta;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.Row;

public abstract class Fragment
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Row row;
    protected Serializable[] oldvalues;
    private State state;
    protected PersistenceContext context;

    protected Fragment(Row row, State state, PersistenceContext context) {
        this.row = row;
        this.state = state;
        this.context = context;
        switch (state) {
            case DETACHED: {
                if (context == null) break;
                throw new IllegalArgumentException();
            }
            case CREATED: 
            case DELETED: 
            case DELETED_DEPENDENT: {
                context.setFragmentModified(this);
                break;
            }
            case ABSENT: 
            case PRISTINE: {
                context.setFragmentPristine(this);
                break;
            }
            case MODIFIED: 
            case INVALIDATED_MODIFIED: 
            case INVALIDATED_DELETED: {
                throw new IllegalArgumentException(state.toString());
            }
        }
        this.clearDirty();
    }

    public State getState() {
        return this.state;
    }

    public void setId(Serializable id) {
        this.row.id = id;
    }

    public Serializable getId() {
        return this.row.id;
    }

    public void clearDirty() {
        Serializable[] values = this.row.values;
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            Serializable ob = values[i];
            if (!(ob instanceof Delta)) continue;
            values[i] = ((Delta)ob).getFullValue();
        }
        this.oldvalues = (Serializable[])values.clone();
    }

    protected abstract State refetch() throws StorageException;

    protected abstract State refetchDeleted() throws StorageException;

    protected void accessed() throws StorageException {
        switch (this.state) {
            case DETACHED: 
            case CREATED: 
            case DELETED: 
            case DELETED_DEPENDENT: 
            case ABSENT: 
            case PRISTINE: 
            case MODIFIED: {
                break;
            }
            case INVALIDATED_MODIFIED: {
                this.state = this.refetch();
                break;
            }
            case INVALIDATED_DELETED: {
                this.state = this.refetchDeleted();
            }
        }
    }

    protected void markModified() {
        switch (this.state) {
            case ABSENT: {
                this.context.setFragmentModified(this);
                this.state = State.CREATED;
                break;
            }
            case PRISTINE: 
            case INVALIDATED_MODIFIED: {
                this.context.setFragmentModified(this);
                this.state = State.MODIFIED;
                break;
            }
            case DETACHED: 
            case CREATED: 
            case DELETED: 
            case DELETED_DEPENDENT: 
            case MODIFIED: {
                break;
            }
            case INVALIDATED_DELETED: {
                throw new ConcurrentModificationException("Modifying a concurrently deleted value");
            }
        }
    }

    protected void setDeleted(boolean primary) {
        switch (this.state) {
            case DETACHED: {
                break;
            }
            case ABSENT: 
            case INVALIDATED_DELETED: {
                this.context = null;
                this.state = State.DETACHED;
                break;
            }
            case CREATED: {
                this.context = null;
                this.state = State.DETACHED;
                break;
            }
            case PRISTINE: 
            case INVALIDATED_MODIFIED: {
                this.state = primary ? State.DELETED : State.DELETED_DEPENDENT;
                break;
            }
            case MODIFIED: {
                this.state = primary ? State.DELETED : State.DELETED_DEPENDENT;
                break;
            }
            case DELETED: 
            case DELETED_DEPENDENT: {
                throw new RuntimeException(this.toString());
            }
        }
    }

    protected void setDetached() {
        this.state = State.DETACHED;
        this.context = null;
    }

    protected void setPristine() {
        switch (this.state) {
            case CREATED: 
            case MODIFIED: {
                this.state = State.PRISTINE;
                break;
            }
            case DETACHED: 
            case DELETED: 
            case DELETED_DEPENDENT: 
            case ABSENT: 
            case PRISTINE: 
            case INVALIDATED_MODIFIED: 
            case INVALIDATED_DELETED: {
                throw new RuntimeException(this.toString());
            }
        }
    }

    protected void setInvalidatedModified() {
        switch (this.state) {
            case CREATED: 
            case DELETED: 
            case DELETED_DEPENDENT: 
            case ABSENT: 
            case PRISTINE: 
            case MODIFIED: {
                this.state = State.INVALIDATED_MODIFIED;
                break;
            }
            case INVALIDATED_MODIFIED: 
            case INVALIDATED_DELETED: {
                break;
            }
            case DETACHED: {
                throw new RuntimeException(this.toString());
            }
        }
    }

    protected void setInvalidatedDeleted() {
        switch (this.state) {
            case CREATED: 
            case DELETED: 
            case DELETED_DEPENDENT: 
            case ABSENT: 
            case PRISTINE: 
            case MODIFIED: 
            case INVALIDATED_MODIFIED: {
                this.state = State.INVALIDATED_DELETED;
                break;
            }
            case INVALIDATED_DELETED: {
                break;
            }
            case DETACHED: {
                throw new RuntimeException(this.toString());
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(row=");
        buf.append(this.row);
        buf.append(", state=");
        buf.append((Object)this.getState());
        buf.append(')');
        return buf.toString();
    }

    public static enum State {
        DETACHED,
        ABSENT,
        PRISTINE,
        CREATED,
        MODIFIED,
        DELETED,
        DELETED_DEPENDENT,
        INVALIDATED_MODIFIED,
        INVALIDATED_DELETED;

    }
}

