/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.facelets.vendor;

import com.sun.faces.util.FacesLogger;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import org.nuxeo.theme.protocol.nxtheme.Connection;

public class Util {
    public static final String LAST_MODIFIED_ERROR = "Error Checking Last Modified for ";
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();

    public static long getLastModified(URL url) {
        long lastModified;
        InputStream is = null;
        try {
            URLConnection conn = url.openConnection();
            if (conn instanceof JarURLConnection) {
                JarURLConnection jarUrlConnection = (JarURLConnection)conn;
                URL jarFileUrl = jarUrlConnection.getJarFileURL();
                URLConnection jarFileConnection = jarFileUrl.openConnection();
                lastModified = jarFileConnection.getLastModified();
                jarFileConnection.getInputStream().close();
            } else if (conn instanceof Connection) {
                lastModified = conn.getLastModified();
            } else {
                is = conn.getInputStream();
                lastModified = conn.getLastModified();
            }
        }
        catch (Exception e) {
            throw new FacesException(LAST_MODIFIED_ERROR + url, (Throwable)e);
        }
        finally {
            block15: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block15;
                        LOGGER.log(Level.FINEST, "Closing stream", e);
                    }
                }
            }
        }
        return lastModified;
    }
}

