/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.exceptionhandling;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentSecurityException;

public class ExceptionHelper {
    private static final Log log = LogFactory.getLog(ExceptionHelper.class);
    private static final String CLIENT_ABORT_EXCEPTION = "ClientAbortException";
    private static final String EOF_EXCEPTION = "EofException";
    public static List<String> possibleSecurityErrorMessages = Arrays.asList("java.lang.SecurityException", DocumentSecurityException.class.getName(), SecurityException.class.getName());

    private ExceptionHelper() {
    }

    public static Throwable unwrapException(Throwable t) {
        Throwable cause = null;
        if (t instanceof ServletException) {
            cause = ((ServletException)t).getRootCause();
        } else if (t instanceof Exception) {
            cause = t.getCause();
        }
        if (cause == null) {
            return t;
        }
        return ExceptionHelper.unwrapException(cause);
    }

    public static boolean isSecurityError(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof DocumentSecurityException || t.getCause() instanceof DocumentSecurityException || t.getCause() instanceof SecurityException) {
            return true;
        }
        if (t.getMessage() != null) {
            String message = t.getMessage();
            for (String errorMessage : possibleSecurityErrorMessages) {
                if (!message.contains(errorMessage)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isClientAbortError(Throwable t) {
        for (int loops = 20; t != null && loops > 0; --loops, t = t.getCause()) {
            String name;
            if (!(t instanceof IOException) || !CLIENT_ABORT_EXCEPTION.equals(name = t.getClass().getSimpleName()) && !EOF_EXCEPTION.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static void logClientAbort(Exception e) {
        log.warn((Object)("Client disconnected: " + ExceptionHelper.unwrapException(e).getMessage()));
    }
}

