/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cache.recycler;

import java.util.Locale;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.base.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hppc.DoubleIntOpenHashMap;
import org.elasticsearch.common.hppc.DoubleObjectOpenHashMap;
import org.elasticsearch.common.hppc.FloatIntOpenHashMap;
import org.elasticsearch.common.hppc.IntIntOpenHashMap;
import org.elasticsearch.common.hppc.IntObjectOpenHashMap;
import org.elasticsearch.common.hppc.LongIntOpenHashMap;
import org.elasticsearch.common.hppc.LongLongOpenHashMap;
import org.elasticsearch.common.hppc.LongObjectOpenHashMap;
import org.elasticsearch.common.hppc.ObjectFloatOpenHashMap;
import org.elasticsearch.common.hppc.ObjectIntOpenHashMap;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.recycler.AbstractRecyclerC;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.recycler.Recyclers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;

public class CacheRecycler
extends AbstractComponent {
    public final Recycler<ObjectObjectOpenHashMap> hashMap;
    public final Recycler<ObjectOpenHashSet> hashSet;
    public final Recycler<DoubleObjectOpenHashMap> doubleObjectMap;
    public final Recycler<LongObjectOpenHashMap> longObjectMap;
    public final Recycler<LongLongOpenHashMap> longLongMap;
    public final Recycler<IntIntOpenHashMap> intIntMap;
    public final Recycler<FloatIntOpenHashMap> floatIntMap;
    public final Recycler<DoubleIntOpenHashMap> doubleIntMap;
    public final Recycler<LongIntOpenHashMap> longIntMap;
    public final Recycler<ObjectIntOpenHashMap> objectIntMap;
    public final Recycler<IntObjectOpenHashMap> intObjectMap;
    public final Recycler<ObjectFloatOpenHashMap> objectFloatMap;

    public void close() {
        this.hashMap.close();
        this.hashSet.close();
        this.doubleObjectMap.close();
        this.longObjectMap.close();
        this.longLongMap.close();
        this.intIntMap.close();
        this.floatIntMap.close();
        this.doubleIntMap.close();
        this.longIntMap.close();
        this.objectIntMap.close();
        this.intObjectMap.close();
        this.objectFloatMap.close();
    }

    @Inject
    public CacheRecycler(Settings settings) {
        super(settings);
        Type type = Type.parse(settings.get("type"));
        int limit = settings.getAsInt("limit", (Integer)10);
        int smartSize = settings.getAsInt("smart_size", (Integer)1024);
        int availableProcessors = EsExecutors.boundedNumberOfProcessors(settings);
        this.hashMap = this.build(type, limit, smartSize, availableProcessors, new AbstractRecyclerC<ObjectObjectOpenHashMap>(){

            @Override
            public ObjectObjectOpenHashMap newInstance(int sizing) {
                return new ObjectObjectOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void recycle(ObjectObjectOpenHashMap value) {
                value.clear();
            }
        });
        this.hashSet = this.build(type, limit, smartSize, availableProcessors, new AbstractRecyclerC<ObjectOpenHashSet>(){

            @Override
            public ObjectOpenHashSet newInstance(int sizing) {
                return new ObjectOpenHashSet(CacheRecycler.size(sizing), 0.5f);
            }

            @Override
            public void recycle(ObjectOpenHashSet value) {
                value.clear();
            }
        });
        this.doubleObjectMap = this.build(type, limit, smartSize, availableProcessors, new AbstractRecyclerC<DoubleObjectOpenHashMap>(){

            @Override
            public DoubleObjectOpenHashMap newInstance(int sizing) {
                return new DoubleObjectOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void recycle(DoubleObjectOpenHashMap value) {
                value.clear();
            }
        });
        this.longObjectMap = this.build(type, limit, smartSize, availableProcessors, new AbstractRecyclerC<LongObjectOpenHashMap>(){

            @Override
            public LongObjectOpenHashMap newInstance(int sizing) {
                return new LongObjectOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void recycle(LongObjectOpenHashMap value) {
                value.clear();
            }
        });
        this.longLongMap = this.build(type, limit, smartSize, availableProcessors, new AbstractRecyclerC<LongLongOpenHashMap>(){

            @Override
            public LongLongOpenHashMap newInstance(int sizing) {
                return new LongLongOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void recycle(LongLongOpenHashMap value) {
                value.clear();
            }
        });
        this.intIntMap = this.build(type, limit, smartSize, availableProcessors, new AbstractRecyclerC<IntIntOpenHashMap>(){

            @Override
            public IntIntOpenHashMap newInstance(int sizing) {
                return new IntIntOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void recycle(IntIntOpenHashMap value) {
                value.clear();
            }
        });
        this.floatIntMap = this.build(type, limit, smartSize, availableProcessors, new AbstractRecyclerC<FloatIntOpenHashMap>(){

            @Override
            public FloatIntOpenHashMap newInstance(int sizing) {
                return new FloatIntOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void recycle(FloatIntOpenHashMap value) {
                value.clear();
            }
        });
        this.doubleIntMap = this.build(type, limit, smartSize, availableProcessors, new AbstractRecyclerC<DoubleIntOpenHashMap>(){

            @Override
            public DoubleIntOpenHashMap newInstance(int sizing) {
                return new DoubleIntOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void recycle(DoubleIntOpenHashMap value) {
                value.clear();
            }
        });
        this.longIntMap = this.build(type, limit, smartSize, availableProcessors, new AbstractRecyclerC<LongIntOpenHashMap>(){

            @Override
            public LongIntOpenHashMap newInstance(int sizing) {
                return new LongIntOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void recycle(LongIntOpenHashMap value) {
                value.clear();
            }

            @Override
            public void destroy(LongIntOpenHashMap value) {
            }
        });
        this.objectIntMap = this.build(type, limit, smartSize, availableProcessors, new AbstractRecyclerC<ObjectIntOpenHashMap>(){

            @Override
            public ObjectIntOpenHashMap newInstance(int sizing) {
                return new ObjectIntOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void recycle(ObjectIntOpenHashMap value) {
                value.clear();
            }
        });
        this.intObjectMap = this.build(type, limit, smartSize, availableProcessors, new AbstractRecyclerC<IntObjectOpenHashMap>(){

            @Override
            public IntObjectOpenHashMap newInstance(int sizing) {
                return new IntObjectOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void recycle(IntObjectOpenHashMap value) {
                value.clear();
            }
        });
        this.objectFloatMap = this.build(type, limit, smartSize, availableProcessors, new AbstractRecyclerC<ObjectFloatOpenHashMap>(){

            @Override
            public ObjectFloatOpenHashMap newInstance(int sizing) {
                return new ObjectFloatOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void recycle(ObjectFloatOpenHashMap value) {
                value.clear();
            }
        });
    }

    public <K, V> Recycler.V<ObjectObjectOpenHashMap<K, V>> hashMap(int sizing) {
        return this.hashMap.obtain(sizing);
    }

    public <T> Recycler.V<ObjectOpenHashSet<T>> hashSet(int sizing) {
        return this.hashSet.obtain(sizing);
    }

    public <T> Recycler.V<DoubleObjectOpenHashMap<T>> doubleObjectMap(int sizing) {
        return this.doubleObjectMap.obtain(sizing);
    }

    public <T> Recycler.V<LongObjectOpenHashMap<T>> longObjectMap(int sizing) {
        return this.longObjectMap.obtain(sizing);
    }

    public Recycler.V<LongLongOpenHashMap> longLongMap(int sizing) {
        return this.longLongMap.obtain(sizing);
    }

    public Recycler.V<IntIntOpenHashMap> intIntMap(int sizing) {
        return this.intIntMap.obtain(sizing);
    }

    public Recycler.V<FloatIntOpenHashMap> floatIntMap(int sizing) {
        return this.floatIntMap.obtain(sizing);
    }

    public Recycler.V<DoubleIntOpenHashMap> doubleIntMap(int sizing) {
        return this.doubleIntMap.obtain(sizing);
    }

    public Recycler.V<LongIntOpenHashMap> longIntMap(int sizing) {
        return this.longIntMap.obtain(sizing);
    }

    public <T> Recycler.V<ObjectIntOpenHashMap<T>> objectIntMap(int sizing) {
        return this.objectIntMap.obtain(sizing);
    }

    public <T> Recycler.V<IntObjectOpenHashMap<T>> intObjectMap(int sizing) {
        return this.intObjectMap.obtain(sizing);
    }

    public <T> Recycler.V<ObjectFloatOpenHashMap<T>> objectFloatMap(int sizing) {
        return this.objectFloatMap.obtain(sizing);
    }

    static int size(int sizing) {
        return sizing > 0 ? sizing : 256;
    }

    private <T> Recycler<T> build(Type type, int limit, int smartSize, int availableProcessors, Recycler.C<T> c) {
        Recycler<T> recycler;
        try {
            recycler = type.build(c, limit, availableProcessors);
            if (smartSize > 0) {
                recycler = Recyclers.sizing(recycler, Recyclers.none(c), smartSize);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new ElasticsearchIllegalArgumentException("no type support [" + (Object)((Object)type) + "] for recycler");
        }
        return recycler;
    }

    public static enum Type {
        QUEUE{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int availableProcessors) {
                return Recyclers.concurrentDeque(c, limit);
            }
        }
        ,
        SOFT_CONCURRENT{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int availableProcessors) {
                return Recyclers.concurrent(Recyclers.softFactory(Recyclers.dequeFactory(c, limit)), availableProcessors);
            }
        }
        ,
        CONCURRENT{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int availableProcessors) {
                return Recyclers.concurrent(Recyclers.dequeFactory(c, limit), availableProcessors);
            }
        }
        ,
        NONE{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int availableProcessors) {
                return Recyclers.none(c);
            }
        };


        public static Type parse(String type) {
            if (Strings.isNullOrEmpty(type)) {
                return SOFT_CONCURRENT;
            }
            try {
                return Type.valueOf(type.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new ElasticsearchIllegalArgumentException("no type support [" + type + "]");
            }
        }

        abstract <T> Recycler<T> build(Recycler.C<T> var1, int var2, int var3);
    }
}

