/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class Priority
implements Comparable<Priority> {
    public static final Priority IMMEDIATE = new Priority(-1);
    public static final Priority URGENT = new Priority(0);
    public static final Priority HIGH = new Priority(1);
    public static final Priority NORMAL = new Priority(2);
    public static final Priority LOW = new Priority(3);
    public static final Priority LANGUID = new Priority(4);
    private static final Priority[] values = new Priority[]{IMMEDIATE, URGENT, HIGH, NORMAL, LOW, LANGUID};
    private final byte value;

    public static Priority readFrom(StreamInput input) throws IOException {
        return Priority.fromByte(input.readByte());
    }

    public static void writeTo(Priority priority, StreamOutput output) throws IOException {
        byte b = priority.value;
        if (output.getVersion().before(Version.V_1_1_0)) {
            b = (byte)Math.max(Priority.URGENT.value, b);
        }
        output.writeByte(b);
    }

    public static Priority fromByte(byte b) {
        switch (b) {
            case -1: {
                return IMMEDIATE;
            }
            case 0: {
                return URGENT;
            }
            case 1: {
                return HIGH;
            }
            case 2: {
                return NORMAL;
            }
            case 3: {
                return LOW;
            }
            case 4: {
                return LANGUID;
            }
        }
        throw new ElasticsearchIllegalArgumentException("can't find priority for [" + b + "]");
    }

    private Priority(byte value) {
        this.value = value;
    }

    public static Priority[] values() {
        return values;
    }

    @Override
    public int compareTo(Priority p) {
        return this.value < p.value ? -1 : (this.value > p.value ? 1 : 0);
    }

    public boolean after(Priority p) {
        return this.value > p.value;
    }

    public boolean sameOrAfter(Priority p) {
        return this.value >= p.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Priority.class != o.getClass()) {
            return false;
        }
        Priority priority = (Priority)o;
        return this.value == priority.value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        switch (this.value) {
            case -1: {
                return "IMMEDIATE";
            }
            case 0: {
                return "URGENT";
            }
            case 1: {
                return "HIGH";
            }
            case 2: {
                return "NORMAL";
            }
            case 3: {
                return "LOW";
            }
        }
        return "LANGUID";
    }
}

