/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.EOFException;
import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.compress.CompressorContext;
import org.elasticsearch.common.io.stream.StreamInput;

public abstract class CompressedStreamInput<T extends CompressorContext>
extends StreamInput {
    private final StreamInput in;
    protected final CompressorContext context;
    private boolean closed;
    protected byte[] uncompressed;
    private int position = 0;
    private int valid = 0;

    public CompressedStreamInput(StreamInput in, T context) throws IOException {
        this.in = in;
        this.context = context;
        super.setVersion(in.getVersion());
        this.readHeader(in);
    }

    @Override
    public StreamInput setVersion(Version version) {
        this.in.setVersion(version);
        return super.setVersion(version);
    }

    public void resetToBufferStart() {
        this.position = 0;
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            return -1;
        }
        int left = this.valid - this.position;
        return left <= 0 ? 0 : left;
    }

    @Override
    public int read() throws IOException {
        if (!this.readyBuffer()) {
            return -1;
        }
        return this.uncompressed[this.position++] & 0xFF;
    }

    @Override
    public byte readByte() throws IOException {
        if (!this.readyBuffer()) {
            throw new EOFException();
        }
        return this.uncompressed[this.position++];
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.read(buffer, offset, length, false);
    }

    public int read(byte[] buffer, int offset, int length, boolean fullRead) throws IOException {
        if (length < 1) {
            return 0;
        }
        if (!this.readyBuffer()) {
            return -1;
        }
        int chunkLength = Math.min(this.valid - this.position, length);
        System.arraycopy(this.uncompressed, this.position, buffer, offset, chunkLength);
        this.position += chunkLength;
        if (chunkLength == length || !fullRead) {
            return chunkLength;
        }
        int totalRead = chunkLength;
        do {
            offset += chunkLength;
            if (!this.readyBuffer()) break;
            chunkLength = Math.min(this.valid - this.position, length - totalRead);
            System.arraycopy(this.uncompressed, this.position, buffer, offset, chunkLength);
            this.position += chunkLength;
        } while ((totalRead += chunkLength) < length);
        return totalRead;
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        int result = this.read(b, offset, len, true);
        if (result < len) {
            throw new EOFException();
        }
    }

    @Override
    public void reset() throws IOException {
        this.position = 0;
        this.valid = 0;
        this.in.reset();
    }

    @Override
    public void close() throws IOException {
        this.valid = 0;
        this.position = 0;
        if (!this.closed) {
            this.closed = true;
            this.doClose();
            this.in.close();
        }
    }

    protected abstract void doClose() throws IOException;

    protected boolean readyBuffer() throws IOException {
        if (this.position < this.valid) {
            return true;
        }
        if (this.closed) {
            return false;
        }
        this.valid = this.uncompress(this.in, this.uncompressed);
        if (this.valid < 0) {
            return false;
        }
        this.position = 0;
        return this.position < this.valid;
    }

    protected abstract void readHeader(StreamInput var1) throws IOException;

    protected abstract int uncompress(StreamInput var1, byte[] var2) throws IOException;
}

