/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webdav.backend;

import java.util.LinkedList;
import java.util.List;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;

public interface Backend {
    public String getRootPath();

    public String getRootUrl();

    public CoreSession getSession() throws ClientException;

    public CoreSession getSession(boolean var1) throws ClientException;

    public String getBackendDisplayName();

    public void saveChanges() throws ClientException;

    public boolean isLocked(DocumentRef var1) throws ClientException;

    public boolean canUnlock(DocumentRef var1) throws ClientException;

    public String lock(DocumentRef var1) throws ClientException;

    public boolean unlock(DocumentRef var1) throws ClientException;

    public String getCheckoutUser(DocumentRef var1) throws ClientException;

    public Path parseLocation(String var1);

    public DocumentModel resolveLocation(String var1) throws ClientException;

    public void removeItem(String var1) throws ClientException;

    public void removeItem(DocumentRef var1) throws ClientException;

    public void renameItem(DocumentModel var1, String var2) throws ClientException;

    public DocumentModel moveItem(DocumentModel var1, PathRef var2) throws ClientException;

    public DocumentModel moveItem(DocumentModel var1, DocumentRef var2, String var3) throws ClientException;

    public DocumentModel updateDocument(DocumentModel var1, String var2, Blob var3) throws ClientException;

    public DocumentModel copyItem(DocumentModel var1, PathRef var2) throws ClientException;

    public DocumentModel createFolder(String var1, String var2) throws ClientException;

    public DocumentModel createFile(String var1, String var2, Blob var3) throws ClientException;

    public DocumentModel createFile(String var1, String var2) throws ClientException;

    public List<DocumentModel> getChildren(DocumentRef var1) throws ClientException;

    public boolean isRename(String var1, String var2);

    public boolean exists(String var1);

    public boolean hasPermission(DocumentRef var1, String var2) throws ClientException;

    public String getDisplayName(DocumentModel var1);

    public LinkedList<String> getVirtualFolderNames() throws ClientException;

    public Backend getBackend(String var1);

    public boolean isVirtual();

    public boolean isRoot();

    public String getVirtualPath(String var1) throws ClientException;

    public DocumentModel getDocument(String var1) throws ClientException;
}

