/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets.plugins;

import com.sun.faces.facelets.tag.TagAttributesImpl;
import java.util.ArrayList;
import java.util.List;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagConfig;
import org.nuxeo.ecm.platform.forms.layout.api.BuiltinWidgetModes;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.WidgetException;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.ValueExpressionHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.plugins.AbstractWidgetTypeHandler;
import org.nuxeo.ecm.platform.ui.web.component.seam.UIHtmlText;

public class CheckboxWidgetTypeHandler
extends AbstractWidgetTypeHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public FaceletHandler getFaceletHandler(FaceletContext ctx, TagConfig tagConfig, Widget widget, FaceletHandler[] subHandlers) throws WidgetException {
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, tagConfig);
        String mode = widget.getMode();
        String widgetId = widget.getId();
        String widgetName = widget.getName();
        String widgetTagConfigId = widget.getTagConfigId();
        FaceletHandler leaf = this.getNextHandler(ctx, tagConfig, widget, subHandlers, helper);
        if ("edit".equals(mode)) {
            TagAttributes attributes = helper.getTagAttributes(widgetId, widget);
            ComponentHandler input = helper.getHtmlComponentHandler(widgetTagConfigId, attributes, leaf, "javax.faces.HtmlSelectBooleanCheckbox", "javax.faces.NXCheckbox");
            String msgId = helper.generateMessageId(widgetName);
            ComponentHandler message = helper.getMessageComponentHandler(widgetTagConfigId, msgId, widgetId, null);
            FaceletHandler[] handlers = new FaceletHandler[]{input, message};
            return new CompositeFaceletHandler(handlers);
        }
        TagAttributes attributes = this.getViewTagAttributes(ctx, helper, widgetId, widget, !BuiltinWidgetModes.isLikePlainMode((String)mode));
        ComponentHandler output = helper.getHtmlComponentHandler(widgetTagConfigId, attributes, leaf, "javax.faces.HtmlOutputText", null);
        if ("pdf".equals(mode)) {
            return helper.getHtmlComponentHandler(widgetTagConfigId, (TagAttributes)new TagAttributesImpl(new TagAttribute[0]), (FaceletHandler)output, UIHtmlText.class.getName(), null);
        }
        return output;
    }

    protected TagAttributes getViewTagAttributes(FaceletContext ctx, FaceletHandlerHelper helper, String id, Widget widget, boolean addId) {
        List<TagAttribute> propertyAttrs;
        ArrayList<TagAttribute> attrs = new ArrayList<TagAttribute>();
        FieldDefinition[] fields = widget.getFieldDefinitions();
        if (fields != null && fields.length > 0) {
            FieldDefinition field = fields[0];
            String bareExpression = ValueExpressionHelper.createBareExpressionString(widget.getValueName(), field);
            String bundleName = ctx.getFacesContext().getApplication().getMessageBundle();
            String messageYes = String.format("%s['label.yes']", bundleName);
            String messageNo = String.format("%s['label.no']", bundleName);
            String expression = String.format("#{%s ? %s : %s}", bareExpression, messageYes, messageNo);
            TagAttribute valueAttr = helper.createAttribute("value", expression);
            attrs.add(valueAttr);
        }
        if ((propertyAttrs = helper.getTagAttributes(widget.getProperties(), null, true, widget.getType(), widget.getTypeCategory(), widget.getMode())) != null) {
            attrs.addAll(propertyAttrs);
        }
        TagAttributes widgetAttrs = FaceletHandlerHelper.getTagAttributes(attrs);
        if (!addId) {
            return widgetAttrs;
        }
        return FaceletHandlerHelper.addTagAttribute(widgetAttrs, helper.createAttribute("id", id));
    }
}

