/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.XMLConverter;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.atompub.AbstractAtomPubServiceCall;

public class AclService {

    public static class ApplyAcl
    extends AclServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            String objectId = this.getStringParameter(request, "id");
            AclPropagation aclPropagation = this.getEnumParameter(request, "ACLPropagation", AclPropagation.class);
            Acl aces = null;
            XMLStreamReader parser = null;
            try {
                parser = XMLUtils.createParser((InputStream)request.getInputStream());
                XMLUtils.findNextStartElemenet((XMLStreamReader)parser);
                aces = XMLConverter.convertAcl((XMLStreamReader)parser);
            }
            catch (XMLStreamException e) {
                throw new CmisInvalidArgumentException("Invalid request!", (Throwable)e);
            }
            finally {
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (XMLStreamException e2) {}
                }
            }
            if (this.stopBeforeService(service)) {
                return;
            }
            Acl acl = service.applyAcl(repositoryId, objectId, aces, aclPropagation);
            if (this.stopAfterService(service)) {
                return;
            }
            if (acl == null) {
                throw new CmisRuntimeException("ACL is null!");
            }
            response.setStatus(201);
            response.setContentType("application/cmisacl+xml");
            this.writeAclXML(acl, context.getCmisVersion(), (OutputStream)response.getOutputStream());
        }
    }

    public static class GetAcl
    extends AclServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = this.getStringParameter(request, "id");
            Boolean onlyBasicPermissions = this.getBooleanParameter(request, "onlyBasicPermissions");
            if (this.stopBeforeService(service)) {
                return;
            }
            Acl acl = service.getAcl(repositoryId, objectId, onlyBasicPermissions, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (acl == null) {
                throw new CmisRuntimeException("ACL is null!");
            }
            response.setStatus(200);
            response.setContentType("application/cmisacl+xml");
            this.writeAclXML(acl, context.getCmisVersion(), (OutputStream)response.getOutputStream());
        }
    }

    public static abstract class AclServiceCall
    extends AbstractAtomPubServiceCall {
        protected void writeAclXML(Acl acl, CmisVersion cmisVersion, OutputStream out) throws XMLStreamException {
            XMLStreamWriter writer = XMLUtils.createWriter((OutputStream)out);
            XMLUtils.startXmlDocument((XMLStreamWriter)writer);
            XMLConverter.writeAcl((XMLStreamWriter)writer, (CmisVersion)cmisVersion, (boolean)true, (Acl)acl);
            XMLUtils.endXmlDocument((XMLStreamWriter)writer);
        }
    }
}

