/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.utils;

import com.phloc.commons.hierarchy.IHierarchyWalkerCallback;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.parent.IChildrenProvider;
import com.phloc.commons.parent.impl.ChildrenProviderHasChildren;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MicroWalker {
    private static final MicroWalker s_aInstance = new MicroWalker();

    private MicroWalker() {
    }

    private static <T extends IMicroNode> void _walkNode(@Nonnull T t, @Nonnull IChildrenProvider<T> iChildrenProvider, @Nonnull IHierarchyWalkerCallback<? super T> iHierarchyWalkerCallback) {
        iHierarchyWalkerCallback.onItemBeforeChildren(t);
        if (iChildrenProvider.hasChildren(t)) {
            for (IMicroNode iMicroNode : iChildrenProvider.getChildren(t)) {
                iHierarchyWalkerCallback.onLevelDown();
                MicroWalker._walkNode(iMicroNode, iChildrenProvider, iHierarchyWalkerCallback);
                iHierarchyWalkerCallback.onLevelUp();
            }
        }
        iHierarchyWalkerCallback.onItemAfterChildren(t);
    }

    public static void walkNode(@Nonnull IMicroNode iMicroNode, @Nonnull IHierarchyWalkerCallback<? super IMicroNode> iHierarchyWalkerCallback) {
        MicroWalker.walkNode(iMicroNode, new ChildrenProviderHasChildren(), iHierarchyWalkerCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends IMicroNode> void walkNode(@Nonnull T t, @Nonnull IChildrenProvider<T> iChildrenProvider, @Nonnull IHierarchyWalkerCallback<? super T> iHierarchyWalkerCallback) {
        if (t == null) {
            throw new NullPointerException("node");
        }
        if (iHierarchyWalkerCallback == null) {
            throw new NullPointerException("callback");
        }
        iHierarchyWalkerCallback.begin();
        try {
            if (iChildrenProvider.hasChildren(t)) {
                for (IMicroNode iMicroNode : iChildrenProvider.getChildren(t)) {
                    MicroWalker._walkNode(iMicroNode, iChildrenProvider, iHierarchyWalkerCallback);
                }
            }
        }
        finally {
            iHierarchyWalkerCallback.end();
        }
    }
}

