/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.http;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.connector.http.proxy.ProxyPacResolver;
import org.nuxeo.connect.connector.http.proxy.RhinoProxyPacResolver;

public class ProxyHelper {
    protected static boolean useNTLM = false;
    protected static ProxyPacResolver pacResolver = new RhinoProxyPacResolver();
    protected static String PROXY_PAC_DIRECT = "DIRECT";

    public static void configureProxyIfNeeded(HttpClient httpClient, String url) {
        if (ConnectUrlConfig.useProxy()) {
            if (ConnectUrlConfig.useProxyPac()) {
                String[] proxy = pacResolver.findProxy(url);
                if (proxy != null) {
                    httpClient.getHostConfiguration().setProxy(proxy[0], Integer.parseInt(proxy[1]));
                }
            } else {
                httpClient.getHostConfiguration().setProxy(ConnectUrlConfig.getProxyHost(), ConnectUrlConfig.getProxyPort());
            }
            if (ConnectUrlConfig.isProxyAuthenticated()) {
                if (ConnectUrlConfig.isProxyNTLM()) {
                    NTCredentials ntlmCredential = new NTCredentials(ConnectUrlConfig.getProxyLogin(), ConnectUrlConfig.getProxyPassword(), ConnectUrlConfig.getProxyNTLMHost(), ConnectUrlConfig.getProxyNTLMDomain());
                    httpClient.getState().setProxyCredentials(new AuthScope(null, -1, AuthScope.ANY_REALM), (Credentials)ntlmCredential);
                } else {
                    UsernamePasswordCredentials ba = new UsernamePasswordCredentials(ConnectUrlConfig.getProxyLogin(), ConnectUrlConfig.getProxyPassword());
                    httpClient.getState().setProxyCredentials(new AuthScope(null, -1, AuthScope.ANY_REALM), (Credentials)ba);
                }
            }
        }
    }
}

