/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Version
implements Comparable<Version> {
    private static final Log log = LogFactory.getLog(Version.class);
    public static final String SNAPSHOT = "-SNAPSHOT";
    public static final Version ZERO = new Version(0);
    public static final Pattern SPECIAL_CLASSIFIER = Pattern.compile("^(((RC|rc|alpha|ALPHA|beta|BETA)\\d*)|([a-zA-Z][0-9]{8})).*$");
    protected boolean specialClassifier = false;
    protected int major;
    protected int minor;
    protected int patch;
    protected String classifier;
    protected boolean snapshot = false;

    public boolean isSpecialClassifier() {
        return this.specialClassifier;
    }

    public Version(String version) {
        int p;
        int i = version.indexOf(SNAPSHOT);
        if (i > 0) {
            version = version.substring(0, i);
            this.snapshot = true;
        }
        if ((p = version.lastIndexOf(45)) > 0) {
            this.classifier = version.substring(p + 1);
            version = version.substring(0, p);
            this.specialClassifier = SPECIAL_CLASSIFIER.matcher(this.classifier).matches();
        }
        if ((p = version.indexOf(46, 0)) > -1) {
            this.major = Integer.parseInt(version.substring(0, p));
            int q = version.indexOf(46, p + 1);
            if (q > -1) {
                this.minor = Integer.parseInt(version.substring(p + 1, q));
                this.patch = Integer.parseInt(version.substring(q + 1));
            } else {
                this.minor = Integer.parseInt(version.substring(p + 1));
            }
        } else {
            this.major = Integer.parseInt(version);
        }
    }

    public Version(int major) {
        this(major, 0, 0);
    }

    public Version(int major, int minor) {
        this(major, minor, 0);
    }

    public Version(int major, int minor, int patch) {
        this(major, minor, patch, null);
    }

    public Version(int major, int minor, int patch, String classifier) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.classifier = classifier;
        if (classifier != null) {
            this.specialClassifier = SPECIAL_CLASSIFIER.matcher(classifier).matches();
        }
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public String classifier() {
        return this.classifier;
    }

    public boolean lessThan(Version v) {
        return this.compareTo(v) < 0;
    }

    public boolean lessOrEqualsThan(Version v) {
        return this.compareTo(v) <= 0;
    }

    public boolean equalsTo(Version v) {
        return this.compareTo(v) == 0;
    }

    public boolean greaterThan(Version v) {
        return this.compareTo(v) > 0;
    }

    public boolean greaterOrEqualThan(Version v) {
        return this.compareTo(v) >= 0;
    }

    @Override
    public int compareTo(Version o) {
        String oClassifier;
        log.trace((Object)("Comparing " + this + " with " + o));
        int d = this.major - o.major;
        if (d != 0) {
            return d;
        }
        d = this.minor - o.minor;
        if (d != 0) {
            return d;
        }
        d = this.patch - o.patch;
        if (d != 0) {
            return d;
        }
        String mClassifier = this.classifier == null ? "" : this.classifier;
        String string = oClassifier = o.classifier == null ? "" : o.classifier;
        if (mClassifier.equals(oClassifier)) {
            if (this.snapshot == o.isSnapshot()) {
                log.trace((Object)" case 1 => 0");
                return 0;
            }
            if (this.isSnapshot()) {
                log.trace((Object)" case 2 => -1");
                return -1;
            }
            log.trace((Object)" case 3 => 1");
            return 1;
        }
        if (this.specialClassifier && o.isSpecialClassifier() || !this.specialClassifier && !o.isSpecialClassifier()) {
            log.trace((Object)" case 4 => compare classifiers");
            return mClassifier.compareTo(oClassifier);
        }
        if (this.specialClassifier) {
            log.trace((Object)" case 1 => -1");
            return -1;
        }
        log.trace((Object)" case 6 => 1");
        return 1;
    }

    public boolean equals(Object o) {
        return this == o || o != null && o instanceof Version && this.compareTo((Version)o) == 0;
    }

    public int hashCode() {
        return this.major << 16 | this.minor << 8 | this.patch;
    }

    public String toString() {
        String v = this.classifier == null ? this.major + "." + this.minor + "." + this.patch : this.major + "." + this.minor + "." + this.patch + "-" + this.classifier;
        if (this.isSnapshot()) {
            v = v + SNAPSHOT;
        }
        return v;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(boolean isSnapshot) {
        this.snapshot = isSnapshot;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }
}

