/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.management;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.blob.ByteArrayBlob;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.counters.CounterHistoryStack;
import org.nuxeo.runtime.management.counters.CounterManager;

@Operation(id="Counters.GET", category="Services", label="Retrieve counters values", description="Retrieve data collected by one or more Counters", addToStudio=false)
public class GetCounters {
    public static final String ID = "Counters.GET";
    @Context
    protected OperationContext ctx;
    @Param(name="counterNames", required=true)
    protected StringList counterNames;

    @OperationMethod
    public Blob run() throws Exception {
        NuxeoPrincipal nuxeoUser;
        CounterManager cm = (CounterManager)Framework.getLocalService(CounterManager.class);
        JSONObject collection = new JSONObject();
        Principal principal = this.ctx.getPrincipal();
        if (principal instanceof NuxeoPrincipal && (nuxeoUser = (NuxeoPrincipal)principal).isAdministrator()) {
            for (String counterName : this.counterNames) {
                CounterHistoryStack stack = cm.getCounterHistory(counterName);
                ArrayList valueList = new ArrayList(stack.getAsList());
                Collections.reverse(valueList);
                JSONObject counter = new JSONObject();
                JSONArray valueSerie = new JSONArray();
                JSONArray deltaSerie = new JSONArray();
                JSONArray speedSerie = new JSONArray();
                float lastTS = 0.0f;
                float lastValue = 0.0f;
                long now = System.currentTimeMillis();
                for (long[] values : valueList) {
                    long ts = values[0];
                    float t = (now - ts) / 1000L;
                    float value = values[1];
                    JSONArray valueArray = new JSONArray();
                    JSONArray deltaArray = new JSONArray();
                    JSONArray speedArray = new JSONArray();
                    valueArray.add((Object)ts);
                    valueArray.add((Object)Float.valueOf(value));
                    valueSerie.add((Object)valueArray);
                    deltaArray.add((Object)ts);
                    deltaArray.add((Object)Float.valueOf(value - lastValue));
                    deltaSerie.add((Object)deltaArray);
                    if (lastTS > 0.0f) {
                        speedArray.add((Object)ts);
                        float tdelta = lastTS - t;
                        if (tdelta == 0.0f) {
                            tdelta = 1.0f;
                        }
                        speedArray.add((Object)Float.valueOf(60.0f * (value - lastValue) / tdelta));
                        speedSerie.add((Object)speedArray);
                    }
                    lastTS = t;
                    lastValue = value;
                }
                counter.put((Object)"values", (Object)valueSerie);
                counter.put((Object)"deltas", (Object)deltaSerie);
                counter.put((Object)"speed", (Object)speedSerie);
                collection.put((Object)counterName, (Object)counter);
            }
        }
        return new ByteArrayBlob(collection.toString().getBytes("UTF-8"), "application/json");
    }
}

