/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jaxrs.io.documents;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.core.util.PaginableDocumentModelList;
import org.nuxeo.ecm.automation.jaxrs.io.documents.JsonDocumentListWriter;
import org.nuxeo.ecm.automation.jaxrs.io.documents.JsonESDocumentWriter;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

@Provider
@Produces(value={"application/json+esentity"})
public class JsonESDocumentListWriter
extends JsonDocumentListWriter {
    private static final Log log = LogFactory.getLog(JsonESDocumentListWriter.class);
    public static final String MIME_TYPE = "application/json+esentity";
    public static final String HEADER_ERROR_MESSAGE = "X-NXErrorMessage";
    public static final String HEADER_HAS_ERROR = "X-NXHasError";
    public static final String HEADER_PAGE_SIZE = "X-NXPageSize";
    public static final String HEADER_RESULTS_COUNT = "X-NXResultsCount";
    public static final String HEADER_IS_LAST_PAGE_AVAILABLE = "X-NXIsLastPageAvailable";
    public static final String HEADER_NUMBER_OF_PAGES = "X-NXnumberOfPages";
    public static final String HEADER_CURRENT_PAGE_INDEX = "X-NXCurrentPageIndex";
    public static final String DEFAULT_ES_INDEX = "nuxeo";
    public static final String DEFAULT_ES_TYPE = "doc";
    @Context
    private HttpServletResponse response;
    @Context
    private HttpServletRequest request;

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return super.isWriteable(type, genericType, annotations, mediaType) && MIME_TYPE.equals(mediaType.toString());
    }

    @Override
    public void writeDocuments(OutputStream out, List<DocumentModel> docs, String[] schemas, HttpHeaders headers) throws Exception {
        this.writeDocs(this.factory.createJsonGenerator(out, JsonEncoding.UTF8), docs, schemas);
    }

    @Override
    public void writeDocuments(OutputStream out, List<DocumentModel> docs, String[] schemas) throws Exception {
        this.writeDocs(this.factory.createJsonGenerator(out, JsonEncoding.UTF8), docs, schemas, null);
    }

    public void writeDocs(JsonGenerator jg, List<DocumentModel> docs, String[] schemas) throws Exception {
        this.writeDocs(jg, docs, schemas, null);
    }

    public void writeDocs(JsonGenerator jg, List<DocumentModel> docs, String[] schemas, HttpHeaders headers) throws Exception {
        String esType;
        String esIndex = this.request.getParameter("esIndex");
        if (esIndex == null) {
            esIndex = DEFAULT_ES_INDEX;
        }
        if ((esType = this.request.getParameter("esType")) == null) {
            esType = DEFAULT_ES_TYPE;
        }
        JsonESDocumentWriter jsonESDocumentWriter = new JsonESDocumentWriter();
        if (docs instanceof PaginableDocumentModelList) {
            PaginableDocumentModelList provider = (PaginableDocumentModelList)docs;
            this.response.setHeader(HEADER_CURRENT_PAGE_INDEX, Long.valueOf(provider.getCurrentPageIndex()).toString());
            this.response.setHeader(HEADER_NUMBER_OF_PAGES, Long.valueOf(provider.getNumberOfPages()).toString());
            this.response.setHeader(HEADER_RESULTS_COUNT, Long.valueOf(provider.getResultsCount()).toString());
            this.response.setHeader(HEADER_PAGE_SIZE, Long.valueOf(provider.size()).toString());
            this.response.setHeader(HEADER_IS_LAST_PAGE_AVAILABLE, Boolean.valueOf(provider.isLastPageAvailable()).toString());
            this.response.setHeader(HEADER_HAS_ERROR, Boolean.valueOf(provider.hasError()).toString());
            this.response.setHeader(HEADER_ERROR_MESSAGE, provider.getErrorMessage());
            DocumentViewCodecManager documentViewCodecManager = (DocumentViewCodecManager)Framework.getLocalService(DocumentViewCodecManager.class);
            String codecName = null;
            if (documentViewCodecManager == null) {
                log.warn((Object)"Service 'DocumentViewCodecManager' not available : documentUrl won't be generated");
            } else {
                String documentLinkBuilder = provider.getDocumentLinkBuilder();
                codecName = StringUtils.isBlank((String)documentLinkBuilder) ? documentViewCodecManager.getDefaultCodecName() : documentLinkBuilder;
            }
            for (DocumentModel doc : docs) {
                jg.writeStartObject();
                jg.writeObjectFieldStart("index");
                jg.writeStringField("_index", esIndex);
                jg.writeStringField("_type", esType);
                jg.writeStringField("_id", doc.getId());
                jg.writeEndObject();
                jg.writeEndObject();
                jg.writeRaw('\n');
                DocumentLocationImpl docLoc = new DocumentLocationImpl(doc);
                HashMap<String, String> contextParameters = new HashMap<String, String>();
                if (documentViewCodecManager != null) {
                    DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc, ((TypeInfo)doc.getAdapter(TypeInfo.class)).getDefaultView());
                    String documentURL = VirtualHostHelper.getContextPathProperty() + "/" + documentViewCodecManager.getUrlFromDocumentView(codecName, (DocumentView)docView, false, null);
                    contextParameters.put("ecm:documentUrl", documentURL);
                }
                jsonESDocumentWriter.writeESDocument(jg, doc, schemas, contextParameters);
                jg.writeRaw('\n');
            }
        } else {
            this.response.setHeader(HEADER_CURRENT_PAGE_INDEX, "1");
            this.response.setHeader(HEADER_NUMBER_OF_PAGES, "1");
            this.response.setHeader(HEADER_IS_LAST_PAGE_AVAILABLE, "1");
            this.response.setHeader(HEADER_RESULTS_COUNT, Integer.valueOf(docs.size()).toString());
            this.response.setHeader(HEADER_PAGE_SIZE, Integer.valueOf(docs.size()).toString());
            this.response.setHeader(HEADER_HAS_ERROR, "false");
            for (DocumentModel doc : docs) {
                jsonESDocumentWriter.writeESDocument(jg, doc, schemas, null);
                jg.writeRaw('\n');
            }
        }
        jg.flush();
    }
}

