/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html.servlets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.requestcontroller.filter.BufferingServletOutputStream;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.ApplicationType;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.ResourceResolver;
import org.nuxeo.theme.html.CSSUtils;
import org.nuxeo.theme.html.JSUtils;
import org.nuxeo.theme.html.Utils;
import org.nuxeo.theme.resources.ResourceType;
import org.nuxeo.theme.themes.ThemeException;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;

public final class Resources
extends HttpServlet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Resources.class);
    private static final Pattern pathPattern = Pattern.compile("/([^/]+)");

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doProcess(request, response);
    }

    protected void doProcess(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ApplicationType application;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return;
        }
        Matcher m = pathPattern.matcher(pathInfo);
        if (!m.matches()) {
            log.error((Object)String.format("Invalid resource path: %s", pathInfo));
            return;
        }
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        ThemeManager themeManager = Manager.getThemeManager();
        String contentType = null;
        String resourceSuffix = null;
        List<String> resourceNames = Arrays.asList(m.group(1).split(","));
        for (String resourceName : resourceNames) {
            String previousContentType = contentType;
            if (resourceName.endsWith(".js")) {
                contentType = "text/javascript";
                resourceSuffix = ".js";
            } else if (resourceName.endsWith(".css")) {
                contentType = "text/css";
                resourceSuffix = ".css";
            } else if (resourceName.endsWith(".json")) {
                contentType = "text/json";
                resourceSuffix = ".json";
            }
            if (contentType == null) {
                log.error((Object)("Resource names must end with .js, .css or .json: " + pathInfo));
                return;
            }
            if (previousContentType == null || contentType.equals(previousContentType)) continue;
            log.error((Object)("Combined resources must be of the same type: " + pathInfo));
            return;
        }
        response.addHeader("content-type", contentType);
        String applicationPath = request.getParameter("path");
        if (applicationPath != null && (application = (ApplicationType)Manager.getTypeRegistry().lookup(TypeFamily.APPLICATION, applicationPath)) != null) {
            Utils.setCacheHeaders(response, application.getResourceCaching());
        }
        StringBuilder text = new StringBuilder();
        String basePath = request.getParameter("basepath");
        ArrayList allResourceNames = new ArrayList();
        allResourceNames.addAll(themeManager.getOrderedResourcesAndDeps(resourceNames));
        for (String resourceName : allResourceNames) {
            if (!resourceName.endsWith(resourceSuffix)) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            String source = themeManager.getResource(resourceName);
            if (source == null) {
                ResourceType resource = (ResourceType)typeRegistry.lookup(TypeFamily.RESOURCE, resourceName);
                if (resource == null) {
                    log.error((Object)String.format("Resource not registered %s.", resourceName));
                    continue;
                }
                Resources.writeResource(resource, out);
                source = ((Object)out).toString();
                if (resourceName.endsWith(".js")) {
                    if (resource.isShrinkable() && !Framework.isDevModeSet()) {
                        try {
                            source = JSUtils.compressSource(source);
                        }
                        catch (ThemeException e) {
                            log.warn((Object)("failed to compress javascript source: " + resourceName));
                        }
                    }
                } else if (resourceName.endsWith(".css")) {
                    String cssContextPath = resource.getContextPath();
                    if (cssContextPath != null) {
                        source = CSSUtils.expandPartialUrls(source, cssContextPath);
                    }
                    source = Framework.expandVars((String)source);
                    source = source.replaceAll("\\$\\{basePath\\}", Matcher.quoteReplacement(basePath));
                    source = source.replaceAll("\\$\\{org.nuxeo.ecm.contextPath\\}", Matcher.quoteReplacement(basePath));
                    if (resource.isShrinkable() && !Framework.isDevModeSet()) {
                        try {
                            source = CSSUtils.compressSource(source);
                        }
                        catch (ThemeException e) {
                            log.warn((Object)("failed to compress CSS source: " + resourceName));
                        }
                    }
                }
                if (!Framework.isDevModeSet()) {
                    themeManager.setResource(resourceName, source);
                }
            }
            text.append(source);
            if (out == null) continue;
            ((OutputStream)out).close();
        }
        boolean supportsGzip = Utils.supportsGzip(request);
        Object os = response.getOutputStream();
        BufferingServletOutputStream.stopBuffering((OutputStream)os);
        if (supportsGzip) {
            response.setHeader("Content-Encoding", "gzip");
            response.setHeader("Vary", "Accept-Encoding");
            os = new GZIPOutputStream((OutputStream)os);
        }
        try {
            os.write(text.toString().getBytes());
            os.close();
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause != null && "Broken pipe".equals(cause.getMessage())) {
                log.debug((Object)("Swallowing: " + e));
            }
            throw e;
        }
        log.debug((Object)String.format("Served resource(s): %s %s", pathInfo, supportsGzip ? "with gzip compression" : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResource(ResourceType resource, OutputStream out) {
        InputStream in = null;
        try {
            String path = resource.getPath();
            in = ResourceResolver.getInstance().getResourceAsStream(path);
            if (in != null) {
                byte[] buffer = new byte[1024];
                int read = in.read(buffer);
                while (read != -1) {
                    out.write(buffer, 0, read);
                    read = in.read(buffer);
                    out.flush();
                }
                out.close();
            } else {
                log.error((Object)String.format("Resource not found %s.", resource.getName()));
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }
}

