/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AbstractAtomPubService;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AtomEntryWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomElement;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomEntry;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomFeed;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomLink;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.ReturnVersion;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;

public class VersioningServiceImpl
extends AbstractAtomPubService
implements VersioningService {
    public VersioningServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkOut(String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied) {
        if (objectId == null || objectId.getValue() == null || ((String)objectId.getValue()).length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        String link = this.loadCollection(repositoryId, "checkedout");
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository or checkedout collection not supported!");
        }
        UrlBuilder url = new UrlBuilder(link);
        if (this.getSession().get("org.apache.chemistry.opencmis.workaround.includeObjectIdOnCheckout", false)) {
            url.addParameter("objectId", objectId.getValue());
        }
        final AtomEntryWriter entryWriter = new AtomEntryWriter(this.createIdObject((String)objectId.getValue()), this.getCmisVersion(repositoryId));
        Response resp = this.post(url, "application/atom+xml;type=entry", new Output(){

            @Override
            public void write(OutputStream out) throws XMLStreamException, IOException {
                entryWriter.write(out);
            }
        });
        AtomEntry entry = this.parse(resp.getStream(), AtomEntry.class);
        objectId.setValue((Object)entry.getId());
        this.lockLinks();
        try {
            this.removeLinks(repositoryId, entry.getId());
            for (AtomElement element : entry.getElements()) {
                if (!(element.getObject() instanceof AtomLink)) continue;
                this.addLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
            }
        }
        finally {
            this.unlockLinks();
        }
        if (contentCopied != null) {
            contentCopied.setValue(null);
        }
    }

    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        String wcLink;
        String link = this.loadLink(repositoryId, objectId, "self", "application/atom+xml;type=entry");
        if (link == null) {
            this.throwLinkException(repositoryId, objectId, "self", "application/atom+xml;type=entry");
        }
        if ((wcLink = this.getLink(repositoryId, objectId, "working-copy", "application/atom+xml;type=entry")) != null) {
            link = wcLink;
        }
        this.delete(new UrlBuilder(link));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        Acl newACL;
        String wcLink;
        if (objectId == null || objectId.getValue() == null || ((String)objectId.getValue()).length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        String link = this.loadLink(repositoryId, (String)objectId.getValue(), "self", "application/atom+xml;type=entry");
        if (link == null) {
            this.throwLinkException(repositoryId, (String)objectId.getValue(), "self", "application/atom+xml;type=entry");
        }
        if ((wcLink = this.getLink(repositoryId, (String)objectId.getValue(), "working-copy", "application/atom+xml;type=entry")) != null) {
            link = wcLink;
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("checkinComment", (Object)checkinComment);
        url.addParameter("major", (Object)major);
        url.addParameter("checkin", (Object)"true");
        final AtomEntryWriter entryWriter = new AtomEntryWriter((ObjectData)this.createObject(properties, null, policies), this.getCmisVersion(repositoryId), contentStream);
        Response resp = this.put(url, "application/atom+xml;type=entry", new Output(){

            @Override
            public void write(OutputStream out) throws XMLStreamException, IOException {
                entryWriter.write(out);
            }
        });
        AtomEntry entry = this.parse(resp.getStream(), AtomEntry.class);
        if (entry.getId() == null) {
            throw new CmisConnectionException("Received Atom entry is not a CMIS entry!");
        }
        objectId.setValue((Object)entry.getId());
        AccessControlListImpl originalAces = null;
        this.lockLinks();
        try {
            this.removeLinks(repositoryId, entry.getId());
            for (AtomElement element : entry.getElements()) {
                ObjectData object;
                if (element.getObject() instanceof AtomLink) {
                    this.addLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                    continue;
                }
                if (!(element.getObject() instanceof ObjectData) || (object = (ObjectData)element.getObject()).getAcl() == null) continue;
                originalAces = new AccessControlListImpl(object.getAcl().getAces());
                originalAces.setExact(object.isExactAcl());
            }
        }
        finally {
            this.unlockLinks();
        }
        if (originalAces != null && this.isAclMergeRequired(addAces, removeAces) && (newACL = this.mergeAcls((Acl)originalAces, addAces, removeAces)) != null) {
            this.updateAcl(repositoryId, entry.getId(), newACL, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        ArrayList<ObjectData> result = new ArrayList<ObjectData>();
        String link = this.loadLink(repositoryId, objectId, "version-history", "application/atom+xml;type=feed");
        if (link == null) {
            this.throwLinkException(repositoryId, objectId, "version-history", "application/atom+xml;type=feed");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("filter", (Object)filter);
        url.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        Response resp = this.read(url);
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        if (!feed.getEntries().isEmpty()) {
            for (AtomEntry entry : feed.getEntries()) {
                ObjectData version = null;
                this.lockLinks();
                try {
                    this.removeLinks(repositoryId, entry.getId());
                    for (AtomElement element : entry.getElements()) {
                        if (element.getObject() instanceof AtomLink) {
                            this.addLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                            continue;
                        }
                        if (!(element.getObject() instanceof ObjectData)) continue;
                        version = (ObjectData)element.getObject();
                    }
                }
                finally {
                    this.unlockLinks();
                }
                if (version == null) continue;
                result.add(version);
            }
        }
        return result;
    }

    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, ExtensionsData extension) {
        ReturnVersion returnVersion = ReturnVersion.LATEST;
        if (major != null && major.booleanValue()) {
            returnVersion = ReturnVersion.LASTESTMAJOR;
        }
        return this.getObjectInternal(repositoryId, AbstractAtomPubService.IdentifierType.ID, objectId, returnVersion, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeACL, extension);
    }

    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        ReturnVersion returnVersion = ReturnVersion.LATEST;
        if (major != null && major.booleanValue()) {
            returnVersion = ReturnVersion.LASTESTMAJOR;
        }
        ObjectData object = this.getObjectInternal(repositoryId, AbstractAtomPubService.IdentifierType.ID, objectId, returnVersion, filter, Boolean.FALSE, IncludeRelationships.NONE, "cmis:none", Boolean.FALSE, Boolean.FALSE, extension);
        return object.getProperties();
    }
}

