/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.transaction.Synchronizations;
import org.jboss.seam.transaction.UserTransaction;

public abstract class AbstractUserTransaction
implements UserTransaction {
    @Override
    public boolean isActive() throws SystemException {
        return this.getStatus() == 0;
    }

    @Override
    public boolean isActiveOrMarkedRollback() throws SystemException {
        int status = this.getStatus();
        return status == 0 || status == 1;
    }

    @Override
    public boolean isRolledBackOrMarkedRollback() throws SystemException {
        int status = this.getStatus();
        return status == 4 || status == 1;
    }

    @Override
    public boolean isMarkedRollback() throws SystemException {
        return this.getStatus() == 1;
    }

    @Override
    public boolean isNoTransaction() throws SystemException {
        return this.getStatus() == 6;
    }

    @Override
    public boolean isRolledBack() throws SystemException {
        return this.getStatus() == 4;
    }

    @Override
    public boolean isCommitted() throws SystemException {
        return this.getStatus() == 3;
    }

    @Override
    public boolean isConversationContextRequired() {
        return false;
    }

    @Override
    public abstract void registerSynchronization(Synchronization var1);

    @Override
    public void enlist(EntityManager entityManager) throws SystemException {
        if (this.isActiveOrMarkedRollback()) {
            entityManager.joinTransaction();
        }
    }

    public static Synchronizations getSynchronizations() {
        return (Synchronizations)Component.getInstance("org.jboss.seam.transaction.synchronizations", ScopeType.EVENT);
    }
}

