/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;

@XObject(value="link")
public class DataSourceLinkDescriptor {
    protected String name;
    protected String global;
    @XNode(value="@type")
    protected String type;

    @XNode(value="@name")
    public void setName(String value) {
        this.name = DataSourceHelper.getDataSourceJNDIName(value);
    }

    @XNode(value="@global")
    public void setGlobal(String value) {
        this.global = DataSourceHelper.getDataSourceJNDIName(value);
    }

    public void bindSelf(Context namingContext) throws NamingException {
        namingContext.bind(this.name, (Object)new LinkRef(this.global));
        PooledDataSourceRegistry.PooledDataSource pool = DataSourceHelper.getDataSource(this.global, PooledDataSourceRegistry.PooledDataSource.class);
        ((PooledDataSourceRegistry)Framework.getLocalService(PooledDataSourceRegistry.class)).createAlias(DataSourceHelper.relativize(this.name), pool);
    }

    public void unbindSelf(Context namingContext) throws NamingException {
        namingContext.unbind(this.name);
    }
}

