/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.util.jar;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.nuxeo.osgi.util.jar.JarFileCloser;
import org.nuxeo.osgi.util.jar.URLClassLoaderCloser;
import org.nuxeo.osgi.util.jar.URLJarFileCloser;
import org.nuxeo.osgi.util.jar.URLJarFileIntrospectionError;

public class URLJarFileIntrospector {
    protected Method factoryGetMethod;
    protected Method factoryCloseMethod;
    protected Field jarField;
    protected Method getJarFileMethod;
    Field ucpField;
    Field lmapField;
    Field loadersField;
    Field jarFileFactoryField;
    Object factory;

    public URLJarFileIntrospector() throws URLJarFileIntrospectionError {
        try {
            this.ucpField = URLClassLoader.class.getDeclaredField("ucp");
            this.ucpField.setAccessible(true);
            Class<?> ucpClass = URLJarFileIntrospector.loadClass("sun.misc.URLClassPath");
            this.lmapField = ucpClass.getDeclaredField("lmap");
            this.lmapField.setAccessible(true);
            this.loadersField = ucpClass.getDeclaredField("loaders");
            this.loadersField.setAccessible(true);
            Class<?> jarLoaderClass = URLJarFileIntrospector.loadClass("sun.misc.URLClassPath$JarLoader");
            this.jarField = jarLoaderClass.getDeclaredField("jar");
            this.jarField.setAccessible(true);
            this.getJarFileMethod = jarLoaderClass.getDeclaredMethod("getJarFile", URL.class);
            this.getJarFileMethod.setAccessible(true);
            Class<?> jarURLConnectionClass = URLJarFileIntrospector.loadClass("sun.net.www.protocol.jar.JarURLConnection");
            this.jarFileFactoryField = jarURLConnectionClass.getDeclaredField("factory");
            this.jarFileFactoryField.setAccessible(true);
            this.factory = this.jarFileFactoryField.get(null);
            Class<?> factoryClass = URLJarFileIntrospector.loadClass("sun.net.www.protocol.jar.JarFileFactory");
            this.factoryGetMethod = factoryClass.getMethod("get", URL.class);
            this.factoryGetMethod.setAccessible(true);
            this.factoryCloseMethod = factoryClass.getMethod("close", JarFile.class);
            this.factoryCloseMethod.setAccessible(true);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException cause) {
            throw new URLJarFileIntrospectionError("Cannot introspect url class loader jar files", cause);
        }
    }

    protected Object fetchFactory() throws URLJarFileIntrospectionError {
        try {
            return this.jarFileFactoryField.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException cause) {
            throw new URLJarFileIntrospectionError("Cannot access to factory", cause);
        }
    }

    protected static Class<?> loadClass(String name) throws ClassNotFoundException {
        return URLJarFileIntrospector.class.getClassLoader().loadClass(name);
    }

    public JarFileCloser newJarFileCloser(ClassLoader loader) throws URLJarFileIntrospectionError {
        return new URLJarFileCloser(this, loader);
    }

    protected URLClassLoaderCloser newURLClassLoaderCloser(URLClassLoader loader) throws URLJarFileIntrospectionError {
        try {
            Object ucp = this.ucpField.get(loader);
            Map index = (Map)this.lmapField.get(ucp);
            List loaders = (List)this.loadersField.get(ucp);
            return new URLClassLoaderCloser(this, index, loaders);
        }
        catch (IllegalAccessException | IllegalArgumentException cause) {
            throw new URLJarFileIntrospectionError("Cannot unwrap url class loader fields", cause);
        }
    }

    public void close(URL location) throws IOException {
        JarFile jar = null;
        try {
            jar = (JarFile)this.factoryGetMethod.invoke(this.factory, location);
            this.factoryCloseMethod.invoke(this.factory, jar);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot use reflection on jar file factory", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Cannot use reflection on jar file factory", e);
        }
        jar.close();
    }
}

