/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.StreamRef;
import org.nuxeo.runtime.model.URLStreamRef;
import org.nuxeo.runtime.model.impl.ComponentDescriptorReader;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.osgi.OSGiRuntimeActivator;
import org.nuxeo.runtime.osgi.OSGiRuntimeContext;
import org.osgi.framework.Bundle;

public class DefaultRuntimeContext
implements RuntimeContext {
    private static final Log log = LogFactory.getLog(RuntimeContext.class);
    protected RuntimeService runtime;
    protected final ComponentDescriptorReader reader;
    protected final Map<String, ComponentName> deployedFiles;

    public DefaultRuntimeContext() {
        this(Framework.getRuntime());
    }

    public DefaultRuntimeContext(RuntimeService runtime) {
        this.runtime = runtime;
        this.reader = new ComponentDescriptorReader();
        this.deployedFiles = new Hashtable<String, ComponentName>();
    }

    public void setRuntime(RuntimeService runtime) {
        this.runtime = runtime;
    }

    @Override
    public RuntimeService getRuntime() {
        return this.runtime;
    }

    public Map<String, ComponentName> getDeployedFiles() {
        return this.deployedFiles;
    }

    @Override
    public URL getResource(String name) {
        return Thread.currentThread().getContextClassLoader().getResource(name);
    }

    @Override
    public URL getLocalResource(String name) {
        return Thread.currentThread().getContextClassLoader().getResource(name);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    @Override
    public RegistrationInfo deploy(URL url) throws Exception {
        return this.deploy(new URLStreamRef(url));
    }

    @Override
    public RegistrationInfo deploy(StreamRef ref) throws Exception {
        Bundle bundle;
        String name = ref.getId();
        if (this.deployedFiles.containsKey(name)) {
            return null;
        }
        RegistrationInfoImpl ri = this.createRegistrationInfo(ref);
        if (ri == null || ri.name == null) {
            return null;
        }
        log.debug((Object)("Deploying component from url " + name));
        ri.context = this;
        ri.xmlFileUrl = ref.asURL();
        if (ri.getBundle() != null && (bundle = OSGiRuntimeActivator.getInstance().getBundle(ri.getBundle())) != null) {
            ri.context = new OSGiRuntimeContext(bundle);
        }
        this.runtime.getComponentManager().register(ri);
        this.deployedFiles.put(name, ri.getName());
        return ri;
    }

    @Override
    public void undeploy(URL url) throws Exception {
        ComponentName name = this.deployedFiles.remove(url.toString());
        if (name == null) {
            throw new IllegalArgumentException("not deployed " + url);
        }
        this.runtime.getComponentManager().unregister(name);
    }

    @Override
    public void undeploy(StreamRef ref) throws Exception {
        ComponentName name = this.deployedFiles.remove(ref.getId());
        if (name == null) {
            throw new IllegalArgumentException("not deployed " + ref);
        }
        this.runtime.getComponentManager().unregister(name);
    }

    @Override
    public boolean isDeployed(URL url) {
        return this.deployedFiles.containsKey(url.toString());
    }

    @Override
    public boolean isDeployed(StreamRef ref) {
        return this.deployedFiles.containsKey(ref.getId());
    }

    @Override
    public RegistrationInfo deploy(String location) throws Exception {
        URL url = this.getLocalResource(location);
        if (url == null) {
            throw new IllegalArgumentException("No local resources was found with this name: " + location);
        }
        return this.deploy(url);
    }

    @Override
    public void undeploy(String location) throws Exception {
        URL url = this.getLocalResource(location);
        if (url == null) {
            throw new IllegalArgumentException("No local resources was found with this name: " + location);
        }
        this.undeploy(url);
    }

    @Override
    public boolean isDeployed(String location) {
        URL url = this.getLocalResource(location);
        if (url != null) {
            return this.isDeployed(url);
        }
        log.warn((Object)("No local resources was found with this name: " + location));
        return false;
    }

    @Override
    public void destroy() {
        Iterator<ComponentName> it = this.deployedFiles.values().iterator();
        ComponentManager mgr = this.runtime.getComponentManager();
        while (it.hasNext()) {
            ComponentName name = it.next();
            it.remove();
            mgr.unregister(name);
        }
    }

    @Override
    public Bundle getBundle() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistrationInfoImpl createRegistrationInfo(StreamRef ref) throws Exception {
        String source = FileUtils.read((InputStream)ref.getStream());
        String expanded = Framework.expandVars(source);
        try (ByteArrayInputStream in = new ByteArrayInputStream(expanded.getBytes());){
            RegistrationInfoImpl registrationInfoImpl = this.createRegistrationInfo(in);
            return registrationInfoImpl;
        }
    }

    public RegistrationInfoImpl createRegistrationInfo(InputStream in) throws Exception {
        return this.reader.read(this, in);
    }
}

