/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.EventStats;
import org.nuxeo.ecm.core.event.ReconnectedEventBundle;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.ReconnectedEventBundleImpl;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;

public class AsyncEventExecutor {
    private static final Log log = LogFactory.getLog(AsyncEventExecutor.class);

    public WorkManager getWorkManager() {
        return (WorkManager)Framework.getLocalService(WorkManager.class);
    }

    public void init() {
        WorkManager workManager = this.getWorkManager();
        if (workManager != null) {
            workManager.init();
        }
    }

    public boolean shutdown(long timeoutMillis) throws InterruptedException {
        WorkManager workManager = this.getWorkManager();
        if (workManager == null) {
            return true;
        }
        return workManager.shutdown(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public boolean waitForCompletion(long timeoutMillis) throws InterruptedException {
        WorkManager workManager = this.getWorkManager();
        return workManager.awaitCompletion(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void run(List<EventListenerDescriptor> listeners, EventBundle bundle) {
        for (EventListenerDescriptor listener : listeners) {
            EventBundle filtered = listener.filterBundle(bundle);
            if (filtered.isEmpty()) continue;
            this.getWorkManager().schedule(new ListenerWork(listener, filtered));
        }
    }

    public int getUnfinishedCount() {
        WorkManager workManager = this.getWorkManager();
        int n = 0;
        for (String queueId : workManager.getWorkQueueIds()) {
            n += workManager.getQueueSize(queueId, Work.State.SCHEDULED) + workManager.getQueueSize(queueId, Work.State.RUNNING);
        }
        return n;
    }

    public int getActiveCount() {
        WorkManager workManager = this.getWorkManager();
        int n = 0;
        for (String queueId : workManager.getWorkQueueIds()) {
            n += workManager.getQueueSize(queueId, Work.State.RUNNING);
        }
        return n;
    }

    protected static class ListenerWork
    extends AbstractWork {
        private static final long serialVersionUID = 1L;
        private static final int DEFAULT_RETRY_COUNT = 1;
        protected final String title;
        protected ReconnectedEventBundle bundle;
        protected String listenerName;
        protected int retryCount;
        protected transient EventListenerDescriptor listener;

        public ListenerWork(EventListenerDescriptor listener, EventBundle bundle) {
            Integer count;
            this.listenerName = listener.getName();
            this.bundle = bundle instanceof ReconnectedEventBundle ? (ReconnectedEventBundle)bundle : new ReconnectedEventBundleImpl(bundle, this.listenerName);
            LinkedList<String> l = new LinkedList<String>();
            LinkedList<String> docIds = new LinkedList<String>();
            String repositoryName = null;
            for (Event event : bundle) {
                DocumentModel source;
                String s = event.getName();
                EventContext ctx = event.getContext();
                if (ctx instanceof DocumentEventContext && (source = ((DocumentEventContext)ctx).getSourceDocument()) != null) {
                    s = s + "/" + source.getRef();
                    docIds.add(source.getId());
                    repositoryName = source.getRepositoryName();
                }
                l.add(s);
            }
            this.title = "Listener " + this.listenerName + " " + l;
            if (!docIds.isEmpty()) {
                this.setDocuments(repositoryName, docIds);
            }
            int n = this.retryCount = (count = listener.getRetryCount()) == null ? 1 : count;
            if (this.retryCount < 0) {
                this.retryCount = 1;
            }
        }

        @Override
        public String getCategory() {
            return this.listenerName;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public int getRetryCount() {
            return this.retryCount;
        }

        @Override
        public void work() throws Exception {
            EventService eventService = (EventService)Framework.getLocalService(EventService.class);
            this.listener = eventService.getEventListener(this.listenerName);
            if (this.listener == null) {
                throw new RuntimeException("Cannot find listener: " + this.listenerName);
            }
            this.listener.asPostCommitListener().handleEvent(this.bundle);
        }

        @Override
        public void cleanUp(boolean ok, Exception e) {
            super.cleanUp(ok, e);
            this.bundle.disconnect();
            if (e != null && !(e instanceof InterruptedException) && !(e instanceof ConcurrentUpdateException)) {
                log.error((Object)("Failed to execute async event " + this.bundle.getName() + " on listener " + this.listenerName), (Throwable)e);
            }
            if (this.listener != null) {
                EventStats stats = (EventStats)Framework.getLocalService(EventStats.class);
                if (stats != null) {
                    stats.logAsyncExec(this.listener, System.currentTimeMillis() - this.getStartTime());
                }
                this.listener = null;
            }
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getClass().getSimpleName());
            buf.append('(');
            buf.append(this.title);
            buf.append(", ");
            buf.append(this.getProgress());
            buf.append(", ");
            buf.append(this.getStatus());
            buf.append(')');
            return buf.toString();
        }
    }
}

